---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：89-Terraform状態一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **Vueコンポーネントの詳細**：terraform_list.vueを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/terraform/state.rb` (Terraform::Stateモデル定義)
- E-02: `app/controllers/projects/terraform_controller.rb` (コントローラー)
- E-03: `app/views/projects/terraform/index.html.haml` (ビューテンプレート)
- E-04: `app/helpers/projects/terraform_helper.rb` (ヘルパー)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンが `/:namespace/:project/-/terraform` | E-02 (resourcesルート) | ○ |
| C-02 | `authorize_can_read_terraform_state!`で認可チェック | E-02 (4, 13-15行目) | ○ |
| C-03 | indexアクションが空（Vue側でデータ取得） | E-02 (9行目) | ○ |
| C-04 | js_terraform_list_dataでVueにデータ渡し | E-04 (4-13行目) | ○ |
| C-05 | empty_state_imageをdataに含む | E-04 (6行目) | ○ |
| C-06 | project_pathをdataに含む | E-04 (7行目) | ○ |
| C-07 | terraform_adminで管理権限を渡す | E-04 (8行目) | ○ |
| C-08 | access_tokens_pathをdataに含む | E-04 (9行目) | ○ |
| C-09 | usernameをdataに含む | E-04 (10行目) | ○ |
| C-10 | terraform_api_urlをdataに含む | E-04 (11行目) | ○ |
| C-11 | Terraform::Stateがproject belongs_to | E-01 (14行目) | ○ |
| C-12 | Terraform::Stateがlocked_by_user belongs_to | E-01 (15行目) | ○ |
| C-13 | Terraform::Stateがversions has_many | E-01 (17-20行目) | ○ |
| C-14 | Terraform::Stateがlatest_version has_one | E-01 (22-25行目) | ○ |
| C-15 | locked?メソッドでlock_xidを確認 | E-01 (41-43行目) | ○ |
| C-16 | ビューでjs_terraform_list_dataを使用 | E-03 (11行目) | ○ |
| C-17 | Vue/GraphQL実装の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネントの詳細
  - 理由：`app/assets/javascripts/terraform/components/terraform_list.vue`を直接確認していない
  - 候補：terraform_list.vue

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認可チェック、ヘルパーのデータ生成
- 0: 低リスク - モデル構造、アソシエーション
- 1: 中リスク - Vue/GraphQL実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 認可チェック（read_terraform_state権限）が正しいか確認
- [ ] 管理権限（admin_terraform_state）の制御を確認
- [ ] Vue/GraphQLの実装を直接確認してデータフローを検証
- [ ] 削除API、ロック解除APIの実装を確認
