---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：9-OAuth認可画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **認可コードの有効期限設定**：Doorkeeper設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/doorkeeper/authorizations/new.html.haml` - OAuth認可画面ビューテンプレート（84行）
- E-02: `config/initializers/doorkeeper.rb` - Doorkeeper設定ファイル
- E-03: `config/routes.rb` - use_doorkeeper ルーティング設定（64行目）
- E-04: `app/models/doorkeeper/application.rb` - OAuthアプリケーションモデル
- E-05: `app/models/doorkeeper/access_grant.rb` - 認可コードモデル
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（15行目）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（10行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET/POST/DELETE `/oauth/authorize` でアクセス可能 | E-03 (use_doorkeeper) | ○ |
| C-02 | アプリケーション名が太字で表示される | E-01 (15-17行目) | ○ |
| C-03 | ユーザーアバターと名前が表示される | E-01 (18-24行目) | ○ |
| C-04 | 管理者には警告メッセージが表示される | E-01 (25-30行目 current_user.admin?) | ○ |
| C-05 | スコープがアコーディオン形式で表示される | E-01 (31-38行目) | ○ |
| C-06 | GitLab提供アプリには信頼性バッジが表示される | E-01 (39-44行目 gl_application?) | ○ |
| C-07 | サードパーティアプリには警告が表示される | E-01 (45-50行目) | ○ |
| C-08 | 認可フォームが2つ（authorize/deny）存在する | E-01 (60-83行目) | ○ |
| C-09 | 隠しフィールドでOAuthパラメータが送信される | E-01 (62-72行目) | ○ |
| C-10 | Authorizeボタンで認可承認処理が行われる | E-01 (73-76行目) | ○ |
| C-11 | Cancelボタン（DELETEメソッド）で拒否処理が行われる | E-01 (78-82行目 method: :delete) | ○ |
| C-12 | 関連機能No.88「OAuth2プロバイダ」が正しい | E-06 (15行目) | ○ |
| C-13 | 画面種別が「確認・認可画面」 | E-07 (10行目) | ○ |
| C-14 | ポインターイベント遅延が500msで設定されている | E-01 (1-11行目 JavaScript) | ○ |
| C-15 | リダイレクト先ドメインが表示される | E-01 (51-58行目) | ○ |
| C-16 | アプリケーション作成日時が表示される | E-01 (54-57行目 time_ago_in_words) | ○ |
| C-17 | PKCEパラメータ（code_challenge）がサポートされている | E-01 (70-71行目) | ○ |
| C-18 | 認可コードの有効期限は10分 | **根拠なし**（Doorkeeper標準設定だが確認必要） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-18**: 認可コードの有効期限（10分）はDoorkeeperのデフォルト設定だが、GitLabでの具体的な設定は確認が必要
  - 候補：`config/initializers/doorkeeper.rb` の `authorization_code_expires_in` 設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: OAuth 2.0の標準的な認可フローに準拠
- **1（中リスク）**: 管理者警告表示の適切性（管理者権限での認可リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] Doorkeeper設定で認可コード有効期限を確認
- [ ] GitLab提供アプリ（gl_application?）の判定条件を確認
- [ ] スコープ表示のローカライズ設定を確認
- [ ] PKCE対応の有効化状況を確認
- [ ] クリックジャッキング対策（ポインターイベント遅延）の有効性を確認
