---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：90-Kubernetesエージェント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Vueコンポーネントの詳細**：show.vueを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/clusters/agent.rb` (Clusters::Agentモデル定義)
- E-02: `app/controllers/projects/cluster_agents_controller.rb` (コントローラー)
- E-03: `app/views/projects/cluster_agents/show.html.haml` (ビューテンプレート)
- E-04: `app/helpers/projects/cluster_agents_helper.rb` (ヘルパー)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンが `/:namespace/:project/-/cluster_agents/:name` | E-02 (resourcesルート) | ○ |
| C-02 | `authorize_read_cluster_agent!`で認可チェック | E-02 (6行目) | ○ |
| C-03 | `set_kas_cookie`でKAS認証Cookie設定 | E-02 (7行目) | ○ |
| C-04 | showアクションで@agent_nameを設定 | E-02 (12-13行目) | ○ |
| C-05 | js_cluster_agent_details_dataでVueにデータ渡し | E-04 (4-15行目) | ○ |
| C-06 | agent_nameをdataに含む | E-04 (7行目) | ○ |
| C-07 | can_admin_vulnerabilityをdataに含む | E-04 (8行目) | ○ |
| C-08 | project_pathをdataに含む | E-04 (10行目) | ○ |
| C-09 | kas_addressをdataに含む | E-04 (11行目) | ○ |
| C-10 | kas_install_versionをdataに含む | E-04 (12行目) | ○ |
| C-11 | can_admin_clusterをdataに含む | E-04 (13行目) | ○ |
| C-12 | Clusters::Agentがproject belongs_to | E-01 (14行目) | ○ |
| C-13 | Clusters::Agentがagent_tokens has_many | E-01 (16行目) | ○ |
| C-14 | Clusters::Agentがactive_agent_tokens has_many | E-01 (17行目) | ○ |
| C-15 | Clusters::Agentがactivity_events has_many | E-01 (33行目) | ○ |
| C-16 | connected?メソッドでトークン接続状態確認 | E-01 (57-59行目) | ○ |
| C-17 | ACTIVITY_EVENT_LIMIT = 200 | E-01 (11行目) | ○ |
| C-18 | Vue/GraphQL実装の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネントの詳細
  - 理由：`app/assets/javascripts/clusters/agents/components/show.vue`を直接確認していない
  - 候補：show.vue, agent_token.vue

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認可チェック、ヘルパーのデータ生成
- 0: 低リスク - モデル構造、アソシエーション
- 1: 中リスク - Vue/GraphQL実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] 認可チェック（read_cluster_agent権限）が正しいか確認
- [ ] 管理権限（admin_cluster）の制御を確認
- [ ] Vue/GraphQLの実装を直接確認してデータフローを検証
- [ ] トークン作成/削除の処理フローを確認
- [ ] KAS Cookie設定の動作を確認
