---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：92-AWS設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **フロントエンドVue.jsコンポーネントの実装詳細**：根拠不足
  2. **将来の機能拡張計画**：コード削除予定のissue参照あり
  3. **CI変数との連携機能**：未実装の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/aws/configuration/index.html.haml`（1-7行）
- E-02: `app/controllers/projects/aws/configuration_controller.rb`（1-14行）
- E-03: `app/controllers/projects/aws/base_controller.rb`（1-40行）
- E-04: `config/routes/project.rb`（326-329行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（133行）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（93行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/aws/configuration` | E-04 | ○ |
| C-02 | コントローラー: `Projects::Aws::ConfigurationController#index` | E-02 | ○ |
| C-03 | 画面データはJSON形式でjs_dataとして渡される | E-01, E-02 | ○ |
| C-04 | js_dataは現在空のオブジェクト | E-02 (7行) | ○ |
| C-05 | admin_project_aws権限が必要 | E-03 (9, 12-17行) | ○ |
| C-06 | cloudseed_awsフィーチャーフラグが必要 | E-03 (10, 19-26行) | ○ |
| C-07 | フィーチャーフラグはユーザー、グループ、プロジェクト単位でチェック | E-03 (20-22行) | ○ |
| C-08 | 関連機能No.60 Kubernetesクラスター連携 | E-05 | ○ |
| C-09 | ビューはVue.jsコンポーネント(#js-aws-configuration)で実装 | E-01 (7行) | ○ |
| C-10 | track_eventでイベントトラッキングを実行 | E-02 (9行), E-03 (28-36行) | ○ |
| C-11 | ルートは/awsから/configurationにリダイレクト | E-04 (327行) | ○ |
| C-12 | BaseControllerを継承している | E-02 (5行) | ○ |
| C-13 | feature_categoryはnot_owned | E-03 (6行) | ○ |
| C-14 | urgencyはlow | E-03 (7行) | ○ |
| C-15 | 権限エラー時にtrack_event(:error_invalid_user)を実行 | E-03 (15行) | ○ |
| C-16 | フラグエラー時にtrack_event(:error_feature_flag_not_enabled)を実行 | E-03 (24行) | ○ |
| C-17 | fluid_layoutでない場合にlimit-container-widthを適用 | E-01 (5行) | ○ |
| C-18 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/projects/aws/` 配下のファイル
- 機能削除予定（https://gitlab.com/gitlab-org/gitlab/-/issues/478491）の詳細

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本処理フロー
- **0: 低リスク** - 権限チェックロジック
- **0: 低リスク** - フィーチャーフラグチェックロジック
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **2: 高リスク** - 機能削除予定（将来的なメンテナンス考慮）

## 6) レビュアーチェックリスト（最小）
- [ ] admin_project_aws権限のポリシー定義が存在するか確認
- [ ] cloudseed_awsフィーチャーフラグがFeature.ymlに定義されているか確認
- [ ] Vue.jsコンポーネントの実装がjs_dataの構造と一致するか確認
- [ ] 機能削除予定のissue #478491の進捗状況を確認
- [ ] 空のjs_dataが将来的に拡張される計画があるか確認
