---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：93-パッケージ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：フロントエンド側のAPI呼び出し未検証
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **削除処理のバックグラウンドジョブ**：コードファイル未読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/packages/packages/index.html.haml`（1-5行）
- E-02: `app/controllers/projects/packages/packages_controller.rb`（1-19行）
- E-03: `app/helpers/packages_helper.rb`（1-179行）
- E-04: `app/models/packages/package.rb`（1-269行）
- E-05: `config/routes/project.rb`（43行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（134行）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`（94行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/packages` | E-05 | ○ |
| C-02 | コントローラー: `Projects::Packages::PackagesController#index` | E-02 | ○ |
| C-03 | indexアクションは空実装でビューをレンダリング | E-02 (11行) | ○ |
| C-04 | showアクションもindexをレンダリング | E-02 (14-16行) | ○ |
| C-05 | Vue.jsコンポーネント(#js-vue-packages-list)で実装 | E-01 (5行) | ○ |
| C-06 | project_packages_template_dataでデータを構築 | E-01, E-03 | ○ |
| C-07 | can_delete_packagesで削除権限を判定 | E-03 (82-85行) | ○ |
| C-08 | show_package_registry_settingsで設定権限を判定 | E-03 (72-75行) | ○ |
| C-09 | 関連機能No.62 パッケージレジストリ | E-06 | ○ |
| C-10 | PackagesAccessをinclude | E-02 (6行) | ○ |
| C-11 | feature_categoryはpackage_registry | E-02 (8行) | ○ |
| C-12 | urgencyはlow | E-02 (9行) | ○ |
| C-13 | package_typeはenumで定義（maven, npm等） | E-04 (19-35行) | ○ |
| C-14 | statusはenumで定義（default, pending_destruction等） | E-04 (37行) | ○ |
| C-15 | 削除は論理削除でpending_destructionに変更 | E-04 (245-249行) | ○ |
| C-16 | MarkPackageFilesForDestructionWorkerで物理削除 | E-04 (248行) | ○ |
| C-17 | グループパッケージ一覧へのリンクを表示 | E-03 (116行) | ○ |
| C-18 | npm_instance_urlを設定 | E-03 (175行) | ○ |
| C-19 | settings_pathを条件付きで設定 | E-03 (119-123行) | ○ |
| C-20 | 空状態のイラスト画像パスを設定 | E-03 (173行) | ○ |
| C-21 | GraphQL APIでパッケージ一覧を取得 | **根拠なし** | △ |
| C-22 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義を読み込んでいないため、APIの詳細については根拠が不足
  - 候補：`app/graphql/types/packages/` 配下のファイル
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/packages_and_registries/` 配下のファイル
- PackagesAccess concernの実装詳細
  - 候補：`app/controllers/concerns/packages_access.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本構造
- **0: 低リスク** - ヘルパーでのテンプレートデータ構築
- **0: 低リスク** - パッケージモデルのenum定義
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - GraphQL APIの詳細（未検証）
- **1: 中リスク** - バックグラウンドジョブの詳細（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] PackagesAccess concernがverify_packages_enabled!を実装しているか確認
- [ ] destroy_package権限のポリシー定義が存在するか確認
- [ ] admin_package権限のポリシー定義が存在するか確認
- [ ] Vue.jsコンポーネントがGraphQL APIを正しく呼び出しているか確認
- [ ] MarkPackageFilesForDestructionWorkerの実装を確認
- [ ] パッケージタイプごとの表示・動作差異を確認
