---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：94-インフラレジストリ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：フロントエンド側のAPI呼び出し未検証
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **Terraformモジュール固有モデルの詳細**：ファイル未読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/packages/infrastructure_registry/index.html.haml`（1-5行）
- E-02: `app/controllers/projects/packages/infrastructure_registry_controller.rb`（1-19行）
- E-03: `app/models/packages/package.rb`（31行、147行）
- E-04: `config/routes/project.rb`（50-51行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（135行）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（95行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/terraform_module_registry` | E-04 (50行) | ○ |
| C-02 | 旧URLからリダイレクト | E-04 (51行) | ○ |
| C-03 | コントローラー: `Projects::Packages::InfrastructureRegistryController` | E-02 | ○ |
| C-04 | indexアクションは暗黙的（定義なし） | E-02 | ○ |
| C-05 | Vue.jsコンポーネント(#js-vue-packages-list)で実装 | E-01 (3行) | ○ |
| C-06 | resource_idとしてproject.idを設定 | E-01 (3行) | ○ |
| C-07 | page_typeは'project' | E-01 (4行) | ○ |
| C-08 | empty_list_illustrationを設定 | E-01 (5行) | ○ |
| C-09 | 関連機能No.62 パッケージレジストリ | E-05 | ○ |
| C-10 | PackagesAccessをinclude | E-02 (6行) | ○ |
| C-11 | feature_categoryはpackage_registry | E-02 (8行) | ○ |
| C-12 | urgencyはlow | E-02 (9行) | ○ |
| C-13 | package_type: terraform_moduleの定義あり | E-03 (31行) | ○ |
| C-14 | TerraformModule::Packageクラスへのマッピング | E-03 (147行) | ○ |
| C-15 | GraphQL APIでモジュール一覧を取得 | **根拠なし** | △ |
| C-16 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義を読み込んでいないため、APIの詳細については根拠が不足
  - 候補：`app/graphql/types/packages/` 配下のファイル
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/packages_and_registries/` 配下のファイル
- Terraformモジュール固有のモデル実装
  - 候補：`app/models/packages/terraform_module/package.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - リダイレクト設定
- **0: 低リスク** - コントローラーの基本構造
- **0: 低リスク** - ビューテンプレートのデータ属性
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - GraphQL APIの詳細（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] PackagesAccess concernがverify_packages_enabled!を実装しているか確認
- [ ] terraform_moduleタイプ専用のスコープ/クエリがあるか確認
- [ ] Vue.jsコンポーネントがGraphQL APIを正しく呼び出しているか確認
- [ ] TerraformModule::Packageクラスの実装を確認
- [ ] 空状態時のイラスト画像が正しく表示されるか確認
