---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：95-インフラレジストリ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **PackagePresenterの詳細実装**：ファイル未読込
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **削除処理のGraphQL Mutation**：未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/packages/infrastructure_registry/show.html.haml`（1-14行）
- E-02: `app/controllers/projects/packages/infrastructure_registry_controller.rb`（1-19行）
- E-03: `app/helpers/packages_helper.rb`（26-29行）
- E-04: `app/models/packages/package.rb`（91-93行）
- E-05: `config/routes/project.rb`（50行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（136行）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`（96行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/terraform_module_registry/:id` | E-05 | ○ |
| C-02 | コントローラー: `Projects::Packages::InfrastructureRegistryController#show` | E-02 | ○ |
| C-03 | showアクションでパッケージを取得 | E-02 (11-16行) | ○ |
| C-04 | Vue.jsコンポーネント(#js-vue-packages-detail)で実装 | E-01 (8行) | ○ |
| C-05 | terraform_module_presenterでデータ変換 | E-01 (8行), E-03 (26-29行) | ○ |
| C-06 | can_deleteで削除権限を判定 | E-01 (9行) | ○ |
| C-07 | project_nameを設定 | E-01 (11行) | ○ |
| C-08 | project_pathをroot_ancestor.full_pathから取得 | E-01 (12行) | ○ |
| C-09 | gitlab_hostを設定 | E-01 (13行) | ○ |
| C-10 | project_list_urlを設定 | E-01 (14行) | ○ |
| C-11 | 関連機能No.62 パッケージレジストリ | E-06 | ○ |
| C-12 | preload_pipelines_with_user_project_namespace_routeを使用 | E-02 (12-13行), E-04 (91-93行) | ○ |
| C-13 | for_projectsスコープでプロジェクト絞り込み | E-02 (14行) | ○ |
| C-14 | params[:id]でパッケージID取得 | E-02 (15行) | ○ |
| C-15 | breadcrumbでナビゲーションパスを設定 | E-01 (1-3行) | ○ |
| C-16 | svg_pathで空状態イラストを設定 | E-01 (10行) | ○ |
| C-17 | PackagePresenterの詳細実装 | **根拠なし** | △ |
| C-18 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PackagePresenterのソースコードを読み込んでいないため、JSONの詳細構造については根拠が不足
  - 候補：`app/presenters/packages/terraform_module/package_presenter.rb`
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/packages_and_registries/` 配下のファイル
- 削除処理のGraphQL Mutation実装
  - 候補：`app/graphql/mutations/packages/` 配下のファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーのパッケージ取得処理
- **0: 低リスク** - ビューテンプレートのデータ属性
- **0: 低リスク** - breadcrumb設定
- **1: 中リスク** - PackagePresenterの詳細（未検証）
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - 削除処理の詳細（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] PackagePresenterがto_jsonで正しいフォーマットを返すか確認
- [ ] destroy_package権限のポリシー定義が存在するか確認
- [ ] Vue.jsコンポーネントがpackageデータを正しく表示するか確認
- [ ] 削除後のリダイレクト先が正しいか確認
- [ ] gitlab_hostの取得方法（Gitlab.config.gitlab.host）が正しいか確認
- [ ] root_ancestor.full_pathの取得が正しいか確認
