---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：96-コンテナレジストリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：フロントエンド側のAPI呼び出し未検証
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **削除処理のバックグラウンドジョブ**：詳細未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/registry/repositories/index.html.haml`（1-5行）
- E-02: `app/controllers/projects/registry/repositories_controller.rb`（1-58行）
- E-03: `app/controllers/projects/registry/application_controller.rb`（1-22行）
- E-04: `app/helpers/container_registry/container_registry_helper.rb`（1-33行）
- E-05: `app/models/container_repository.rb`（1-100行）
- E-06: `config/routes/project.rb`（576-589行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（137行）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（97行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/container_registry` | E-06 (576行) | ○ |
| C-02 | コントローラー: `Projects::Registry::RepositoriesController#index` | E-02, E-06 (577行) | ○ |
| C-03 | indexアクションでHTML/JSON形式を分岐 | E-02 (11-15行) | ○ |
| C-04 | HTML形式でensure_root_container_repository!を実行 | E-02 (13行, 44-52行) | ○ |
| C-05 | Vue.jsコンポーネント(#js-container-registry)で実装 | E-01 (5行) | ○ |
| C-06 | project_container_registry_template_dataでデータ構築 | E-01 (5行), E-04 | ○ |
| C-07 | verify_registry_enabled!で有効確認 | E-03 (8, 16-17行) | ○ |
| C-08 | authorize_read_container_image!で権限確認 | E-03 (9行) | ○ |
| C-09 | Gitlab.config.registry.enabledでレジストリ有効確認 | E-03 (17行) | ○ |
| C-10 | 関連機能No.63 コンテナレジストリ | E-07 | ○ |
| C-11 | feature_categoryはcontainer_registry | E-03 (11行) | ○ |
| C-12 | urgencyはlow | E-03 (12行) | ○ |
| C-13 | statusはenumで定義 | E-05 (30行) | ○ |
| C-14 | delete_scheduledステータスあり | E-05 (30行) | ○ |
| C-15 | expiration_policy_cleanup_statusのenum定義 | E-05 (31行) | ○ |
| C-16 | destroyアクションでdelete_scheduled!を呼び出し | E-02 (23-30行) | ○ |
| C-17 | authorize_update_container_image!を削除前に確認 | E-02 (9行) | ○ |
| C-18 | connection_errorとinvalid_path_errorを渡す | E-04 (24-25行) | ○ |
| C-19 | show_cleanup_policy_linkを設定 | E-04 (20行) | ○ |
| C-20 | show_container_registry_settingsを設定 | E-04 (22行) | ○ |
| C-21 | GitlabApiClient.supports_gitlab_api?を確認 | E-04 (28行) | ○ |
| C-22 | add_page_startup_graphql_callでGraphQLを呼び出し | E-01 (2行) | ○ |
| C-23 | GraphQL APIの詳細実装 | **根拠なし** | △ |
| C-24 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義（get_container_repositories）を読み込んでいないため、APIの詳細については根拠が不足
  - 候補：`app/graphql/queries/container_registry/` 配下のファイル
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/packages_and_registries/container_registry/` 配下のファイル
- ConnectionErrorsHandlerの実装詳細
  - 候補：`app/controllers/concerns/registry/connection_errors_handler.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本構造
- **0: 低リスク** - 認証・認可ロジック
- **0: 低リスク** - レジストリ有効確認ロジック
- **0: 低リスク** - ヘルパーでのテンプレートデータ構築
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - GraphQL APIの詳細（未検証）
- **1: 中リスク** - 削除処理のバックグラウンドジョブ（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] get_container_repositories GraphQLクエリが正しく動作するか確認
- [ ] read_container_image権限のポリシー定義が存在するか確認
- [ ] update_container_image権限のポリシー定義が存在するか確認
- [ ] admin_container_image権限のポリシー定義が存在するか確認
- [ ] Vue.jsコンポーネントがGraphQL APIを正しく呼び出しているか確認
- [ ] ensure_root_container_repository!のルートリポジトリ作成ロジックを確認
- [ ] connection_errorとinvalid_path_errorの設定元を確認
- [ ] delete_scheduled!呼び出し後のバックグラウンドジョブを確認
