---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：97-Harbor連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **Harbor APIの詳細実装**：lib/gitlab/harbor/配下のファイル未読込
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **Integrations::Harborモデルの詳細**：ファイル未読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/harbor/repositories/index.html.haml`（1-11行）
- E-02: `app/controllers/projects/harbor/repositories_controller.rb`（1-16行）
- E-03: `app/controllers/concerns/harbor/repository.rb`（1-52行）
- E-04: `app/controllers/concerns/harbor/access.rb`（1-20行）
- E-05: `app/controllers/projects/harbor/application_controller.rb`（1-17行）
- E-06: `config/routes/project.rb`（478-483行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（138行）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv`（98行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/harbor/repositories` | E-06 (479行) | ○ |
| C-02 | コントローラー: `Projects::Harbor::RepositoriesController` | E-02 | ○ |
| C-03 | Harbor::Repositoryをinclude | E-02 (6行) | ○ |
| C-04 | indexアクションでHTML/JSON形式を分岐 | E-03 (5-12行) | ○ |
| C-05 | showアクションはindexをレンダリング | E-03 (14-16行) | ○ |
| C-06 | Vue.jsコンポーネント(#js-harbor-registry-list-project)で実装 | E-01 (3行) | ○ |
| C-07 | endpointを設定 | E-01 (3行) | ○ |
| C-08 | repository_urlを設定 | E-01 (6行) | ○ |
| C-09 | harbor_integration_project_nameを設定 | E-01 (7行) | ○ |
| C-10 | connection_errorとinvalid_path_errorを設定 | E-01 (9-10行) | ○ |
| C-11 | Harbor::Accessをinclude | E-05 (7行) | ○ |
| C-12 | before_action: authorize_read_harbor_registry! | E-04 (8行) | ○ |
| C-13 | feature_categoryはintegrations | E-04 (10行) | ○ |
| C-14 | Gitlab::Harbor::Queryでパラメータ検証 | E-03 (26-27行) | ○ |
| C-15 | 無効なパラメータで422エラーを返す | E-03 (30-34行) | ○ |
| C-16 | HarborSerializers::RepositorySerializerでレスポンス整形 | E-03 (37-43行) | ○ |
| C-17 | ページネーションはwith_paginationで処理 | E-03 (38行) | ○ |
| C-18 | containerメソッドは@projectを返す | E-02 (10-12行) | ○ |
| C-19 | Harbor APIの詳細実装 | **根拠なし** | △ |
| C-20 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitlab::Harbor::Queryの実装詳細を読み込んでいないため、パラメータ検証の詳細については根拠が不足
  - 候補：`lib/gitlab/harbor/query.rb`
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/packages_and_registries/harbor_registry/` 配下のファイル
- Integrations::Harborモデルの詳細
  - 候補：`app/models/integrations/harbor.rb`
- HarborSerializers::RepositorySerializerの詳細
  - 候補：`app/serializers/integrations/harbor_serializers/repository_serializer.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本構造
- **0: 低リスク** - concernによる処理分離
- **0: 低リスク** - エラーハンドリング（422応答）
- **1: 中リスク** - Harbor API連携の詳細（未検証）
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - パラメータ検証の詳細（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] Gitlab::Harbor::Queryの実装を確認
- [ ] read_harbor_registry権限のポリシー定義が存在するか確認
- [ ] Vue.jsコンポーネントがJSON APIを正しく呼び出しているか確認
- [ ] Integrations::Harborモデルでhostname, project_nameが正しく取得されるか確認
- [ ] HarborSerializers::RepositorySerializerのレスポンス形式を確認
- [ ] connection_errorとinvalid_path_errorの設定元（ConnectionErrorsHandler相当）を確認
