---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：98-インシデント一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細実装**：フロントエンド側のAPI呼び出し未検証
  2. **Vue.jsコンポーネントの実装詳細**：根拠不足
  3. **IncidentManagementFeatureFlagの詳細**：concernファイル未読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/incidents/index.html.haml`（1-4行）
- E-02: `app/controllers/projects/incidents_controller.rb`（1-53行）
- E-03: `app/helpers/projects/incidents_helper.rb`（1-21行）
- E-04: `config/routes/project.rb`（379行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（139行）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（99行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/incidents` | E-04 | ○ |
| C-02 | コントローラー: `Projects::IncidentsController#index` | E-02 | ○ |
| C-03 | indexアクションは空実装（ビューのみ） | E-02 (18行) | ○ |
| C-04 | Vue.jsコンポーネント(#js-incidents)で実装 | E-01 (4行) | ○ |
| C-05 | incidents_dataでテンプレートデータを構築 | E-01 (4行), E-03 | ○ |
| C-06 | authorize_read_issue!で権限チェック | E-02 (8行) | ○ |
| C-07 | check_incidents_feature_flagでフラグチェック | E-02 (13行) | ○ |
| C-08 | push_frontend_feature_flagでTodosフラグをプッシュ | E-02 (10-12行) | ○ |
| C-09 | 関連機能No.45 インシデント管理 | E-05 | ○ |
| C-10 | feature_categoryはincident_management | E-02 (15行) | ○ |
| C-11 | urgencyはlow | E-02 (16行) | ○ |
| C-12 | project-pathを設定 | E-03 (6行) | ○ |
| C-13 | new-issue-pathを設定 | E-03 (7行) | ○ |
| C-14 | incident-template-nameは'incident' | E-03 (8行) | ○ |
| C-15 | incident-typeは'incident' | E-03 (9行) | ○ |
| C-16 | can-create-incidentで作成権限を判定 | E-03 (15行) | ○ |
| C-17 | IssuesFinder経由でincidentタイプを取得 | E-02 (43-45行) | ○ |
| C-18 | IssuableActionsをinclude | E-02 (4行) | ○ |
| C-19 | GraphQL APIの詳細実装 | **根拠なし** | △ |
| C-20 | Vue.jsコンポーネントの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL APIのスキーマ定義を読み込んでいないため、APIの詳細については根拠が不足
  - 候補：`app/graphql/types/issue_type.rb`, `app/graphql/resolvers/issues_resolver.rb`
- Vue.jsフロントエンドコンポーネントのソースコードを読み込んでいないため、UIの詳細な挙動については根拠が不足
  - 候補：`app/assets/javascripts/incidents/` 配下のファイル
- IncidentManagementFeatureFlag concernの詳細
  - 候補：`app/controllers/concerns/incident_management_feature_flag.rb`
- create_issue_type_allowed?メソッドの実装
  - 候補：該当するヘルパーまたはconcern

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーの基本構造
- **0: 低リスク** - ヘルパーでのテンプレートデータ構築
- **0: 低リスク** - IssuesFinderでのincidentタイプフィルタ
- **1: 中リスク** - フロントエンドの詳細実装（未検証）
- **1: 中リスク** - GraphQL APIの詳細（未検証）
- **1: 中リスク** - フィーチャーフラグの詳細（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] IncidentManagementFeatureFlag concernの実装を確認
- [ ] read_issue権限のポリシー定義が存在するか確認
- [ ] create_issue_type_allowed?メソッドの実装を確認
- [ ] Vue.jsコンポーネントがGraphQL APIを正しく呼び出しているか確認
- [ ] notifications_todos_buttonsフィーチャーフラグの影響範囲を確認
- [ ] インシデントテンプレート（'incident'）の存在と内容を確認
