---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：99-インシデント詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **details_content部分テンプレートの詳細**：ファイル未読込
  2. **IssuableActions concernの詳細**：ファイル未読込
  3. **inc_relations_for_viewスコープの詳細**：Issue.rb部分読込

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/incidents/show.html.haml`（1-18行）
- E-02: `app/controllers/projects/incidents_controller.rb`（1-53行）
- E-03: `config/routes/project.rb`（379行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（140行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（100行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URL: `/:namespace_id/:project_id/-/incidents/:id` | E-03 | ○ |
| C-02 | コントローラー: `Projects::IncidentsController#show` | E-02 | ○ |
| C-03 | showはIssuableActions経由で提供される（暗黙） | E-02 (4行) | ○ |
| C-04 | load_incidentがbefore_actionで実行 | E-02 (9行) | ○ |
| C-05 | incidentメソッドでIssuesFinderを使用 | E-02 (22-30行) | ○ |
| C-06 | inc_relations_for_viewで関連データをプリロード | E-02 (26行) | ○ |
| C-07 | @issueと@noteableを設定 | E-02 (34, 37行) | ○ |
| C-08 | @noteを新規Note用に作成 | E-02 (38行) | ○ |
| C-09 | breadcrumbを設定 | E-01 (1-2行) | ○ |
| C-10 | page_titleを設定 | E-01 (4行) | ○ |
| C-11 | page_descriptionを設定 | E-01 (5行) | ○ |
| C-12 | page_card_attributesを設定 | E-01 (6行) | ○ |
| C-13 | relocation_targetがある場合canonical URLを設定 | E-01 (7-8行) | ○ |
| C-14 | design_managementスタイルを読み込み | E-01 (10行) | ○ |
| C-15 | incidentsスタイルを読み込み | E-01 (11行) | ○ |
| C-16 | issues_showスタイルを読み込み | E-01 (13行) | ○ |
| C-17 | limit-container-widthを適用（非fluidレイアウト時） | E-01 (15行) | ○ |
| C-18 | details_content部分テンプレートをレンダリング | E-01 (17行) | ○ |
| C-19 | 関連機能No.45 インシデント管理 | E-04 | ○ |
| C-20 | issuable_stylesheetを追加 | E-01 (12行) | ○ |
| C-21 | details_content部分テンプレートの詳細実装 | **根拠なし** | △ |
| C-22 | IssuableActions concernの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- details_content部分テンプレートの詳細を読み込んでいないため、UIの詳細については根拠が不足
  - 候補：`app/views/projects/issues/_details_content.html.haml`
- IssuableActions concernの詳細を読み込んでいないため、showアクションの実装については根拠が不足
  - 候補：`app/controllers/concerns/issuable_actions.rb`
- inc_relations_for_viewスコープの詳細
  - 候補：`app/models/issue.rb`内のスコープ定義

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL/ルーティング定義
- **0: 低リスク** - コントローラーのインシデント取得処理
- **0: 低リスク** - ビューテンプレートの基本構造
- **0: 低リスク** - スタイルシート読み込み
- **1: 中リスク** - details_content部分テンプレートの詳細（未検証）
- **1: 中リスク** - IssuableActions concernの詳細（未検証）
- **1: 中リスク** - 関連データのプリロード範囲（未検証）

## 6) レビュアーチェックリスト（最小）
- [ ] details_content部分テンプレートの実装を確認
- [ ] IssuableActions concernのshowアクション実装を確認
- [ ] inc_relations_for_viewスコープのプリロード内容を確認
- [ ] relocation_targetの設定条件を確認
- [ ] update_issue権限でのインシデント編集機能を確認
- [ ] インシデント固有のスタイル（incidents.scss）の内容を確認
- [ ] card_attributesメソッドの実装を確認
