---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 46
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：46 / 50、根拠なし：4
- 優先レビュー（高）
  1. **IT-047 Mattermost Webhook**：外部サービス連携の詳細テストコード未確認
  2. **IT-048 Slack Webhook**：外部サービス連携の詳細テストコード未確認
  3. **IT-049 Jira API連携**：WebMockによるスタブテストの詳細未確認
  4. **IT-050 Sentry API連携**：外部サービス連携の詳細テストコード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `spec/requests/api/projects_spec.rb`
- E-02: `spec/requests/api/users_spec.rb`
- E-03: `spec/requests/api/merge_requests_spec.rb`
- E-04: `spec/requests/api/integrations_spec.rb`
- E-05: `spec/requests/api/graphql_spec.rb`
- E-06: `spec/requests/api/commit_statuses_spec.rb`
- E-07: `spec/requests/api/ci/pipelines_spec.rb`
- E-08: `spec/requests/api/deployments_spec.rb`
- E-09: `spec/controllers/projects_controller_spec.rb`
- E-10: `spec/controllers/projects/import/jira_controller_spec.rb`
- E-11: `spec/controllers/projects/alerting/notifications_controller_spec.rb`
- E-12: `spec/controllers/jira_connect/subscriptions_controller_spec.rb`
- E-13: `spec/features/issuables/markdown_references/jira_spec.rb`
- E-14: `spec/features/error_tracking/user_sees_error_index_spec.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001 プロジェクト一覧取得テスト | E-01 | ○ |
| C-02 | IT-002 未認証ユーザーのプロジェクト一覧取得 | E-01 | ○ |
| C-03 | IT-003 プロジェクト作成テスト | E-01 | ○ |
| C-04 | IT-004 デフォルトブランチ指定でプロジェクト作成 | E-01 | ○ |
| C-05 | IT-005 トピックによるプロジェクトフィルタリング | E-01 | ○ |
| C-06 | IT-006 プロジェクト言語取得テスト | E-01 | ○ |
| C-07 | IT-007 ユーザー作成テスト（管理者） | E-02 | ○ |
| C-08 | IT-008 一般ユーザーによるユーザー作成失敗 | E-02 | ○ |
| C-09 | IT-009 ユーザー情報更新テスト | E-02 | ○ |
| C-10 | IT-010 2FA無効化テスト | E-02 | ○ |
| C-11 | IT-011 管理者の2FA無効化拒否 | E-02 | ○ |
| C-12 | IT-012 マージリクエスト一覧取得 | E-03 | ○ |
| C-13 | IT-013 未認証でのMR一覧取得 | E-03 | ○ |
| C-14 | IT-014 MRマージ状態再チェック（開発者） | E-03 | ○ |
| C-15 | IT-015 MRマージ状態再チェック（レポーター） | E-03 | ○ |
| C-16 | IT-016 インテグレーション一覧取得 | E-04 | ○ |
| C-17 | IT-017 非オーナーのインテグレーション取得拒否 | E-04 | ○ |
| C-18 | IT-018 Mattermostトリガー実行 | E-04 | ○ |
| C-19 | IT-019 非アクティブインテグレーションのトリガー失敗 | E-04 | ○ |
| C-20 | IT-020 Slackトリガー実行 | E-04 | ○ |
| C-21 | IT-021 クエリ実行テスト（POST） | E-05 | ○ |
| C-22 | IT-022 クエリ実行テスト（GET） | E-05 | ○ |
| C-23 | IT-023 ミューテーション実行（POST） | E-05 | ○ |
| C-24 | IT-024 ミューテーション拒否（GET） | E-05 | ○ |
| C-25 | IT-025 オペレーション名による選択 | E-05 | ○ |
| C-26 | IT-026 コミットステータス一覧取得 | E-06 | ○ |
| C-27 | IT-027 全コミットステータス取得 | E-06 | ○ |
| C-28 | IT-028 ステージでフィルタリング | E-06 | ○ |
| C-29 | IT-029 refでフィルタリング | E-06 | ○ |
| C-30 | IT-030 パイプライン一覧取得 | E-07 | ○ |
| C-31 | IT-031 スコープによるフィルタリング（running） | E-07 | ○ |
| C-32 | IT-032 スコープによるフィルタリング（finished） | E-07 | ○ |
| C-33 | IT-033 ブランチ/タグスコープフィルタリング | E-07 | ○ |
| C-34 | IT-034 無効なスコープでのエラー | E-07 | ○ |
| C-35 | IT-035 デプロイメント一覧取得 | E-08 | ○ |
| C-36 | IT-036 環境でフィルタリング | E-08 | ○ |
| C-37 | IT-037 updated_atフィルタリング | E-08 | ○ |
| C-38 | IT-038 finished_atフィルタリング（成功のみ） | E-08 | ○ |
| C-39 | IT-039 finished_atフィルタリングエラー（失敗時） | E-08 | ○ |
| C-40 | IT-040 プロジェクト作成時のサービス連携 | E-09 | ○ |
| C-41 | IT-041 Jiraインポート連携 | E-10 | ○ |
| C-42 | IT-042 アラート通知処理 | E-11 | ○ |
| C-43 | IT-043 Jira Connect連携 | E-12 | ○ |
| C-44 | IT-044 N+1クエリ回避テスト（Projects） | E-01 | ○ |
| C-45 | IT-045 パイプラインN+1回避テスト | E-07 | ○ |
| C-46 | IT-046 マージリクエストN+1回避テスト | E-03 | ○ |
| C-47 | IT-047 Mattermost Webhook | **根拠不足** | △ |
| C-48 | IT-048 Slack Webhook | **根拠不足** | △ |
| C-49 | IT-049 Jira API連携 | E-13 | △ |
| C-50 | IT-050 Sentry API連携 | E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- 外部サービス連携テスト（Mattermost/Slack/Jira/Sentry）の詳細なテストコード確認が不十分
  - 候補：`spec/services/integrations/` / `spec/lib/gitlab/hook_data/` / `spec/workers/integrations/`
- エンドツーエンドテストの詳細（spec/features）の網羅的な確認が未実施
  - 候補：`spec/features/projects/integrations/` / `spec/features/admin/integrations/`
- パフォーマンステスト関連の詳細確認が未実施
  - 候補：`spec/benchmarks/` / `spec/support/helpers/performance_helpers.rb`

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - 外部サービス連携テスト（IT-047〜IT-050）は、実際の外部サービスとの通信がWebMockでスタブ化されている可能性が高く、実環境での動作確認が必要
- **0: 低リスク** - API連携テスト（IT-001〜IT-039）は、実際のRSpecテストコードで十分に検証されている
- **0: 低リスク** - DB連携テスト（IT-044〜IT-046）は、N+1クエリ検出ツールで検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースがspec/requestsの実際のテストファイルと対応しているか確認
- [ ] 外部サービス連携テスト（IT-047〜IT-050）の詳細を追加調査
- [ ] 高優先度テストケース（IT-001〜IT-012）の前提条件・期待結果が妥当か確認
- [ ] テスト種別（API連携/コンポーネント連携/DB連携/外部サービス連携）の分類が適切か確認
- [ ] 備考欄のファイルパスが実在するか検証
