---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 128
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：128 / 128、根拠なし：0
- 優先レビュー（高）
  - なし（全ての項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/notify.rb`
- E-02: `app/mailers/emails/issues.rb`
- E-03: `app/mailers/emails/merge_requests.rb`
- E-04: `app/mailers/emails/notes.rb`
- E-05: `app/mailers/emails/pipelines.rb`
- E-06: `app/mailers/emails/pipeline_schedules.rb`
- E-07: `app/mailers/emails/profile.rb`
- E-08: `app/mailers/emails/projects.rb`
- E-09: `app/mailers/emails/groups.rb`
- E-10: `app/mailers/emails/members.rb`
- E-11: `app/mailers/emails/releases.rb`
- E-12: `app/mailers/emails/reviews.rb`
- E-13: `app/mailers/emails/pages_domains.rb`
- E-14: `app/mailers/emails/service_desk.rb`
- E-15: `app/mailers/emails/auto_devops.rb`
- E-16: `app/mailers/emails/admin_notification.rb`
- E-17: `app/mailers/emails/identity_verification.rb`
- E-18: `app/mailers/emails/imports.rb`
- E-19: `app/mailers/emails/work_items.rb`
- E-20: `app/mailers/emails/remote_mirrors.rb`
- E-21: `app/mailers/members/invite_mailer.rb`
- E-22: `app/mailers/members/access_denied_mailer.rb`
- E-23: `app/mailers/members/access_granted_mailer.rb`
- E-24: `app/mailers/members/access_requested_mailer.rb`
- E-25: `app/mailers/members/about_to_expire_mailer.rb`
- E-26: `app/mailers/members/invite_reminder_mailer.rb`
- E-27: `app/mailers/members/expiration_date_updated_mailer.rb`
- E-28: `app/mailers/members/invite_declined_mailer.rb`
- E-29: `app/mailers/members/invite_accepted_mailer.rb`
- E-30: `app/mailers/devise_mailer.rb`
- E-31: `app/mailers/abuse_report_mailer.rb`
- E-32: `app/mailers/repository_check_mailer.rb`
- E-33: `app/mailers/namespaces/rate_limiter_mailer.rb`
- E-34: `app/mailers/email_rejection_mailer.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new_issue_email - 新しいIssueが作成されたことを通知 | E-02 | ○ |
| C-02 | issue_due_email - Issueの期限が近づいていることを通知 | E-02 | ○ |
| C-03 | new_mention_in_issue_email - Issue内でメンションされたことを通知 | E-02 | ○ |
| C-04 | reassigned_issue_email - Issueのアサイン先が変更されたことを通知 | E-02 | ○ |
| C-05 | closed_issue_email - Issueがクローズされたことを通知 | E-02 | ○ |
| C-06 | relabeled_issue_email - Issueのラベルが変更されたことを通知 | E-02 | ○ |
| C-07 | removed_milestone_issue_email - Issueからマイルストーンが削除されたことを通知 | E-02 | ○ |
| C-08 | changed_milestone_issue_email - Issueのマイルストーンが変更されたことを通知 | E-02 | ○ |
| C-09 | issue_status_changed_email - Issueのステータスが変更されたことを通知 | E-02 | ○ |
| C-10 | issue_moved_email - Issueが別のプロジェクトに移動されたことを通知 | E-02 | ○ |
| C-11 | issue_cloned_email - Issueが複製されたことを通知 | E-02 | ○ |
| C-12 | import_issues_csv_email - CSVからIssueがインポートされた結果を通知 | E-02 | ○ |
| C-13 | issues_csv_email - IssueのCSVエクスポートが完了したことを通知 | E-02 | ○ |
| C-14 | new_merge_request_email - 新しいMerge Requestが作成されたことを通知 | E-03 | ○ |
| C-15 | new_mention_in_merge_request_email - Merge Request内でメンションされたことを通知 | E-03 | ○ |
| C-16 | push_to_merge_request_email - Merge Requestにプッシュがあったことを通知 | E-03 | ○ |
| C-17 | change_in_merge_request_draft_status_email - Merge Requestのドラフト状態が変更されたことを通知 | E-03 | ○ |
| C-18 | reassigned_merge_request_email - Merge Requestのアサイン先が変更されたことを通知 | E-03 | ○ |
| C-19 | changed_reviewer_of_merge_request_email - Merge Requestのレビュアーが変更されたことを通知 | E-03 | ○ |
| C-20 | relabeled_merge_request_email - Merge Requestのラベルが変更されたことを通知 | E-03 | ○ |
| C-21 | removed_milestone_merge_request_email - Merge Requestからマイルストーンが削除されたことを通知 | E-03 | ○ |
| C-22 | changed_milestone_merge_request_email - Merge Requestのマイルストーンが変更されたことを通知 | E-03 | ○ |
| C-23 | closed_merge_request_email - Merge Requestがクローズされたことを通知 | E-03 | ○ |
| C-24 | merged_merge_request_email - Merge Requestがマージされたことを通知 | E-03 | ○ |
| C-25 | request_review_merge_request_email - Merge Requestのレビューがリクエストされたことを通知 | E-03 | ○ |
| C-26 | merge_request_status_email - Merge Requestのステータスが変更されたことを通知 | E-03 | ○ |
| C-27 | merge_request_unmergeable_email - Merge Requestがマージ不可になったことを通知 | E-03 | ○ |
| C-28 | resolved_all_discussions_email - Merge Requestの全ディスカッションが解決されたことを通知 | E-03 | ○ |
| C-29 | merge_when_pipeline_succeeds_email - パイプライン成功時に自動マージが設定されたことを通知 | E-03 | ○ |
| C-30 | merge_requests_csv_email - Merge RequestのCSVエクスポートが完了したことを通知 | E-03 | ○ |
| C-31 | approved_merge_request_email - Merge Requestが承認されたことを通知 | E-03 | ○ |
| C-32 | unapproved_merge_request_email - Merge Requestの承認が取り消されたことを通知 | E-03 | ○ |
| C-33 | note_commit_email - コミットにコメントがあったことを通知 | E-04 | ○ |
| C-34 | note_issue_email - Issueにコメントがあったことを通知 | E-04 | ○ |
| C-35 | note_merge_request_email - Merge Requestにコメントがあったことを通知 | E-04 | ○ |
| C-36 | note_snippet_email - スニペットにコメントがあったことを通知 | E-04 | ○ |
| C-37 | note_design_email - デザインにコメントがあったことを通知 | E-04 | ○ |
| C-38 | note_wiki_page_email - Wikiページにコメントがあったことを通知 | E-04 | ○ |
| C-39 | pipeline_success_email - パイプラインが成功したことを通知 | E-05 | ○ |
| C-40 | pipeline_failed_email - パイプラインが失敗したことを通知 | E-05 | ○ |
| C-41 | pipeline_fixed_email - パイプラインが修正されたことを通知 | E-05 | ○ |
| C-42 | pipeline_schedule_owner_unavailable_email - パイプラインスケジュールのオーナーが利用不可になったことを通知 | E-06 | ○ |
| C-43 | new_user_email - 新しいユーザーアカウントが作成されたことを通知 | E-07 | ○ |
| C-44 | instance_access_request_email - インスタンスへのアクセスリクエストがあったことを通知 | E-07 | ○ |
| C-45 | user_admin_rejection_email - ユーザーのリクエストが管理者により却下されたことを通知 | E-07 | ○ |
| C-46 | user_deactivated_email - ユーザーアカウントが非アクティブ化されたことを通知 | E-07 | ○ |
| C-47 | new_ssh_key_email - SSHキーが追加されたことを通知 | E-07 | ○ |
| C-48 | new_gpg_key_email - GPGキーが追加されたことを通知 | E-07 | ○ |
| C-49 | bot_resource_access_token_about_to_expire_email - Botリソースアクセストークンの有効期限が近づいていることを通知 | E-07 | ○ |
| C-50 | access_token_created_email - 新しい個人アクセストークンが作成されたことを通知 | E-07 | ○ |
| C-51 | access_token_about_to_expire_email - 個人アクセストークンの有効期限が近づいていることを通知 | E-07 | ○ |
| C-52 | access_token_expired_email - 個人アクセストークンの有効期限が切れたことを通知 | E-07 | ○ |
| C-53 | access_token_revoked_email - 個人アクセストークンが取り消されたことを通知 | E-07 | ○ |
| C-54 | access_token_rotated_email - 個人アクセストークンがローテーションされたことを通知 | E-07 | ○ |
| C-55 | deploy_token_about_to_expire_email - デプロイトークンの有効期限が近づいていることを通知 | E-07 | ○ |
| C-56 | ssh_key_expired_email - SSHキーの有効期限が切れたことを通知 | E-07 | ○ |
| C-57 | ssh_key_expiring_soon_email - SSHキーの有効期限が近づいていることを通知 | E-07 | ○ |
| C-58 | unknown_sign_in_email - 未知の場所からのサインインがあったことを通知 | E-07 | ○ |
| C-59 | two_factor_otp_attempt_failed_email - 2要素認証の入力に失敗したことを通知 | E-07 | ○ |
| C-60 | enabled_two_factor_otp_email - ワンタイムパスワード認証が有効化されたことを通知 | E-07 | ○ |
| C-61 | enabled_two_factor_webauthn_email - WebAuthnデバイスまたはパスキーが登録されたことを通知 | E-07 | ○ |
| C-62 | disabled_two_factor_email - 2要素認証が無効化されたことを通知 | E-07 | ○ |
| C-63 | disabled_two_factor_otp_email - ワンタイムパスワード認証が削除されたことを通知 | E-07 | ○ |
| C-64 | disabled_two_factor_webauthn_email - WebAuthnデバイスまたはパスキーが削除されたことを通知 | E-07 | ○ |
| C-65 | new_email_address_added_email - 新しいメールアドレスが追加されたことを通知 | E-07 | ○ |
| C-66 | new_achievement_email - 新しいアチーブメントが授与されたことを通知 | E-07 | ○ |
| C-67 | project_was_moved_email - プロジェクトが移動されたことを通知 | E-08 | ○ |
| C-68 | project_was_exported_email - プロジェクトがエクスポートされたことを通知 | E-08 | ○ |
| C-69 | project_was_not_exported_email - プロジェクトのエクスポートが失敗したことを通知 | E-08 | ○ |
| C-70 | project_scheduled_for_deletion - プロジェクトが削除予定であることを通知 | E-08 | ○ |
| C-71 | repository_cleanup_success_email - リポジトリのクリーンアップが成功したことを通知 | E-08 | ○ |
| C-72 | repository_cleanup_failure_email - リポジトリのクリーンアップが失敗したことを通知 | E-08 | ○ |
| C-73 | repository_rewrite_history_success_email - リポジトリの履歴書き換えが成功したことを通知 | E-08 | ○ |
| C-74 | repository_rewrite_history_failure_email - リポジトリの履歴書き換えが失敗したことを通知 | E-08 | ○ |
| C-75 | pipeline_variables_migration_complete_email - パイプライン変数の移行が完了したことを通知 | E-08 | ○ |
| C-76 | repository_push_email - リポジトリへのプッシュがあったことを通知 | E-08 | ○ |
| C-77 | prometheus_alert_fired_email - Prometheusアラートが発火したことを通知 | E-08 | ○ |
| C-78 | inactive_project_deletion_warning_email - 非アクティブなプロジェクトが削除予定であることを警告 | E-08 | ○ |
| C-79 | group_was_exported_email - グループがエクスポートされたことを通知 | E-09 | ○ |
| C-80 | group_was_not_exported_email - グループのエクスポートが失敗したことを通知 | E-09 | ○ |
| C-81 | group_scheduled_for_deletion - グループが削除予定であることを通知 | E-09 | ○ |
| C-82 | member_access_granted_email - メンバーにアクセス権が付与されたことを通知 | E-10 | ○ |
| C-83 | invite_initial_email - プロジェクト/グループへの招待メール | E-21 | ○ |
| C-84 | access_denied_email - アクセスが拒否されたことを通知 | E-22 | ○ |
| C-85 | access_granted_email - アクセスが許可されたことを通知 | E-23 | ○ |
| C-86 | access_requested_email - アクセスがリクエストされたことを通知 | E-24 | ○ |
| C-87 | about_to_expire_email - メンバーシップの有効期限が近づいていることを通知 | E-25 | ○ |
| C-88 | invite_reminder_email - 招待のリマインダーメール | E-26 | ○ |
| C-89 | expiration_date_updated_email - メンバーシップの有効期限が変更されたことを通知 | E-27 | ○ |
| C-90 | invite_declined_email - 招待が辞退されたことを通知 | E-28 | ○ |
| C-91 | invite_accepted_email - 招待が承諾されたことを通知 | E-29 | ○ |
| C-92 | new_release_email - 新しいリリースが作成されたことを通知 | E-11 | ○ |
| C-93 | new_review_email - Merge Requestに新しいレビューが追加されたことを通知 | E-12 | ○ |
| C-94 | pages_domain_enabled_email - Pages ドメインが有効化されたことを通知 | E-13 | ○ |
| C-95 | pages_domain_disabled_email - Pages ドメインが無効化されたことを通知 | E-13 | ○ |
| C-96 | pages_domain_verification_succeeded_email - Pages ドメインの検証が成功したことを通知 | E-13 | ○ |
| C-97 | pages_domain_verification_failed_email - Pages ドメインの検証が失敗したことを通知 | E-13 | ○ |
| C-98 | pages_domain_auto_ssl_failed_email - Pages ドメインのSSL証明書取得が失敗したことを通知 | E-13 | ○ |
| C-99 | service_desk_thank_you_email - Service Deskへの問い合わせ受付完了の感謝メール | E-14 | ○ |
| C-100 | service_desk_new_note_email - Service Deskのチケットに新しいコメントがあったことを通知 | E-14 | ○ |
| C-101 | service_desk_new_participant_email - Service Deskに新しい参加者が追加されたことを通知 | E-14 | ○ |
| C-102 | service_desk_custom_email_verification_email - Service Deskカスタムメールの検証メール | E-14 | ○ |
| C-103 | service_desk_verification_triggered_email - Service Deskの検証がトリガーされたことを通知 | E-14 | ○ |
| C-104 | service_desk_verification_result_email - Service Deskの検証結果を通知 | E-14 | ○ |
| C-105 | autodevops_disabled_email - Auto DevOpsが無効化されたことを通知 | E-15 | ○ |
| C-106 | send_admin_notification - 管理者からの通知メール | E-16 | ○ |
| C-107 | send_unsubscribed_notification - 管理者通知の購読解除完了を通知 | E-16 | ○ |
| C-108 | verification_instructions_email - 本人確認の手順メール | E-17 | ○ |
| C-109 | verification_instructions_sent_to_secondary_email - セカンダリメールに確認コードが送信されたことを通知 | E-17 | ○ |
| C-110 | github_gists_import_errors_email - GitHub Gistsインポートがエラーで完了したことを通知 | E-18 | ○ |
| C-111 | project_import_complete - プロジェクトのインポートが完了したことを通知 | E-18 | ○ |
| C-112 | bulk_import_complete - 一括インポートが完了したことを通知 | E-18 | ○ |
| C-113 | bulk_import_csv_user_mapping - CSVによるユーザーマッピングの結果を通知 | E-18 | ○ |
| C-114 | csv_placeholder_reassignment_failed - CSVプレースホルダー再割り当てが失敗したことを通知 | E-18 | ○ |
| C-115 | import_source_user_reassign - インポートソースユーザーの再割り当て確認を通知 | E-18 | ○ |
| C-116 | import_source_user_rejected - インポートソースユーザーの再割り当てが却下されたことを通知 | E-18 | ○ |
| C-117 | import_source_user_complete - インポートソースユーザーの再割り当てが完了したことを通知 | E-18 | ○ |
| C-118 | import_work_items_csv_email - Work ItemのCSVインポートが完了したことを通知 | E-19 | ○ |
| C-119 | export_work_items_csv_email - Work ItemのCSVエクスポートが完了したことを通知 | E-19 | ○ |
| C-120 | remote_mirror_update_failed_email - リモートミラーの更新が失敗したことを通知 | E-20 | ○ |
| C-121 | password_change_by_admin - 管理者によるパスワード変更を通知 | E-30 | ○ |
| C-122 | user_admin_approval - ユーザーの管理者承認を通知 | E-30 | ○ |
| C-123 | reset_password_instructions - パスワードリセット手順を通知 | E-30 | ○ |
| C-124 | email_changed - メールアドレス変更を通知 | E-30 | ○ |
| C-125 | notify - 不正利用報告があったことを管理者に通知 | E-31 | ○ |
| C-126 | notify - リポジトリチェックが失敗したプロジェクトがあることを管理者に通知 | E-32 | ○ |
| C-127 | project_or_group_emails - 通知がレート制限により一時停止されたことを通知 | E-33 | ○ |
| C-128 | rejection - メールが拒否されたことを送信者に通知 | E-34 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての項目に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての通知項目がソースコードから直接抽出されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 通知名とソースコードのメソッド名が一致しているか
- [ ] カテゴリ分類が適切か
- [ ] 説明文が通知の目的を正確に表しているか
- [ ] Enterprise Edition（EE）専用の通知が含まれていないか確認（本一覧はCommunity Editionのみ対象）
