# 通知設計書 104-service_desk_verification_result_email

## 概要

本ドキュメントは、GitLabのService Deskカスタムメール機能において、カスタムメールの検証結果（成功または失敗）をプロジェクトオーナーおよびトリガーユーザーに通知するメールの設計を記載するものです。

### 本通知の処理概要

本通知は、Service Deskのカスタムメールアドレス検証が完了した際に、その結果（成功または失敗）をプロジェクトオーナーと検証を開始したユーザーに知らせるための通知です。

**業務上の目的・背景**：カスタムメール検証は非同期で行われるプロセスであり、検証メールの送受信には時間がかかります。検証が完了した際に結果を通知することで、ユーザーは検証の成否を確認し、失敗した場合は適切な対処を行うことができます。特に失敗時は具体的なエラー原因が通知されるため、トラブルシューティングに役立ちます。

**通知の送信タイミング**：検証プロセスが完了した時点で非同期送信されます。成功時は`ServiceDesk::CustomEmailVerifications::UpdateService`で、失敗時は`CreateService`のエラーハンドリングまたは`UpdateService`で送信されます。

**通知の受信者**：プロジェクトのオーナー全員と、検証を開始したユーザーです。メールアドレスが重複する場合は1通のみ送信されます。

**通知内容の概要**：検証結果（成功/失敗）、カスタムメールアドレス、プロジェクト名、失敗時は具体的なエラー原因と対処方法が含まれます。

**期待されるアクション**：成功時はプロジェクト設定で機能を有効化すること、失敗時は記載されたエラー原因に基づいて設定を修正し、再度検証を開始することが期待されます。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高 |
| リトライ | Sidekiqのデフォルト設定に準拠 |

### 送信先決定ロジック

1. `project.owners.map(&:email)`でプロジェクトオーナー全員のメールアドレスを取得
2. 検証をトリガーしたユーザーのメールを追加
3. `uniq(&:downcase)`で重複を除去
4. 各メールアドレスに対して通知を送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルトメールアドレス |
| 送信元名称 | GitLab |
| 件名 | `Verification result for custom email {email} for {project_name}` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

#### 成功時（HTML版）
```
Email successfully verified

Your email address {email_address} for the Service Desk of {project_name} was verified successfully.

To enable the custom email address, go to your project's Service Desk settings page.
```

#### 失敗時（HTML版）
```
Email could not be verified

We could not verify your email address {email_address} for the Service Desk of {project_name}.

[エラー種別に応じたメッセージ]
- SMTP host issue: We were not able to make a connection to the specified host or there was an SSL issue.
- Invalid credentials: The given credentials (username and password) were rejected by the SMTP server, or you need to explicitly set an authentication method.
- Verification email not received within timeframe: We did not receive the verification email we sent out to {email_address} in time.
- Incorrect From header: Check your forwarding settings and make sure the original email sender remains in the From header.
- Incorrect verification token: We could not verify that we received the email we sent to your email inbox.
- Read timeout: The SMTP server did not respond in time.
- Incorrect forwarding target: Forward all emails to the custom email address to {service_desk_incoming_address}.

To restart the verification process, go to your project's Service Desk settings page.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @service_desk_setting | Service Desk設定 | 引数として渡される | Yes |
| @verification | 検証オブジェクト | @service_desk_setting.custom_email_verification | Yes |
| project_link | プロジェクトURL | @service_desk_setting.project.web_url | Yes |
| project_name | プロジェクト名 | @service_desk_setting.project.human_name | Yes |
| email_address | カスタムメールアドレス | @service_desk_setting.custom_email | Yes |
| verify_email_address | 検証用メールアドレス | @service_desk_setting.custom_email_address_for_verification | Yes（失敗時） |
| settings_link | 設定ページURL | edit_project_url(project, anchor: 'js-service-desk') | Yes |
| service_desk_incoming_address | Service Desk受信アドレス | ServiceDesk::Emails.new(project).incoming_address | Yes（転送先エラー時） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ/システム | CreateService - SMTPエラー発生 | 即時 | SMTP接続エラー時 |
| バッチ/システム | UpdateService - 検証完了 | 検証成功時 | トークン検証成功 |
| バッチ/システム | UpdateService - 検証失敗 | 検証失敗時 | タイムアウトやトークン不一致等 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 検証完了時は必ず送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[検証プロセス完了] --> B{検証結果}
    B -->|成功| C[verification.mark_as_finished!]
    B -->|失敗| D[verification.mark_as_failed!]
    C --> E[notify_project_owners_and_user_about_result]
    D --> E
    E --> F[BaseService#notify_project_owners_and_user_with_email]
    F --> G[project.owners.map&:email 取得]
    G --> H[triggerer.email 追加]
    H --> I[重複除去]
    I --> J{各メールアドレスに対して}
    J --> K[Notify.service_desk_verification_result_email]
    K --> L[deliver_later]
    L --> J
    J --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| service_desk_settings | カスタムメール設定の取得 | |
| service_desk_custom_email_verifications | 検証状態・結果の取得 | |
| projects | プロジェクト情報の取得 | |
| users | オーナーユーザー情報の取得 | |
| members | プロジェクトオーナーの特定 | |

### テーブル別参照項目詳細

#### service_desk_custom_email_verifications

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| state | 検証状態（finished/failed） | |
| error | エラー種別 | 失敗時のみ |
| triggerer_id | トリガーユーザーID | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| service_desk_custom_email_verifications | UPDATE | 検証状態の更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTP接続エラー等 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab全体のメール送信レート制限に準拠 |
| 1日あたり上限 | GitLab全体のメール送信レート制限に準拠 |

### 配信時間帯

特に制限なし（イベント発生時に即時送信）

## セキュリティ考慮事項

- 検証失敗の詳細なエラーメッセージが含まれるが、SMTP認証情報は含まれない
- プロジェクト設定ページへの直接リンクが含まれる

## 備考

- 検証エラーは複数の種類があり、それぞれ異なるメッセージと対処方法が表示される
- エラー種別：smtp_host_issue, invalid_credentials, mail_not_received_within_timeframe, incorrect_from, incorrect_token, read_timeout, incorrect_forwarding_target

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

検証結果の状態管理を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | custom_email_verification.rb | `app/models/service_desk/custom_email_verification.rb` | 状態遷移、エラー種別のenum定義 |

**読解のコツ**: `state`と`error`カラムの値がビューテンプレートでの条件分岐に使用される。

#### Step 2: エントリーポイントを理解する

結果通知送信のトリガーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | base_service.rb | `app/services/service_desk/custom_email_verifications/base_service.rb` | notify_project_owners_and_user_about_resultの実装 |
| 2-2 | create_service.rb | `app/services/service_desk/custom_email_verifications/create_service.rb` | SMTPエラー時の通知呼び出し |

**主要処理フロー**:
1. **28-33行目（base_service.rb）**: notify_project_owners_and_user_about_resultの実装
2. **77行目（create_service.rb）**: エラー時の通知呼び出し

#### Step 3: メーラーを理解する

通知メールの生成処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | service_desk.rb | `app/mailers/emails/service_desk.rb` | service_desk_verification_result_emailメソッド |

**主要処理フロー**:
- **132-142行目**: service_desk_verification_result_email
- **134行目**: @verificationの取得
- **136-139行目**: 件名の生成

#### Step 4: ビューテンプレートを理解する

成功/失敗に応じた表示分岐を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | service_desk_verification_result_email.html.haml | `app/views/notify/service_desk_verification_result_email.html.haml` | 条件分岐による表示切り替え |

**主要処理フロー**:
- **18行目**: `@verification.finished?`による成功/失敗の分岐
- **30-67行目**: 各エラー種別に応じたメッセージ表示

### プログラム呼び出し階層図

```
ServiceDesk::CustomEmailVerifications::CreateService#handle_error_case
    │
    └─ notify_project_owners_and_user_about_result
           │
           └─ BaseService#notify_project_owners_and_user_with_email
                  │
                  └─ Notify.service_desk_verification_result_email(settings, email_address)
                         │
                         ├─ @service_desk_setting設定
                         │
                         ├─ @verification取得
                         │
                         └─ email_with_layout
                                │
                                └─ ビューテンプレートレンダリング
                                       │
                                       ├─ @verification.finished? → 成功メッセージ
                                       │
                                       └─ else → 失敗メッセージ + エラー詳細
```

### データフロー図

```
[入力]                        [処理]                              [出力]

verification.state      BaseService#notify_project         成功/失敗通知メール送信
（finished/failed）───▶ _owners_and_user_about_result ───▶ （各オーナー・トリガーユーザーへ）
                                   │
verification.error           ───▶  │
（エラー種別）                      │
                                   │
service_desk_setting        ───▶   │
（カスタムメール設定）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| base_service.rb | `app/services/service_desk/custom_email_verifications/base_service.rb` | ソース | 結果通知の共通処理 |
| create_service.rb | `app/services/service_desk/custom_email_verifications/create_service.rb` | ソース | SMTPエラー時の通知トリガー |
| service_desk.rb | `app/mailers/emails/service_desk.rb` | ソース | Service Deskメーラー |
| service_desk_verification_result_email.html.haml | `app/views/notify/service_desk_verification_result_email.html.haml` | テンプレート | HTML本文テンプレート |
| service_desk_verification_result_email.text.erb | `app/views/notify/service_desk_verification_result_email.text.erb` | テンプレート | テキスト本文テンプレート |
| custom_email_verification.rb | `app/models/service_desk/custom_email_verification.rb` | ソース | 検証状態モデル |
