# 通知設計書 106-send_admin_notification

## 概要

本ドキュメントは、GitLabの管理者機能において、管理者からユーザーに送信される一般的な通知メールの設計を記載するものです。

### 本通知の処理概要

本通知は、GitLab管理者がシステム全体のユーザーに対して任意のメッセージを送信するための通知です。

**業務上の目的・背景**：GitLabインスタンスの管理者は、メンテナンス予定、重要なアップデート情報、ポリシー変更などを全ユーザーまたは特定のユーザーに通知する必要があります。この通知機能により、管理者は個別のメール配信システムを使用することなく、GitLab内から直接ユーザーにメッセージを送信できます。

**通知の送信タイミング**：管理者が管理画面からメッセージを作成・送信した際に、非同期で送信されます。

**通知の受信者**：管理者が指定したユーザーです。ユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信されます。

**通知内容の概要**：管理者が入力した件名と本文がそのまま送信されます。また、購読解除（Unsubscribe）リンクが含まれます。

**期待されるアクション**：受信者は通知内容を確認し、必要に応じて指示に従います。今後の管理者通知を受け取りたくない場合は、購読解除リンクから解除できます。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later想定） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に準拠 |

### 送信先決定ロジック

指定されたユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信されます。これはユーザーが設定した通知用メールアドレス、または登録メールアドレスです。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルトメールアドレス |
| 送信元名称 | GitLab |
| 件名 | 管理者が指定した件名（GitLabプレフィックス付き） |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

#### HTML版（send_admin_notification.html.haml）
```
{管理者が入力した本文}

----

Don't want to receive updates from GitLab administrators?
[Unsubscribe リンク]
```

#### テキスト版（send_admin_notification.text.haml）
```
{管理者が入力した本文}

----

Don't want to receive updates from GitLab administrators?
Unsubscribe: {unsubscribe_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @body | メール本文（管理者入力） | 引数として渡される | Yes |
| @unsubscribe_url | 購読解除URL | unsubscribe_url(email: Base64.urlsafe_encode64(email)) | Yes |
| subj | 件名（管理者入力） | 引数として渡される | Yes |
| user_id | 対象ユーザーID | 引数として渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 管理画面操作 | 管理者による通知送信操作 | 管理者権限を持つユーザーによる操作 | 管理者通知の送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが購読解除済み | 管理者通知の購読を解除しているユーザー |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者が通知を作成] --> B[対象ユーザーを選択]
    B --> C[件名・本文を入力]
    C --> D[送信実行]
    D --> E{各ユーザーに対して}
    E --> F[User.find(user_id)]
    F --> G[notification_email_or_default取得]
    G --> H[unsubscribe_url生成]
    H --> I[email_with_layout]
    I --> J[deliver_later]
    J --> E
    E --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報の取得 | |
| emails | 通知用メールアドレスの取得 | notification_email設定時 |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | WHERE id = user_id |
| email | 登録メールアドレス | |
| notification_email | 通知用メールアドレス | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知では更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザー未検出 | User.find(user_id)が例外 | 例外がスローされる |
| 送信失敗 | SMTP接続エラー等 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab全体のメール送信レート制限に準拠 |
| 1日あたり上限 | GitLab全体のメール送信レート制限に準拠 |

### 配信時間帯

特に制限なし（管理者の操作に応じて送信）

## セキュリティ考慮事項

- 管理者権限を持つユーザーのみが送信可能
- 購読解除URLにはメールアドレスがBase64エンコードされて含まれる
- 本文はsimple_formatでHTMLエスケープされる

## 備考

- `Emails::AdminNotification.prepend_mod`によりEE機能で拡張される可能性がある
- 本文はsimple_formatメソッドで整形される（改行が`<br>`に変換される）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーの通知メールアドレス取得方法を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | notification_email_or_defaultメソッド |

**読解のコツ**: ユーザーが明示的に通知メールを設定している場合とデフォルトの場合の違いを理解する。

#### Step 2: メーラーを理解する

通知メールの生成処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admin_notification.rb | `app/mailers/emails/admin_notification.rb` | send_admin_notificationメソッド |

**主要処理フロー**:
- **5-11行目**: send_admin_notification
- **6行目**: User.find(user_id)
- **7行目**: notification_email_or_default取得
- **8行目**: unsubscribe_url生成
- **9行目**: @body設定
- **10行目**: email_with_layout

#### Step 3: ビューテンプレートを理解する

メール本文のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | send_admin_notification.html.haml | `app/views/notify/send_admin_notification.html.haml` | HTML形式の本文テンプレート |
| 3-2 | send_admin_notification.text.haml | `app/views/notify/send_admin_notification.text.haml` | テキスト形式の本文テンプレート |

**主要処理フロー**:
- **1行目**: simple_format @body - 本文の整形
- **5-7行目**: 購読解除リンクの表示

### プログラム呼び出し階層図

```
Notify.send_admin_notification(user_id, subj, body)
    │
    ├─ User.find(user_id)
    │
    ├─ user.notification_email_or_default
    │
    ├─ unsubscribe_url(email: Base64.urlsafe_encode64(email))
    │
    ├─ @body = body
    │
    └─ email_with_layout(to: email, subject: subject(subj))
           │
           └─ ビューテンプレートレンダリング
                  │
                  ├─ simple_format @body
                  │
                  └─ link_to 'Unsubscribe', @unsubscribe_url
```

### データフロー図

```
[入力]                        [処理]                              [出力]

user_id                 Notify.send_admin_notification      通知メール送信
（対象ユーザーID）───▶                                  ───▶ （ユーザーのメールアドレスへ）
                                   │
subj                         ───▶  │
（件名）                            │
                                   │
body                         ───▶  │
（本文）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| admin_notification.rb | `app/mailers/emails/admin_notification.rb` | ソース | 管理者通知メーラー |
| send_admin_notification.html.haml | `app/views/notify/send_admin_notification.html.haml` | テンプレート | HTML本文テンプレート |
| send_admin_notification.text.haml | `app/views/notify/send_admin_notification.text.haml` | テンプレート | テキスト本文テンプレート |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
