# 通知設計書 107-send_unsubscribed_notification

## 概要

本ドキュメントは、GitLabの管理者通知機能において、ユーザーが管理者通知の購読を解除した際に送信される確認メールの設計を記載するものです。

### 本通知の処理概要

本通知は、ユーザーがGitLab管理者からの通知の購読を解除したことを確認するための通知です。

**業務上の目的・背景**：管理者通知（send_admin_notification）には購読解除機能があり、ユーザーは今後の管理者からの通知を受け取らないように設定できます。購読解除が正常に処理されたことをユーザーに確認するため、この確認メールが送信されます。これにより、ユーザーは購読解除が成功したことを認識でき、誤って解除した場合は早期に気づくことができます。

**通知の送信タイミング**：ユーザーが購読解除リンクをクリックし、購読解除処理が完了した直後に送信されます。

**通知の受信者**：購読解除を行ったユーザー本人です。ユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信されます。

**通知内容の概要**：管理者通知の購読を解除したことの確認メッセージのみが含まれます。

**期待されるアクション**：受信者は購読解除が完了したことを確認します。誤って解除した場合は、GitLab管理者に連絡して再購読を依頼する必要があります。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later想定） |
| 優先度 | 低 |
| リトライ | Sidekiqのデフォルト設定に準拠 |

### 送信先決定ロジック

購読解除を行ったユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信されます。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルトメールアドレス |
| 送信元名称 | GitLab |
| 件名 | `Unsubscribed from GitLab administrator notifications` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

#### HTML版（send_unsubscribed_notification.html.haml）
```
You have been unsubscribed from receiving GitLab administrator notifications.
```

#### テキスト版（send_unsubscribed_notification.text.haml）
```
You have been unsubscribed from receiving GitLab administrator notifications.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| user_id | 対象ユーザーID | 引数として渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | 購読解除リンクのクリック | 購読解除処理が成功した | 管理者通知の購読解除完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 購読解除成功時は必ず送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーが購読解除リンクをクリック] --> B[購読解除処理]
    B --> C{購読解除成功?}
    C -->|No| D[エラー表示]
    C -->|Yes| E[send_unsubscribed_notification呼び出し]
    E --> F[User.find(user_id)]
    F --> G[notification_email_or_default取得]
    G --> H[email_with_layout]
    H --> I[deliver_later]
    I --> J[完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報の取得 | |
| emails | 通知用メールアドレスの取得 | notification_email設定時 |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | WHERE id = user_id |
| email | 登録メールアドレス | |
| notification_email | 通知用メールアドレス | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知では更新処理なし（購読解除処理は別途） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザー未検出 | User.find(user_id)が例外 | 例外がスローされる |
| 送信失敗 | SMTP接続エラー等 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab全体のメール送信レート制限に準拠 |
| 1日あたり上限 | GitLab全体のメール送信レート制限に準拠 |

### 配信時間帯

特に制限なし（ユーザーの操作に応じて即時送信）

## セキュリティ考慮事項

- 購読解除は本人のみが行えるようリンクの検証が行われる
- 確認メールは購読解除を行った本人にのみ送信される

## 備考

- このメール自体は「購読解除確認」であり、購読解除後も1回だけ送信される
- 再購読の方法についての案内は含まれていない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メーラーを理解する

通知メールの生成処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | admin_notification.rb | `app/mailers/emails/admin_notification.rb` | send_unsubscribed_notificationメソッド |

**主要処理フロー**:
- **13-17行目**: send_unsubscribed_notification
- **14行目**: User.find(user_id)
- **15行目**: notification_email_or_default取得
- **16行目**: email_with_layout

#### Step 2: ビューテンプレートを理解する

メール本文のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | send_unsubscribed_notification.html.haml | `app/views/notify/send_unsubscribed_notification.html.haml` | HTML形式の本文テンプレート |
| 2-2 | send_unsubscribed_notification.text.haml | `app/views/notify/send_unsubscribed_notification.text.haml` | テキスト形式の本文テンプレート |

### プログラム呼び出し階層図

```
Notify.send_unsubscribed_notification(user_id)
    │
    ├─ User.find(user_id)
    │
    ├─ user.notification_email_or_default
    │
    └─ email_with_layout(to: email, subject: subject(...))
           │
           └─ ビューテンプレートレンダリング
                  │
                  └─ 購読解除完了メッセージ
```

### データフロー図

```
[入力]                        [処理]                              [出力]

user_id                 Notify.send_unsubscribed           確認メール送信
（対象ユーザーID）───▶       _notification              ───▶ （ユーザーのメールアドレスへ）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| admin_notification.rb | `app/mailers/emails/admin_notification.rb` | ソース | 管理者通知メーラー |
| send_unsubscribed_notification.html.haml | `app/views/notify/send_unsubscribed_notification.html.haml` | テンプレート | HTML本文テンプレート |
| send_unsubscribed_notification.text.haml | `app/views/notify/send_unsubscribed_notification.text.haml` | テンプレート | テキスト本文テンプレート |
