# 通知設計書 108-verification_instructions_email

## 概要

本ドキュメントは、GitLabの本人確認（Identity Verification）機能において、サインイン時にユーザーの本人確認を行うための検証コード（ワンタイムトークン）を送信するメールの設計を記載するものです。

### 本通知の処理概要

本通知は、信頼されていないIPアドレスからのサインイン試行時や、Email-based MFA（メールベースの多要素認証）が有効な場合に、ユーザーの本人確認を行うための検証コードを送信する通知です。

**業務上の目的・背景**：GitLabでは、アカウントのセキュリティを強化するため、未知のIPアドレスからのサインインや、アカウントロック状態からの復旧時に本人確認を要求します。この本人確認プロセスにより、パスワードが漏洩した場合でも、メールアクセス権を持たない第三者によるアカウントへの不正アクセスを防止できます。

**通知の送信タイミング**：以下の状況で送信されます：
1. アカウントがロックされた状態でサインイン試行時（新規unlock_tokenが必要な場合）
2. 信頼されていないIPアドレスからのサインイン試行時
3. Email-based MFA（メールベースOTP）が有効なユーザーのサインイン時
4. ユーザーが検証コードの再送信をリクエストした時

**通知の受信者**：サインインを試みているユーザー本人、またはユーザーが指定したセカンダリメールアドレスです。

**通知内容の概要**：検証コード（ワンタイムトークン）、有効期限、セキュリティに関する注意事項（パスワード変更、2FA設定の推奨）が含まれます。

**期待されるアクション**：受信者は検証コードをサインイン画面に入力して本人確認を完了します。心当たりのないサインイン試行の場合は、パスワード変更と2FA設定が推奨されます。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 最高（セキュリティ関連） |
| リトライ | Sidekiqのデフォルト設定に準拠 |

### 送信先決定ロジック

1. デフォルトではユーザーの登録メールアドレス（`user.email`）に送信
2. ユーザーがセカンダリメールアドレスを指定した場合は、そのアドレスに送信（確認済みメールのみ）
3. `validate_single_recipient_in_email!`で単一の受信者であることを検証

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルトメールアドレス |
| 送信元名称 | GitLab |
| 件名 | `Verify your identity` |
| 形式 | HTML/テキスト（マルチパート） |
| 特殊ヘッダー | `X-Mailgun-Suppressions-Bypass: true` |

### 本文テンプレート

#### HTML版（verification_instructions_email.html.haml）
```
Help us protect your account

Before you sign in, we need to verify your identity. Enter the following code on the sign-in page.

[検証コード（大きく表示）]

If you have not recently tried to sign into GitLab, we recommend changing your password and setting up Two-Factor Authentication to keep your account safe. Your verification code expires after {expires_in_minutes} minutes.
```

#### テキスト版（verification_instructions_email.text.erb）
```
Help us protect your account

Before you sign in, we need to verify your identity. Enter the following code on the sign-in page.

{token}

If you have not recently tried to sign into GitLab, we recommend changing your password and setting up Two-Factor Authentication to keep your account safe. Your verification code expires after {expires_in_minutes} minutes.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @token | 検証コード（ワンタイムトークン） | 引数として渡される | Yes |
| @expires_in_minutes | トークン有効期限（分） | TOKEN_VALID_FOR_MINUTES定数 | Yes |
| @password_link | パスワード変更ページURL | edit_user_settings_password_url | Yes |
| @two_fa_link | 2FA設定ドキュメントURL | help_page_url(...) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | サインイン試行 | 信頼されていないIPアドレス | 新規IPからのアクセス |
| 画面操作 | サインイン試行 | アカウントロック中 | ロック解除のため |
| 画面操作 | サインイン試行 | Email-based MFA有効 | OTP検証のため |
| 画面操作 | 再送信リクエスト | ユーザーが再送信をクリック | 検証コードの再送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| send_rate_limited?(user) | レート制限に達している場合 |
| 2FAが有効 | 通常の2FAが設定されている場合はスキップ |
| QAリクエスト | Gitlab::Qa.request?がtrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サインイン試行] --> B{2FA有効?}
    B -->|Yes| C[通常のサインイン処理]
    B -->|No| D{requires_verify_email?}
    D -->|No| C
    D -->|Yes| E{send_rate_limited?}
    E -->|Yes| F[レート制限エラー表示]
    E -->|No| G{アカウントロック中?}
    G -->|Yes| H{unlock_token存在 & 未期限切れ?}
    H -->|Yes| I[検証画面表示]
    H -->|No| J[lock_and_send_verification_instructions]
    G -->|No| K{trusted_ip_address?}
    K -->|Yes| L{email_otp必要?}
    K -->|No| J
    L -->|Yes| M{email_otp存在 & 未期限切れ?}
    L -->|No| C
    M -->|Yes| I
    M -->|No| N[send_otp_with_email]
    J --> O[GenerateTokenService.execute]
    N --> O
    O --> P[Notify.verification_instructions_email]
    P --> Q[deliver_later]
    Q --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報の取得 | |
| emails | セカンダリメールの確認 | confirmed_atがnullでないもの |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | |
| email | 登録メールアドレス | |
| unlock_token | アンロックトークン（暗号化済み） | |
| email_otp | メールOTP（暗号化済み） | |
| email_otp_last_sent_at | OTP最終送信日時 | |
| email_otp_last_sent_to | OTP送信先メール | |
| email_otp_required_after | Email OTP必須開始日時 | |
| last_sign_in_at | 最終サインイン日時 | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | unlock_token、locked_at、email_otp関連の更新 |

#### users

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | unlock_token | 暗号化されたトークン | アカウントロック時 |
| UPDATE | locked_at | 現在時刻 | アカウントロック時 |
| UPDATE | email_otp | 暗号化されたOTP | Email OTP送信時 |
| UPDATE | email_otp_last_sent_at | 現在時刻 | Email OTP送信時 |
| UPDATE | email_otp_last_sent_to | 送信先メールアドレス | Email OTP送信時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| レート制限 | 短時間に複数回送信 | エラーメッセージ表示、待機を促す |
| 複数受信者エラー | 複数のメールアドレスが指定された | 例外をスロー |
| 送信失敗 | SMTP接続エラー等 | Sidekiqによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| email_verification_code_send | ユーザーごとのレート制限 |
| user_sign_in | サインイン試行のレート制限 |

### 配信時間帯

特に制限なし（セキュリティ上、即時送信が必要）

## セキュリティ考慮事項

- トークンはワンタイムで使用され、使用後または期限切れ後は無効化される
- トークンの有効期限は`TOKEN_VALID_FOR_MINUTES`で定義（通常数分間）
- `X-Mailgun-Suppressions-Bypass`ヘッダーにより、バウンスリストに登録されたアドレスにも送信可能
- パスワード変更と2FA設定を推奨するメッセージが含まれる
- レート制限により、ブルートフォース攻撃を防止

## 備考

- Email-based MFAはFeature Flagで制御される（`email_based_mfa`）
- 最初のログイン時（last_sign_in_atがnil）はスキップされる（アカウント作成時のDevise::Confirmableと重複を避けるため）
- トークン検証失敗時のログが記録される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

トークン生成と検証の仕組みを理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | generate_token_service.rb | `app/services/users/email_verification/generate_token_service.rb` | トークン生成ロジック |
| 1-2 | validate_token_service.rb | `app/services/users/email_verification/validate_token_service.rb` | トークン検証ロジック、TOKEN_VALID_FOR_MINUTES |

**読解のコツ**: トークンは生成時に暗号化され、DBには暗号化版が保存される。

#### Step 2: エントリーポイントを理解する

サインインフローでの検証処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | verifies_with_email.rb | `app/controllers/concerns/verifies_with_email.rb` | verify_with_email、send_verification_instructions_email |

**主要処理フロー**:
1. **21-36行目**: verify_with_email - メイン処理
2. **152-158行目**: lock_and_send_verification_instructions - ロック＆送信
3. **160-165行目**: send_verification_instructions_email - メール送信
4. **167-189行目**: send_otp_with_email - Email OTP送信
5. **201-229行目**: verify_email - 検証要否判定

#### Step 3: メーラーを理解する

通知メールの生成処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | identity_verification.rb | `app/mailers/emails/identity_verification.rb` | verification_instructions_emailメソッド |

**主要処理フロー**:
- **7-25行目**: verification_instructions_email
- **8行目**: validate_single_recipient_in_email!
- **10-13行目**: テンプレート変数の設定
- **15-19行目**: ヘッダーの設定（X-Mailgun-Suppressions-Bypass含む）
- **21-24行目**: mail_with_locale呼び出し

#### Step 4: ビューテンプレートを理解する

メール本文のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | verification_instructions_email.html.haml | `app/views/notify/verification_instructions_email.html.haml` | HTML形式の本文テンプレート |
| 4-2 | verification_instructions_email.text.erb | `app/views/notify/verification_instructions_email.text.erb` | テキスト形式の本文テンプレート |

### プログラム呼び出し階層図

```
SessionsController#create
    │
    └─ VerifiesWithEmail#verify_with_email（prepend_before_action）
           │
           ├─ find_user / find_verification_user
           │
           ├─ verify_token（トークン検証時）
           │      └─ ValidateTokenService#execute
           │
           └─ verify_email（検証要否判定）
                  │
                  ├─ requires_verify_email?
                  │      ├─ treat_as_locked?
                  │      ├─ trusted_ip_address?
                  │      └─ require_email_based_otp?
                  │
                  ├─ lock_and_send_verification_instructions
                  │      ├─ GenerateTokenService#execute（unlock_token）
                  │      ├─ user.lock_access!
                  │      └─ send_verification_instructions_email
                  │
                  └─ send_otp_with_email
                         ├─ GenerateTokenService#execute（email_otp）
                         ├─ user.save!
                         └─ send_verification_instructions_email
                                │
                                └─ Notify.verification_instructions_email(email, token: token)
                                       │
                                       ├─ validate_single_recipient_in_email!
                                       │
                                       ├─ @token, @expires_in_minutes設定
                                       │
                                       └─ mail_with_locale
                                              └─ deliver_later
```

### データフロー図

```
[入力]                        [処理]                              [出力]

サインイン情報          VerifiesWithEmail              ユーザーDBの更新
（username/password）───▶  #verify_with_email      ───▶ （unlock_token/email_otp）
                                   │
                                   │                      ───▶  検証コードメール送信
                                   │
IPアドレス              ───▶       │
Feature Flags           ───▶       │
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| verifies_with_email.rb | `app/controllers/concerns/verifies_with_email.rb` | ソース | メール検証コントローラーconcern |
| identity_verification.rb | `app/mailers/emails/identity_verification.rb` | ソース | 本人確認メーラー |
| generate_token_service.rb | `app/services/users/email_verification/generate_token_service.rb` | ソース | トークン生成サービス |
| validate_token_service.rb | `app/services/users/email_verification/validate_token_service.rb` | ソース | トークン検証サービス |
| verification_instructions_email.html.haml | `app/views/notify/verification_instructions_email.html.haml` | テンプレート | HTML本文テンプレート |
| verification_instructions_email.text.erb | `app/views/notify/verification_instructions_email.text.erb` | テンプレート | テキスト本文テンプレート |
