# 通知設計書 115-import_source_user_reassign

## 概要

本ドキュメントは、GitLabにおけるインポートソースユーザー再割り当て確認通知（import_source_user_reassign）の設計仕様を記述する。

### 本通知の処理概要

インポートソースユーザー再割り当て確認通知は、グループオーナーがプレースホルダーユーザーの貢献を特定のGitLabユーザーに再割り当てしようとした際に、その対象ユーザーに対して承認を求めるメール通知を送信する。

**業務上の目的・背景**：インポート時に作成されたプレースホルダーユーザーの貢献（コミット、Issue、MRなど）を実際のユーザーに再割り当てする際、対象ユーザーの同意が必要である。これはプライバシーと責任の観点から重要であり、ユーザーが知らないうちに他人の貢献が自分に帰属することを防ぐ。

**通知の送信タイミング**：グループオーナーが再割り当てをリクエストし、ImportSourceUserがawaiting_approval状態に遷移した時点で、非同期で送信される。

**通知の受信者**：再割り当て先として指定されたユーザー（reassign_to_user）に送信される。

**通知内容の概要**：インポート元のホスト名、元のユーザー情報、再割り当てをリクエストしたユーザー情報、および承認/拒否を行うためのリンクを含む。

**期待されるアクション**：受信者は詳細を確認し、再割り当てを承認するか拒否するかを決定する。リンクをクリックして承認/拒否ページにアクセスする。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 通常 |
| リトライ | Sidekiqデフォルト設定に従う |

### 送信先決定ロジック

ImportSourceUserレコードのreassign_to_userのnotification_email_or_defaultに送信される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンス設定に従う |
| 送信元名称 | GitLab |
| 件名 | `Reassignments in {group_full_path} waiting for review` |
| 形式 | テキスト |

### 本文テンプレート

```
{reassigned_by_name} ({reassigned_by_username}) wants to reassign contributions from {source_name} ({source_username}) on {source_hostname} to you in {destination_group}.

Review reassignment details: {reassignment_review_url}

Import details:
Imported from: {source_hostname}
Original user: {source_name} ({source_username})

Reassignment details:
Imported to: {destination_group}
Reassigned to: {reassign_to_name} ({reassign_to_username})
Reassigned by: {reassigned_by_name} ({reassigned_by_username})

For more information, see accept contribution reassignment ({help_link}). If you do not recognize this request, report abuse ({report_link}).
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @source_user | インポートソースユーザー | Import::SourceUser.find(source_user_id) | Yes |
| @reassign_to_user | 再割り当て先ユーザー | @source_user.reassign_to_user | Yes |
| source_hostname | インポート元ホスト名 | @source_user.source_hostname | Yes |
| source_name | 元ユーザー名 | @source_user.source_name | Yes |
| source_username | 元ユーザー名（@付き） | @source_user.source_username | Yes |
| reassigned_by | 再割り当て実行者 | @source_user.reassigned_by_user | Yes |
| destination_group | インポート先グループ | @source_user.namespace | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス呼び出し | send_user_reassign_email（BaseService） | awaiting_approval状態への遷移成功時 | 再割り当てリクエスト時に送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 状態遷移失敗 | awaiting_approval状態への遷移に失敗した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[グループオーナーが再割り当てリクエスト] --> B[RequestReassignmentService実行]
    B --> C{状態遷移成功?}
    C -->|Yes| D[send_user_reassign_email]
    C -->|No| E[エラー応答]
    D --> F[Notify.import_source_user_reassign.deliver_later]
    F --> G[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| import_source_users | ソースユーザー情報取得 | |
| users | 再割り当て先ユーザー、実行者情報取得 | |
| namespaces | 名前空間情報取得 | |

### テーブル別参照項目詳細

#### import_source_users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ソースユーザー特定 | Import::SourceUser.find(source_user_id) |
| source_hostname | インポート元ホスト名 | |
| source_name | 元ユーザー名 | |
| source_username | 元ユーザー名 | |
| reassign_to_user_id | 再割り当て先ユーザーID | |
| reassigned_by_user_id | 実行者ID | |
| namespace_id | 名前空間ID | |
| reassignment_token | 承認用トークン | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理自体ではDB更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| SourceUser未存在 | Import::SourceUser.findで見つからない | ActiveRecord::RecordNotFoundが発生 |
| メール送信失敗 | SMTPエラー等 | Sidekiqのリトライに委ねる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト設定 |
| リトライ間隔 | Sidekiqデフォルト設定 |
| リトライ対象エラー | メール送信に関連するエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | システム設定に従う |
| 1日あたり上限 | システム設定に従う |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- reassignment_tokenは一意の32文字のトークンで、承認URLに含まれる
- トークンはawaiting_approval状態でのみ有効
- 承認/拒否URLはトークンベースで認証され、対象ユーザーのみがアクセス可能
- 不審なリクエストの場合は不正利用報告ページへのリンクを提供

## 備考

- reassignment_tokenはawaiting_approval状態への遷移時に自動生成される（32文字のランダム文字列）
- 承認後はreassignment_tokenがクリアされ、同じURLは無効になる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ImportSourceUserモデルの構造と状態遷移を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | import_source_user.rb | `app/models/import/source_user.rb` | ステートマシン、reassignment_token生成、関連ユーザー |

**読解のコツ**: before_transition any => :awaiting_approvalでトークン生成される点に注目

#### Step 2: サービス層を理解する

再割り当てリクエストのサービス層を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | base_service.rb | `app/services/import/source_users/base_service.rb` | send_user_reassign_email |

**主要処理フロー**:
- **27-29行目**: send_user_reassign_emailでNotify.import_source_user_reassignを呼び出し

#### Step 3: メーラー実装を理解する

メール本文生成ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | imports.rb | `app/mailers/emails/imports.rb` | import_source_user_reassignメソッド（98-110行目） |

**主要処理フロー**:
- **98-110行目**: SourceUserの取得、reassign_to_userの取得、件名設定

#### Step 4: テンプレートを理解する

メール本文テンプレートの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | import_source_user_reassign.text.erb | `app/views/notify/import_source_user_reassign.text.erb` | 変数展開、リンク構築 |

**主要処理フロー**:
- **1-9行目**: テンプレート変数の準備
- **10-11行目**: ヘルプリンクと不正利用報告リンク
- **12-17行目**: メイン説明文
- **19-30行目**: インポート詳細と再割り当て詳細

### プログラム呼び出し階層図

```
RequestReassignmentService（または他のサービス）
    │
    ├─ import_source_user.reassign!
    │      │
    │      └─ before_transition (reassignment_token生成)
    │
    └─ send_user_reassign_email (BaseService)
           │
           └─ Notify.import_source_user_reassign.deliver_later
                  │
                  ├─ Import::SourceUser.find
                  │      ├─ reassign_to_user
                  │      ├─ reassigned_by_user
                  │      └─ namespace
                  │
                  └─ email_with_layout
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

グループオーナーの           サービス層
再割り当てリクエスト ──────▶ (RequestReassignmentService)
                                      │
                                      ▼
                               状態遷移（awaiting_approval）
                                      │
                                      ├─ reassignment_token生成
                                      │
                                      ▼
source_user_id ───────────────▶ Notify.import_source_user_reassign ───▶ メール送信
                                      │                                    │
ImportSourceUser ─────────────────────┤                                    │
    │                                 │                                    │
    ├─ source_hostname ───────────────┤                                    │
    ├─ source_name ───────────────────┤                                    │
    ├─ source_username ───────────────┤                                    │
    ├─ reassign_to_user ──────────────┤                                    │
    ├─ reassigned_by_user ────────────┤                                    │
    ├─ namespace ─────────────────────┤                                    │
    └─ reassignment_token ────────────┘                                    │
                                                                           ▼
                                                                    承認/拒否ページ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| import_source_user.rb | `app/models/import/source_user.rb` | ソース | ImportSourceUserモデル、ステートマシン |
| base_service.rb | `app/services/import/source_users/base_service.rb` | ソース | メール送信メソッド定義 |
| imports.rb | `app/mailers/emails/imports.rb` | ソース | メーラーメソッド定義 |
| import_source_user_reassign.text.erb | `app/views/notify/import_source_user_reassign.text.erb` | テンプレート | メール本文テンプレート |
| imports_spec.rb | `spec/mailers/emails/imports_spec.rb` | テスト | メーラーのテスト仕様 |
