# 通知設計書 117-import_source_user_complete

## 概要

本ドキュメントは、GitLabにおけるインポートソースユーザー再割り当て完了通知（import_source_user_complete）の設計仕様を記述する。

### 本通知の処理概要

インポートソースユーザー再割り当て完了通知は、プレースホルダーユーザーの貢献の再割り当てが完了した際に、再割り当て先のユーザーに対してその完了を通知するメールを送信する。

**業務上の目的・背景**：ユーザーマッピングの再割り当てが完了すると、対象ユーザーの名前で過去の貢献（コミット、Issue、MRなど）が表示されるようになる。本通知により、再割り当て完了の事実をユーザーに報告し、自身の貢献履歴に変更があったことを認識させる。特に管理者バイパス機能により承認なしで再割り当てが行われた場合に重要である。

**通知の送信タイミング**：ReassignPlaceholderUserRecordsWorkerで再割り当て処理が完了し、confirmation_skippedフラグがtrueの場合に、非同期で送信される。

**通知の受信者**：再割り当て先ユーザー（reassign_to_user）に送信される。アクティブなユーザーのみが対象。

**通知内容の概要**：インポート元のホスト名、元のプレースホルダー情報、再割り当てを実行したユーザー情報、および問い合わせ先の案内を含む。

**期待されるアクション**：受信者は自分のアカウントに新しい貢献が割り当てられたことを認識する。不明点がある場合は、再割り当てを実行したユーザー（グループオーナーまたは管理者）に連絡する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 通常 |
| リトライ | Sidekiqデフォルト設定に従う |

### 送信先決定ロジック

ImportSourceUserレコードのreassign_to_userのnotification_email_or_defaultに送信される。ただし、reassign_to_user.active?がtrueの場合のみ。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンス設定に従う |
| 送信元名称 | GitLab |
| 件名 | `Reassignments in {group_full_path} completed` |
| 形式 | テキスト |

### 本文テンプレート

```
You've been reassigned contributions and memberships in {destination_group} on {source_hostname}.

(管理者バイパス有効の場合)
For more information, contact {reassigned_by_name} or another administrator.

(管理者バイパス無効の場合)
For more information, contact {reassigned_by_name} or another group owner.

Import details:
Imported from: {source_hostname}
Imported to: {destination_group}

Reassignment details:
Reassigned from: {source_name} ({source_username})
Reassigned to: {reassign_to_name} ({reassign_to_username})
Reassigned by: {reassigned_by_name} ({reassigned_by_username})
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @source_user | インポートソースユーザー | Import::SourceUser.find(source_user_id) | Yes |
| @reassign_to_user | 再割り当て先ユーザー | @source_user.reassign_to_user | Yes |
| @admin_bypass_enabled | 管理者バイパス有効フラグ | Gitlab::CurrentSettings.allow_bypass_placeholder_confirmation | Yes |
| source_hostname | インポート元ホスト名 | @source_user.source_hostname | Yes |
| source_name | 元ユーザー名 | @source_user.source_name | Yes |
| source_username | 元ユーザー名（@付き） | @source_user.source_username | Yes |
| reassigned_by | 再割り当て実行者 | @source_user.reassigned_by_user | Yes |
| destination_group | インポート先グループ | @source_user.namespace | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バックグラウンドジョブ | ReassignPlaceholderUserRecordsWorker完了 | confirmation_skipped && reassign_to_user.active? | 再割り当て処理完了後に送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| confirmation_skippedがfalse | 通常の承認フローを経た場合は送信されない（承認時に既に認識済み） |
| reassign_to_userがinactive | 非アクティブユーザーには送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[再割り当て処理完了] --> B{confirmation_skipped?}
    B -->|No| C[送信なし]
    B -->|Yes| D{reassign_to_user.active?}
    D -->|No| C
    D -->|Yes| E[send_reassign_complete_email]
    E --> F[Notify.import_source_user_complete.deliver_later]
    F --> G[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| import_source_users | ソースユーザー情報取得 | |
| users | 再割り当て先ユーザー、実行者情報取得 | |
| namespaces | 名前空間情報取得 | |
| application_settings | 管理者バイパス設定取得 | allow_bypass_placeholder_confirmation |

### テーブル別参照項目詳細

#### import_source_users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ソースユーザー特定 | Import::SourceUser.find(source_user_id) |
| source_hostname | インポート元ホスト名 | |
| source_name | 元ユーザー名 | |
| source_username | 元ユーザー名 | |
| reassign_to_user_id | 再割り当て先ユーザーID | |
| reassigned_by_user_id | 実行者ID | |
| namespace_id | 名前空間ID | |

#### application_settings

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| allow_bypass_placeholder_confirmation | バイパス設定 | Gitlab::CurrentSettings |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理自体ではDB更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| SourceUser未存在 | Import::SourceUser.findで見つからない | ActiveRecord::RecordNotFoundが発生 |
| メール送信失敗 | SMTPエラー等 | Sidekiqのリトライに委ねる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト設定 |
| リトライ間隔 | Sidekiqデフォルト設定 |
| リトライ対象エラー | メール送信に関連するエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | システム設定に従う |
| 1日あたり上限 | システム設定に従う |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- confirmation_skippedは管理者バイパスまたはグループバイパスが有効な場合にtrueになる
- バイパス機能の使用は監査ログに記録される
- 問い合わせ先として管理者またはグループオーナーへの連絡を案内

## 備考

- 通常の承認フロー（ユーザーが承認）を経た場合、ユーザーは既に再割り当てを認識しているため通知は送信されない
- 管理者バイパス有効時は「administrator」、無効時は「group owner」という文言の違いがある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Workerを理解する

再割り当て処理のWorkerと完了通知の条件を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | reassign_placeholder_user_records_worker.rb | `app/workers/import/reassign_placeholder_user_records_worker.rb` | perform、send_reassign_complete_email |

**読解のコツ**: confirmation_skippedパラメータとactive?チェックの条件に注目

**主要処理フロー**:
1. **22-35行目**: performでサービス呼び出しと完了通知条件判定
2. **34行目**: confirmation_skipped && reassign_to_user.active?の条件
3. **58-60行目**: send_reassign_complete_emailでメール送信

#### Step 2: メーラー実装を理解する

メール本文生成ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | imports.rb | `app/mailers/emails/imports.rb` | import_source_user_completeメソッド（125-140行目） |

**主要処理フロー**:
- **125-140行目**: SourceUserの取得、admin_bypass_enabled判定、件名設定

#### Step 3: テンプレートを理解する

メール本文テンプレートの条件分岐を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | import_source_user_complete.text.erb | `app/views/notify/import_source_user_complete.text.erb` | 変数展開、admin_bypass分岐 |

**主要処理フロー**:
- **10-15行目**: メイン説明文
- **16-22行目**: admin_bypass_enabledによる問い合わせ先の分岐
- **24-31行目**: インポート詳細と再割り当て詳細

### プログラム呼び出し階層図

```
ReassignPlaceholderUserRecordsWorker#perform
    │
    ├─ Import::SourceUser.find_by_id
    │
    ├─ import_source_user_valid?
    │
    ├─ ReassignPlaceholderUserRecordsService#execute
    │
    ├─ DeletePlaceholderUserWorker.perform_async
    │
    └─ (confirmation_skipped && active?)
           │
           └─ send_reassign_complete_email
                  │
                  └─ Notify.import_source_user_complete.deliver_later
                         │
                         ├─ Import::SourceUser.find
                         │      ├─ reassign_to_user
                         │      ├─ reassigned_by_user
                         │      └─ namespace
                         │
                         ├─ Gitlab::CurrentSettings.allow_bypass_placeholder_confirmation
                         │
                         └─ email_with_layout
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

再割り当て処理完了 ──────────▶ ReassignPlaceholderUserRecordsWorker
                                      │
params['confirmation_skipped'] ───────┤
                                      │
                                      ▼
                               条件判定
                                      │
                                      ├─ confirmation_skipped? ──────┐
                                      └─ reassign_to_user.active? ───┤
                                                                     │
ImportSourceUser ─────────────────────────────────────────┬──────────▼
    │                                                     │
    ├─ source_hostname ───────────────────────────────────┤ Notify.import_source_user_complete
    ├─ source_name ───────────────────────────────────────┤            │
    ├─ source_username ───────────────────────────────────┤            ▼
    ├─ reassign_to_user ──────────────────────────────────┤      メール送信
    ├─ reassigned_by_user ────────────────────────────────┤
    └─ namespace ─────────────────────────────────────────┘

ApplicationSettings
    └─ allow_bypass_placeholder_confirmation ──────────▶ 問い合わせ先テキスト分岐
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| reassign_placeholder_user_records_worker.rb | `app/workers/import/reassign_placeholder_user_records_worker.rb` | ソース | 再割り当て処理Worker |
| import_source_user.rb | `app/models/import/source_user.rb` | ソース | ImportSourceUserモデル |
| imports.rb | `app/mailers/emails/imports.rb` | ソース | メーラーメソッド定義 |
| import_source_user_complete.text.erb | `app/views/notify/import_source_user_complete.text.erb` | テンプレート | メール本文テンプレート |
| imports_spec.rb | `spec/mailers/emails/imports_spec.rb` | テスト | メーラーのテスト仕様 |
