# 通知設計書 121-password_change_by_admin

## 概要

本ドキュメントは、GitLabにおける「管理者によるパスワード変更通知」メールの設計を記載します。管理者がユーザーのパスワードを変更した際に、対象ユーザーに通知されるメールです。

### 本通知の処理概要

本通知は、GitLabの管理者がユーザーアカウントのパスワードを変更した際に、セキュリティ上の理由から対象ユーザーに通知するメール機能です。

**業務上の目的・背景**：企業やチームでGitLabを運用する際、管理者がユーザーのパスワードをリセット・変更することがあります。このような変更は、パスワード忘れ対応や、セキュリティインシデント対応、退職者のアカウント管理などの理由で行われます。ユーザー本人が行った変更ではないため、セキュリティ上の透明性を確保するために、必ず対象ユーザーへ通知が行われます。これにより、不正なパスワード変更の早期発見にも寄与します。

**通知の送信タイミング**：管理者がGitLab管理画面またはAPI経由でユーザーのパスワードを変更し、`send_only_admin_changed_your_password_notification!`メソッドが呼び出された後、ユーザー情報が保存された際（`after_update`コールバック）に自動送信されます。

**通知の受信者**：パスワードが変更されたユーザー本人のメールアドレスに送信されます。管理者や他の関係者には送信されません。

**通知内容の概要**：管理者によってパスワードが変更されたことを伝えるシンプルなメッセージで、GitLabインスタンスのURLと、不明な場合は管理者に連絡するよう促す内容が含まれます。

**期待されるアクション**：受信者は、パスワード変更に心当たりがある場合は新しいパスワードでログインを行い、心当たりがない場合は速やかに管理者に連絡してセキュリティインシデントとして対応することが期待されます。

## 通知種別

メール（Email）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（after_updateコールバック内でDevise通知として送信） |
| 優先度 | 高（セキュリティ関連通知） |
| リトライ | Deviseのデフォルト動作に依存 |

### 送信先決定ロジック

パスワードが変更されたユーザー（`@resource`）の登録メールアドレスに送信されます。メールアドレスはUserモデルの`email`属性から取得されます。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `Gitlab.config.gitlab.email_from` |
| 送信元名称 | `Gitlab.config.gitlab.email_display_name` |
| 件名 | `Password changed by administrator` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTML版:**
```html
<h1>Hello, {ユーザー名}!</h1>
<p>An administrator changed the password for your GitLab account on <a href="{GitLab URL}">{GitLab URL}</a>.</p>
<p>Please contact your administrator with any questions.</p>
```

**テキスト版:**
```
Hello, {ユーザー名}!

An administrator changed the password for your GitLab account on {GitLab URL}.

Please contact your administrator with any questions.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @resource | パスワード変更対象ユーザー | Userモデル | Yes |
| @resource.name | ユーザー表示名 | users.name | Yes |
| Gitlab.config.gitlab.url | GitLabインスタンスURL | 設定ファイル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モデルコールバック | User#after_update | `send_admin_changed_your_password_notification?`がtrue | 暗号化パスワードが変更され、かつ`allow_admin_changed_your_password_notification`フラグがtrueの場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `allow_admin_changed_your_password_notification`がfalse/nil | 明示的に`send_only_admin_changed_your_password_notification!`が呼ばれていない場合は送信されない |
| 暗号化パスワードが変更されていない | `saved_change_to_encrypted_password?`がfalseの場合 |
| `send_password_change_notification`が無効 | クラス設定で無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者がパスワード変更操作] --> B[send_only_admin_changed_your_password_notification! 呼び出し]
    B --> C[skip_password_change_notification! でDeviseデフォルト通知をスキップ]
    C --> D[allow_admin_changed_your_password_notification! でフラグをtrue設定]
    D --> E[user.save! でユーザー情報保存]
    E --> F{after_update コールバック}
    F --> G{send_admin_changed_your_password_notification?}
    G -->|Yes| H[send_devise_notification :password_change_by_admin]
    G -->|No| I[送信スキップ]
    H --> J[DeviseMailer.password_change_by_admin 呼び出し]
    J --> K[メール送信]
    K --> L[終了]
    I --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 対象ユーザー情報の取得 | name, email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | メール本文の挨拶文に使用 | パスワード変更対象ユーザー |
| email | メール送信先 | パスワード変更対象ユーザー |
| encrypted_password | 変更検知 | saved_change_to_encrypted_password?で使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | メール送信のみで、DB更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Deviseのデフォルトエラーハンドリングに依存 |
| テンプレートエラー | テンプレートファイル不在 | ActionView::MissingTemplateエラーが発生 |
| 宛先不正 | ユーザーのメールアドレスが無効 | メール送信がバウンス |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Deviseデフォルト（0回） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（Devise管理） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（パスワード変更イベント発生時に即座に送信）

## セキュリティ考慮事項

- 本通知はセキュリティ上重要な通知であり、ユーザー本人以外には送信されない
- Deviseの`skip_password_change_notification!`により、通常のパスワード変更通知と二重送信されないように制御
- メール本文には新しいパスワードやパスワードリセットリンクは含まれない（セキュリティ上の理由）
- `validate_single_recipient_in_opts!`により、複数宛先への送信は防止される

## 備考

- 本通知はDeviseのカスタム通知として実装されており、`devise_mail`メソッドを通じて送信される
- Gitlab.com環境とセルフマネージド環境で同一の動作をする
- 件名には`email_subject_suffix`が設定されている場合、自動的に付加される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知の対象となるUserモデルと、パスワード変更の検知メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Userモデルの基本構造、AdminChangedPasswordNotifierのinclude |

**読解のコツ**: RailsのActiveRecordコールバック（`after_update`）の動作を理解していると読みやすい。

#### Step 2: 通知トリガーのメカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | admin_changed_password_notifier.rb | `app/models/concerns/admin_changed_password_notifier.rb` | 通知のトリガー条件、`send_only_admin_changed_your_password_notification!`メソッド |

**主要処理フロー**:
1. **行32-37**: `after_update`コールバックで`send_admin_changed_your_password_notification`を呼び出す条件を定義
2. **行39-42**: 公開API`send_only_admin_changed_your_password_notification!`でDeviseデフォルト通知スキップとフラグ設定
3. **行46-48**: 実際のDevise通知呼び出し

#### Step 3: メーラーの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | devise_mailer.rb | `app/mailers/devise_mailer.rb` | DeviseMailerクラス、`password_change_by_admin`メソッド |

**主要処理フロー**:
- **行21-23**: `password_change_by_admin`メソッドの定義、`devise_mail`を呼び出し

#### Step 4: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | password_change_by_admin.html.haml | `app/views/devise/mailer/password_change_by_admin.html.haml` | HTML版メールテンプレート |
| 4-2 | password_change_by_admin.text.erb | `app/views/devise/mailer/password_change_by_admin.text.erb` | テキスト版メールテンプレート |

**主要処理フロー**:
- **行1**: `email_default_heading`で挨拶文を生成
- **行3-4**: `admin_changed_password_text`ヘルパーで本文を生成
- **行5-6**: `contact_your_administrator_text`で問い合わせ案内を追加

#### Step 5: ヘルパーメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | emails_helper.rb | `app/helpers/emails_helper.rb` | `admin_changed_password_text`、`contact_your_administrator_text`の実装 |

**主要処理フロー**:
- **行297-306**: `admin_changed_password_text`でHTML/テキスト形式に応じたメッセージ生成
- **行421-423**: `contact_your_administrator_text`で管理者連絡の案内文を返却

### プログラム呼び出し階層図

```
User (モデル)
    │
    ├─ AdminChangedPasswordNotifier (concern)
    │      ├─ send_only_admin_changed_your_password_notification!
    │      │      ├─ skip_password_change_notification!
    │      │      └─ allow_admin_changed_your_password_notification!
    │      │
    │      └─ after_update コールバック
    │             └─ send_admin_changed_your_password_notification
    │                    └─ send_devise_notification(:password_change_by_admin)
    │
    └─ DeviseMailer
           └─ password_change_by_admin
                  └─ devise_mail(record, :password_change_by_admin)
                         └─ テンプレートレンダリング
                                ├─ password_change_by_admin.html.haml
                                └─ password_change_by_admin.text.erb
```

### データフロー図

```
[入力]                    [処理]                         [出力]

管理者操作
(パスワード変更)  ───▶  AdminChangedPasswordNotifier
                              │
                              ▼
User.save!        ───▶  after_update コールバック
                              │
                              ▼
                        DeviseMailer
                        .password_change_by_admin  ───▶  メール送信
                              │                          (対象ユーザー)
                              ▼
                        EmailsHelper
                        (テキスト生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| admin_changed_password_notifier.rb | `app/models/concerns/admin_changed_password_notifier.rb` | ソース | 通知トリガーのconcern |
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | ソース | Deviseメーラー |
| password_change_by_admin.html.haml | `app/views/devise/mailer/password_change_by_admin.html.haml` | テンプレート | HTML版メールテンプレート |
| password_change_by_admin.text.erb | `app/views/devise/mailer/password_change_by_admin.text.erb` | テンプレート | テキスト版メールテンプレート |
| emails_helper.rb | `app/helpers/emails_helper.rb` | ソース | メール本文生成ヘルパー |
| devise_mailer_spec.rb | `spec/mailers/devise_mailer_spec.rb` | テスト | メーラーのテスト |
