# 通知設計書 123-reset_password_instructions

## 概要

本ドキュメントは、GitLabにおける「パスワードリセット手順通知」メールの設計を記載します。ユーザーがパスワードリセットをリクエストした際に送信される、パスワードリセットリンクを含むメールです。

### 本通知の処理概要

本通知は、ユーザーがGitLabのログインページで「パスワードを忘れた」機能を使用した際に、パスワードリセット用のリンクを含むメールを送信する機能です。

**業務上の目的・背景**：ユーザーがパスワードを忘れた場合や、セキュリティ上の理由でパスワードを変更したい場合に、安全にパスワードをリセットするための標準的なフローを提供します。これはDeviseの標準機能をベースにしており、多くのWebアプリケーションで採用されているセキュアな認証フローです。

**通知の送信タイミング**：ユーザーがパスワードリセットフォームでメールアドレスを入力し、リセットリクエストを送信した際に、Deviseが自動的にメールを送信します。

**通知の受信者**：パスワードリセットをリクエストしたユーザーの登録メールアドレスに送信されます。

**通知内容の概要**：パスワードリセットのリクエストがあったことを伝え、リセットリンク（トークン付きURL）を案内します。本人がリクエストしていない場合は無視してよいことも伝えます。

**期待されるアクション**：受信者は、メールに記載されたリセットリンクをクリックし、新しいパスワードを設定します。リクエストした覚えがない場合は、メールを無視します。

## 通知種別

メール（Email）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | Deviseのデフォルト（設定により同期/非同期） |
| 優先度 | 高（ユーザーがアクションを待っている） |
| リトライ | Deviseのデフォルト動作に依存 |

### 送信先決定ロジック

パスワードリセットをリクエストしたユーザーの登録メールアドレスに送信されます。`opts[:to]`が指定されている場合はそちらが優先されます。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `Gitlab.config.gitlab.email_from` |
| 送信元名称 | `Gitlab.config.gitlab.email_display_name` |
| 件名 | `Reset password instructions` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTML版:**
```html
<h1>Hello, {ユーザー名}!</h1>
<p>Someone, hopefully you, has requested to reset the password for your GitLab account on {GitLab URL}.</p>
<p>If you did not perform this request, you can safely ignore this email.</p>
<p>Otherwise, click the link below to complete the process.</p>
<div id="cta">
  <a href="{パスワードリセットURL}">Reset password</a>
</div>
```

**テキスト版:**
```
Hello, {ユーザー名}!

Someone, hopefully you, has requested to reset the password for your GitLab account on {GitLab URL}.

If you did not perform this request, you can safely ignore this email.

Otherwise, click the link below to complete the process:

{パスワードリセットURL}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @resource | パスワードリセット対象ユーザー | Userモデル | Yes |
| @resource.name | ユーザー表示名 | users.name | Yes |
| @token | パスワードリセットトークン | Deviseが生成 | Yes |
| Gitlab.config.gitlab.url | GitLabインスタンスURL | 設定ファイル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | パスワードリセットフォーム送信 | メールアドレスが登録済みユーザーと一致 | ユーザーがパスワードリセットをリクエスト |
| API | パスワードリセットAPIエンドポイント呼び出し | メールアドレスが登録済みユーザーと一致 | APIからのリセットリクエスト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| メールアドレスが未登録 | 存在しないメールアドレスの場合、メールは送信されない（ただしUIではエラーを表示しない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがパスワードリセットリクエスト] --> B[Devise::PasswordsController#create]
    B --> C{メールアドレス検索}
    C -->|見つからない| D[処理終了（エラー表示なし）]
    C -->|見つかった| E[reset_password_token生成]
    E --> F[DeviseMailer.reset_password_instructions 呼び出し]
    F --> G[X-Mailgun-Suppressions-Bypass ヘッダー追加]
    G --> H[メール送信]
    H --> I[ユーザーにリセットフォーム表示案内]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 対象ユーザー情報の取得 | name, email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | メール本文の挨拶文に使用 | パスワードリセット対象ユーザー |
| email | メール送信先、ユーザー検索 | パスワードリセット対象ユーザー |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| users | UPDATE | reset_password_token, reset_password_sent_at を更新 |

#### usersテーブル更新詳細

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | reset_password_token | ハッシュ化されたトークン | Deviseが自動生成 |
| UPDATE | reset_password_sent_at | 現在時刻 | トークンの有効期限判定に使用 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メールアドレス未登録 | 存在しないメールアドレスでリクエスト | セキュリティ上、エラーを表示せず正常完了として扱う |
| 送信失敗 | SMTPサーバー接続エラー | Deviseのデフォルトエラーハンドリングに依存 |
| トークン期限切れ | 一定時間経過後のリセット試行 | ユーザーに再度リセットリクエストを促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Deviseデフォルト（0回） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Deviseのレート制限に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リクエスト時に即座に送信）

## セキュリティ考慮事項

- パスワードリセットトークンは一度使用すると無効化される
- トークンには有効期限があり、`Devise.reset_password_within`で設定される
- 存在しないメールアドレスでリクエストしてもエラーを返さない（ユーザー列挙攻撃対策）
- `X-Mailgun-Suppressions-Bypass: true`ヘッダーにより、Mailgunの抑制リストをバイパス（重要なセキュリティメールを確実に配信）
- `validate_single_recipient_in_opts!`により、複数宛先への送信は防止される

## 備考

- Deviseの標準機能をオーバーライドして実装
- `X-Mailgun-Suppressions-Bypass`ヘッダーは、Mailgunを使用している環境でのみ意味を持つ
- 件名には`email_subject_suffix`が設定されている場合、自動的に付加される
- トークンの有効期限は`Devise.reset_password_within`で設定（デフォルト6時間）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メーラーの実装を理解する

DeviseMailerでのオーバーライドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | devise_mailer.rb | `app/mailers/devise_mailer.rb` | `reset_password_instructions`メソッドのオーバーライド |

**主要処理フロー**:
1. **行29-32**: `reset_password_instructions`メソッドの定義
2. **行30**: `X-Mailgun-Suppressions-Bypass`ヘッダーを`true`に設定
3. **行31**: `super`を呼び出してDeviseのデフォルト処理を実行

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | reset_password_instructions.html.haml | `app/views/devise/mailer/reset_password_instructions.html.haml` | HTML版メールテンプレート |
| 2-2 | reset_password_instructions.text.erb | `app/views/devise/mailer/reset_password_instructions.text.erb` | テキスト版メールテンプレート |

**主要処理フロー**:
- **行1**: `email_default_heading`で挨拶文を生成
- **行2-3**: リセットリクエストの説明
- **行4-5**: 本人でない場合の案内
- **行6-7**: リセット手順の案内
- **行8-9**: CTAボタン（リセットリンク）

#### Step 3: テストから仕様を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | devise_mailer_spec.rb | `spec/mailers/devise_mailer_spec.rb` | `reset_password_instructions`のテストケース |

**主要処理フロー**:
- **行155-201**: `#reset_password_instructions`のテスト
- **行171-172**: 件名「Reset password instructions」の検証
- **行175-177**: 挨拶文「Hello, {name}!」の検証
- **行179-183**: 本文内容の検証
- **行185-186**: リセットリンクの検証
- **行189-191**: `X-Mailgun-Suppressions-Bypass`ヘッダーの検証

### プログラム呼び出し階層図

```
Devise::PasswordsController#create
    │
    └─ User#send_reset_password_instructions
           │
           ├─ reset_password_token 生成
           │
           └─ DeviseMailer.reset_password_instructions(user, token)
                  │
                  ├─ headers['X-Mailgun-Suppressions-Bypass'] = 'true'
                  │
                  └─ super (Devise::Mailer#reset_password_instructions)
                         └─ テンプレートレンダリング
                                ├─ reset_password_instructions.html.haml
                                └─ reset_password_instructions.text.erb
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー操作
(パスワード
リセット要求)   ───▶  Devise::PasswordsController
                              │
                              ▼
                        User検索
                        (email)
                              │
                              ▼
                        reset_password_token
                        生成・保存
                              │
                              ▼
                        DeviseMailer
                        .reset_password_instructions  ───▶  メール送信
                              │                             (対象ユーザー)
                              ▼
                        Mailgunヘッダー追加
                        (抑制リストバイパス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | ソース | Deviseメーラー（オーバーライド） |
| reset_password_instructions.html.haml | `app/views/devise/mailer/reset_password_instructions.html.haml` | テンプレート | HTML版メールテンプレート |
| reset_password_instructions.text.erb | `app/views/devise/mailer/reset_password_instructions.text.erb` | テンプレート | テキスト版メールテンプレート |
| emails_helper.rb | `app/helpers/emails_helper.rb` | ソース | メール本文生成ヘルパー |
| devise_mailer_spec.rb | `spec/mailers/devise_mailer_spec.rb` | テスト | メーラーのテスト |
