# 通知設計書 124-email_changed

## 概要

本ドキュメントは、GitLabにおける「メールアドレス変更通知」メールの設計を記載します。ユーザーがメールアドレスを変更した際に、セキュリティ上の理由から通知されるメールです。

### 本通知の処理概要

本通知は、ユーザーがGitLabアカウントのメールアドレスを変更した際に、変更前のメールアドレス（または現在のメールアドレス）に送信されるセキュリティ通知メールです。

**業務上の目的・背景**：メールアドレスはアカウントの重要な識別情報であり、不正なアカウント乗っ取りの際に真っ先に変更されることが多いです。本通知は、ユーザーが自身で変更を行っていない場合に早期に気づくことができるよう、セキュリティ対策として実装されています。GitLab.com環境とセルフマネージド環境で異なるテンプレートが使用され、適切なサポート連絡先が案内されます。

**通知の送信タイミング**：Deviseがメールアドレス変更を検知し、`send_email_changed_notification`が呼び出された際に送信されます。変更が確定する前（unconfirmed状態）と確定後（confirmed状態）の両方のケースがあります。

**通知の受信者**：メールアドレス変更を行ったユーザーの**元の**メールアドレスに送信されます。

**通知内容の概要**：メールアドレスが変更された（または変更中である）ことを伝え、本人が変更を行っていない場合の対処方法を案内します。

**期待されるアクション**：受信者は、変更に心当たりがある場合は特に何もする必要はありません。心当たりがない場合は、直ちに管理者（セルフマネージド）またはグループオーナー/GitLabサポート（GitLab.com）に連絡し、アカウントのセキュリティを確認します。

## 通知種別

メール（Email）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | Deviseのデフォルト動作（同期/非同期は設定依存） |
| 優先度 | 高（セキュリティ関連通知） |
| リトライ | Deviseのデフォルト動作に依存 |

### 送信先決定ロジック

メールアドレスを変更したユーザーの登録メールアドレスに送信されます。Deviseの仕様により、変更前のメールアドレスに送信されます。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `Gitlab.config.gitlab.email_from` |
| 送信元名称 | `Gitlab.config.gitlab.email_display_name` |
| 件名 | `Email Changed` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート（セルフマネージド環境）

**HTML版:**
```html
<h1>Hello, {ユーザー名}!</h1>
<p>We're contacting you to notify you that your email is being changed to {新しいメールアドレス}.</p>
<!-- または -->
<p>We're contacting you to notify you that your email has been changed to {新しいメールアドレス}.</p>
<p>If you did not initiate this change, please contact your administrator immediately.</p>
```

**テキスト版:**
```
Hello, {ユーザー名}!

We're contacting you to notify you that your email is being changed to {新しいメールアドレス}.
または
We're contacting you to notify you that your email has been changed to {新しいメールアドレス}.

If you did not initiate this change, please contact your administrator immediately.
```

### 本文テンプレート（GitLab.com環境）

**HTML版:**
```html
<h1>Hello, {ユーザー名}!</h1>
<p>We're contacting you to notify you that your email is being changed to {新しいメールアドレス}.</p>
<!-- または -->
<p>We're contacting you to notify you that your email has been changed to {新しいメールアドレス}.</p>
<p>If you did not initiate this change, please contact your group owner immediately. If you have a Premium or Ultimate tier subscription, you can also contact GitLab support.</p>
```

**テキスト版:**
```
Hello, {ユーザー名}!

We're contacting you to notify you that your email is being changed to {新しいメールアドレス}.
または
We're contacting you to notify you that your email has been changed to {新しいメールアドレス}.

If you did not initiate this change, please contact your group owner immediately. If you have a Premium or Ultimate tier subscription, you can also contact GitLab support.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルはありません |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @resource | メールアドレス変更対象ユーザー | Userモデル | Yes |
| @resource.name | ユーザー表示名 | users.name | Yes |
| @resource.email | 新しいメールアドレス（確定後） | users.email | Conditional |
| @resource.unconfirmed_email | 新しいメールアドレス（未確定） | users.unconfirmed_email | Conditional |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| モデルコールバック | User#email変更 | Deviseのreconfirmable設定が有効 | ユーザーがメールアドレスを変更 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| reconfirmableが無効 | Devise設定でreconfirmableがfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがメールアドレス変更] --> B{Gitlab.com?}
    B -->|Yes| C[email_changed_gitlab_com テンプレート使用]
    B -->|No| D[email_changed テンプレート使用]
    C --> E[devise_mail 呼び出し]
    D --> E
    E --> F[メール送信]
    F --> G[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 対象ユーザー情報の取得 | name, email, unconfirmed_email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | メール本文の挨拶文に使用 | メールアドレス変更対象ユーザー |
| email | 変更後のメールアドレス表示（確定後） | メールアドレス変更対象ユーザー |
| unconfirmed_email | 変更後のメールアドレス表示（未確定） | メールアドレス変更対象ユーザー |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | メール送信のみで、DB更新は行わない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Deviseのデフォルトエラーハンドリングに依存 |
| テンプレートエラー | テンプレートファイル不在 | ActionView::MissingTemplateエラーが発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Deviseデフォルト（0回） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（Devise管理） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（メールアドレス変更時に即座に送信）

## セキュリティ考慮事項

- 本通知は元のメールアドレスに送信され、アカウント乗っ取りの早期検知に役立つ
- GitLab.com環境とセルフマネージド環境で異なるサポート連絡先が案内される
- `validate_single_recipient_in_opts!`により、複数宛先への送信は防止される
- 新しいメールアドレスがメール本文に含まれるため、フィッシング対策として正規のメールであることを示す

## 備考

- `Gitlab.com?`メソッドにより環境を判定し、使用するテンプレートを切り替える
- 未確定状態（`unconfirmed_email?`がtrue）と確定状態で異なるメッセージが表示される
- 件名には`email_subject_suffix`が設定されている場合、自動的に付加される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メーラーの実装を理解する

DeviseMailerでのテンプレート切り替えロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | devise_mailer.rb | `app/mailers/devise_mailer.rb` | `email_changed`メソッドのオーバーライド、環境による分岐 |

**主要処理フロー**:
1. **行34-40**: `email_changed`メソッドの定義
2. **行35-36**: `Gitlab.com?`で環境判定し、GitLab.com環境では`email_changed_gitlab_com`テンプレートを使用
3. **行37-38**: セルフマネージド環境では`email_changed`テンプレートを使用

#### Step 2: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | email_changed.html.haml | `app/views/devise/mailer/email_changed.html.haml` | セルフマネージド版HTML |
| 2-2 | email_changed.text.erb | `app/views/devise/mailer/email_changed.text.erb` | セルフマネージド版テキスト |
| 2-3 | email_changed_gitlab_com.html.haml | `app/views/devise/mailer/email_changed_gitlab_com.html.haml` | GitLab.com版HTML |
| 2-4 | email_changed_gitlab_com.text.erb | `app/views/devise/mailer/email_changed_gitlab_com.text.erb` | GitLab.com版テキスト |

**主要処理フロー（email_changed.html.haml）**:
- **行1**: `email_default_heading`で挨拶文を生成
- **行3-8**: `unconfirmed_email?`の状態に応じてメッセージを分岐
- **行10-12**: 管理者への連絡案内

**主要処理フロー（email_changed_gitlab_com.html.haml）**:
- **行1**: `email_default_heading`で挨拶文を生成
- **行3-8**: `unconfirmed_email?`の状態に応じてメッセージを分岐
- **行10-11**: グループオーナーまたはGitLabサポートへの連絡案内

#### Step 3: テストから仕様を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | devise_mailer_spec.rb | `spec/mailers/devise_mailer_spec.rb` | `email_changed`のテストケース |

**主要処理フロー**:
- **行203-246**: `#email_changed`のテスト
- **行217-218**: 件名「Email Changed」の検証
- **行225-229**: セルフマネージド環境での本文検証
- **行231-235**: GitLab.com環境での本文検証

### プログラム呼び出し階層図

```
Devise (メールアドレス変更検知)
    │
    └─ DeviseMailer#email_changed
           │
           ├─ Gitlab.com? 判定
           │      │
           │      ├─ true → devise_mail(:email_changed_gitlab_com)
           │      │              └─ email_changed_gitlab_com テンプレート
           │      │
           │      └─ false → devise_mail(:email_changed)
           │                     └─ email_changed テンプレート
           │
           └─ メール送信
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー操作
(メールアドレス
変更)          ───▶  Devise::RegistrationsController
                              │
                              ▼
                        User.email = 新アドレス
                              │
                              ▼
                        DeviseMailer#email_changed
                              │
                              ▼
                        環境判定
                        (Gitlab.com?)
                              │
                              ▼
                        テンプレート選択
                              │
                              ▼
                        メール送信           ───▶  元のメールアドレス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| devise_mailer.rb | `app/mailers/devise_mailer.rb` | ソース | Deviseメーラー（オーバーライド） |
| email_changed.html.haml | `app/views/devise/mailer/email_changed.html.haml` | テンプレート | セルフマネージド版HTML |
| email_changed.text.erb | `app/views/devise/mailer/email_changed.text.erb` | テンプレート | セルフマネージド版テキスト |
| email_changed_gitlab_com.html.haml | `app/views/devise/mailer/email_changed_gitlab_com.html.haml` | テンプレート | GitLab.com版HTML |
| email_changed_gitlab_com.text.erb | `app/views/devise/mailer/email_changed_gitlab_com.text.erb` | テンプレート | GitLab.com版テキスト |
| devise_mailer_spec.rb | `spec/mailers/devise_mailer_spec.rb` | テスト | メーラーのテスト |
