# 通知設計書 14-new_merge_request_email

## 概要

本ドキュメントは、GitLabにおいて新しいMerge Requestが作成された際に送信されるメール通知「new_merge_request_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、プロジェクト内で新しいMerge Request（MR）が作成された際に、関係者に対してその作成を通知するメールを送信する機能である。

**業務上の目的・背景**：Merge Requestはコードレビューとコード統合の中心的なワークフローである。新しいMRが作成された際に、担当者、レビュアー、プロジェクトメンバーに迅速に通知することで、レビュープロセスの開始を促し、開発サイクルの効率化を図る。この通知により、チームメンバーはMRの存在を認識し、必要なアクションを取ることができる。

**通知の送信タイミング**：Merge Requestが新規作成された直後に送信される。具体的には、`NotificationService#new_merge_request`メソッドが呼び出された時点で、対象となる受信者に対して非同期でメールが配信される。

**通知の受信者**：MRに関連する関係者が受信者となる。具体的には、MRの担当者（assignees）、レビュアー（reviewers）、プロジェクトのWatch設定をしているメンバー、MRのラベルを購読しているユーザー、およびカスタム通知レベルで「new merge request」を有効にしているユーザーが含まれる。

**通知内容の概要**：メールには、MRの作成者、タイトル、ソースブランチ・ターゲットブランチ、担当者、レビュアー、および説明文が含まれる。

**期待されるアクション**：受信者は通知を確認し、MRの内容を確認する。担当者はMRの作業を開始し、レビュアーはコードレビューを行う。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は`NotificationRecipients::BuildService.build_recipients`メソッドにより決定される。action: "new"パラメータが渡され、以下の条件に基づいて受信者リストが構築される：

1. MRの担当者（assignees）（通知設定がDisabled以外の場合）
2. MRのレビュアー（reviewers）
3. プロジェクトのWatch設定をしているユーザー
4. MRのラベルを購読しているユーザー
5. カスタム通知レベルで「new merge request」を有効にしているユーザー
6. EEの場合、MRの承認者（approvers）も含まれる

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{MR作成者の名前} (@{ユーザー名})" |
| 件名 | "{プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTMLバージョン**
```html
{user} created a merge request: {mr_link}

{source_branch} -> {target_branch}
Author: {author_name}
Assignee(s): {assignees}
Reviewer(s): {reviewers}

{description}
```

**テキストバージョン**
```
{user} created a merge request: {mr_url}

{source_branch} -> {target_branch}
Author:   {author_name}
Assignee(s): {assignees}
Reviewer(s): {reviewers}

{description}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @target_url | MRへのURL | project_merge_request_url | Yes |
| @recipient | メール受信者 | User.find(recipient_id) | Yes |
| @mr_presenter | MRプレゼンター | @merge_request.present(current_user: @recipient) | Yes |
| @sent_notification | 送信通知記録 | SentNotification.record | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | MR作成アクション | MRの作成が成功した場合 | ユーザーがUIまたはAPIを通じてMRを作成した際に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知設定が無効 | ユーザーの通知設定がDisabledの場合は送信されない |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |
| 作成者が通知をトリガーできない | can_trigger_notifications?がfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MR作成操作実行] --> B[NotificationService.new_merge_request呼び出し]
    B --> C{作成者がcan_trigger_notifications?}
    C -->|No| D[警告ログ出力して終了]
    C -->|Yes| E[BuildService.build_recipients実行]
    E --> F{受信者あり?}
    F -->|No| G[処理終了]
    F -->|Yes| H[各受信者に対してループ]
    H --> I[Notify.new_merge_request_email生成]
    I --> J[deliver_later実行]
    J --> K[Sidekiqキューに追加]
    K --> L[非同期でメール送信]
    L --> M[SentNotification記録]
    M --> N[処理完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | |
| users | 受信者、作成者、担当者、レビュアー情報取得 | |
| projects | プロジェクト情報取得 | |
| namespaces | 名前空間情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |
| members | プロジェクト/グループメンバーシップ確認 | |
| labels | MRのラベル情報 | |
| label_links | MRとラベルの関連 | |
| subscriptions | ラベル購読情報 | |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別子 | 引数で指定 |
| iid | プロジェクト内MR番号 | |
| title | タイトル | メール件名・本文に使用 |
| description | 説明文 | メール本文に使用 |
| author_id | 作成者ID | |
| source_branch | ソースブランチ名 | |
| target_branch | ターゲットブランチ名 | |
| target_project_id | ターゲットプロジェクトID | |

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別子 | |
| name | 表示名 | |
| email | 通知先メールアドレス | |
| notification_email | 通知用メールアドレス | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

#### sent_notifications（p_sent_notifications）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | recipient_id | 受信者のユーザーID | |
| INSERT | noteable_type | 'MergeRequest' | |
| INSERT | noteable_id | MRのID | |
| INSERT | project_id | プロジェクトID | |
| INSERT | reply_key | ランダム生成キー | メール返信用 |
| INSERT | namespace_id | プロジェクト名前空間ID | シャーディングキー |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| テンプレートエラー | テンプレート変数の欠落 | エラーログ記録、管理者通知 |
| 宛先不正 | メールアドレス形式不正 | 該当受信者をスキップしてログ記録 |
| MRが見つからない | MergeRequest.find失敗 | ActiveRecord::RecordNotFoundが発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- MRの説明文に機密情報が含まれる可能性があるため、受信者はプロジェクトへのアクセス権を持つユーザーに限定される
- メール返信機能使用時はreply_keyによる認証が行われる
- SentNotificationに記録されることで、返信時の認証と購読解除が可能
- X-GitLab-NotificationReasonヘッダーで通知理由が記録される

## 備考

- この通知は新規スレッドとして送信され、Message-IDが新規に生成される
- 購読解除リンクがメールに含まれ、ユーザーは個別に通知を停止できる
- present: trueパラメータにより、MRプレゼンターが使用される
- descriptionはmarkdownパイプラインで処理され、メンションや参照が展開される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知に関連するデータモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | MRモデルの構造、to_reference、関連モデル |
| 1-2 | sent_notification.rb | `app/models/sent_notification.rb` | 送信通知の記録モデル |

**読解のコツ**: MergeRequestモデルは多くの関連を持つため、assignees、reviewersの関連を特に確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | new_merge_requestメソッド（282-284行目）が通知のエントリーポイント |

**主要処理フロー**:
1. **282行目**: `def new_merge_request(merge_request, current_user)` - メソッド定義
2. **283行目**: `new_resource_email(merge_request, current_user, :new_merge_request_email)` - 共通処理呼び出し
3. **805-816行目**: `new_resource_email`の実装 - 受信者決定とメール送信

#### Step 3: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | new_merge_request_emailメソッド（15-19行目） |
| 3-2 | notify.rb | `app/mailers/notify.rb` | mail_new_thread（173-178行目）で新規スレッドとしてメール送信 |

**主要処理フロー**:
- **15行目**: `def new_merge_request_email(recipient_id, merge_request_id, reason = nil)`
- **16行目**: `setup_merge_request_mail(merge_request_id, recipient_id, present: true)` - 共通設定
- **18行目**: `mail_new_thread(@merge_request, merge_request_thread_options(@merge_request.author_id, reason))`

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new_merge_request_email.html.haml | `app/views/notify/new_merge_request_email.html.haml` | HTML形式のメール本文テンプレート |
| 4-2 | new_merge_request_email.text.erb | `app/views/notify/new_merge_request_email.text.erb` | テキスト形式のメール本文 |

**主要処理フロー**:
- **1-3行目**: 作成者情報とMRリンクの表示
- **5-6行目**: merge_path_description（ブランチ情報）
- **7-12行目**: 作成者、担当者、レビュアーの表示
- **14-16行目**: 説明文のmarkdown処理

### プログラム呼び出し階層図

```
MergeRequests::CreateService#execute
    |
    └── NotificationService#new_merge_request
            |
            └── new_resource_email
                    |
                    ├── can_trigger_notifications? チェック
                    |
                    ├── NotificationRecipients::BuildService.build_recipients
                    |       └── (action: "new")
                    |
                    └── Notify.new_merge_request_email (for each recipient)
                            |
                            ├── setup_merge_request_mail
                            |       ├── MergeRequest.find
                            |       ├── User.find (recipient)
                            |       ├── @merge_request.present
                            |       └── SentNotification.record
                            |
                            ├── mail_new_thread
                            |       ├── message_id生成
                            |       ├── add_project_headers
                            |       ├── add_unsubscription_headers_and_links
                            |       └── mail_with_locale
                            |
                            └── deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

MergeRequest      ──┐
                    ├──▶ NotificationService     ──▶ Sidekiq Queue
User (作成者)     ──┤           │
                    │           ▼
                    │    BuildService           ──▶ recipient list
                    │           │
                    │           ▼
                    └──▶ Notify.new_merge_request_email
                                │
                                ├──▶ SentNotification (DB)
                                │
                                └──▶ ActionMailer::MessageDelivery
                                            │
                                            ▼
                                      SMTPサーバー ──▶ 受信者メールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービスのエントリーポイント |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成モジュール |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| new_merge_request_email.html.haml | `app/views/notify/new_merge_request_email.html.haml` | テンプレート | HTML形式メールテンプレート |
| new_merge_request_email.text.erb | `app/views/notify/new_merge_request_email.text.erb` | テンプレート | テキスト形式メールテンプレート |
| sent_notification.rb | `app/models/sent_notification.rb` | ソース | 送信通知記録モデル |
| merge_request.rb | `app/models/merge_request.rb` | ソース | MRモデル |
| application_mailer.rb | `app/mailers/application_mailer.rb` | ソース | メーラー基底クラス |
