# 通知設計書 15-new_mention_in_merge_request_email

## 概要

本ドキュメントは、GitLabにおいてMerge Request内でユーザーがメンションされた際に送信されるメール通知「new_mention_in_merge_request_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、Merge Request（MR）の説明文やコメント内で@記法を使用してユーザーがメンションされた際に、そのユーザーに対して通知を送信する機能である。

**業務上の目的・背景**：コードレビューやディスカッションにおいて、特定のユーザーの注意を引きたい場合に@メンションが使用される。この通知により、メンションされたユーザーは自分への言及を迅速に認識し、必要な対応を取ることができる。例えば、特定の技術領域の専門家にレビューを依頼する場合や、質問への回答を求める場合などに活用される。

**通知の送信タイミング**：MRの説明文が更新され、新たにメンションが追加された時点で送信される。具体的には、`NotificationService#new_mentions_in_merge_request`メソッドが呼び出された時点で、新たにメンションされたユーザーに対して非同期でメールが配信される。

**通知の受信者**：MRの説明文内で新たにメンションされたユーザーが受信者となる。既存のメンション（更新前からあったメンション）は対象外となり、差分のみが通知される。

**通知内容の概要**：メールには、メンションされたMRの情報、MRの作成者、担当者、レビュアー、および説明文が含まれる。「You have been mentioned in merge request」という文言が表示される。

**期待されるアクション**：受信者は通知を確認し、MRの内容を確認する。必要に応じてコメント、レビュー、または質問への回答を行う。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は以下のロジックで決定される：

1. `NotificationRecipients::BuildService.build_recipients`でaction: "new"として基本的な受信者リストを構築
2. 新たにメンションされたユーザーリスト（`new_mentioned_users`）でフィルタリング
3. フィルタリング後の受信者にのみ通知が送信される

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{メンション実行者の名前} (@{ユーザー名})" |
| 件名 | "Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTMLバージョン**
```html
You have been mentioned in merge request {mr_link}

{user} created a merge request: {mr_link}

{source_branch} -> {target_branch}
Author: {author_name}
Assignee(s): {assignees}
Reviewer(s): {reviewers}

{description}
```

**テキストバージョン**
```
You have been mentioned in merge request {mr_reference}

{mr_url}

{source_branch} -> {target_branch}
Author:    {author_name}
Assignee(s): {assignees}
Reviewer(s): {reviewers}

{description}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @target_url | MRへのURL | project_merge_request_url | Yes |
| @recipient | メール受信者 | User.find(recipient_id) | Yes |
| @mr_presenter | MRプレゼンター | @merge_request.present(current_user: @recipient) | Yes |
| @sent_notification | 送信通知記録 | SentNotification.record | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | MR説明文の更新 | 新たなメンションが追加された場合 | MRの説明文が更新され、新しい@メンションが検出された際に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知設定が無効 | ユーザーの通知設定がDisabledの場合は送信されない |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |
| 更新者が通知をトリガーできない | can_trigger_notifications?がfalseの場合 |
| 既存のメンション | 更新前から存在していたメンションには通知されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MR説明文更新] --> B[新規メンション抽出]
    B --> C{新規メンションあり?}
    C -->|No| D[処理終了]
    C -->|Yes| E[NotificationService.new_mentions_in_merge_request呼び出し]
    E --> F{更新者がcan_trigger_notifications?}
    F -->|No| G[警告ログ出力して終了]
    F -->|Yes| H[BuildService.build_recipients実行]
    H --> I[new_mentioned_usersでフィルタリング]
    I --> J{受信者あり?}
    J -->|No| K[処理終了]
    J -->|Yes| L[各受信者に対してループ]
    L --> M[Notify.new_mention_in_merge_request_email生成]
    M --> N[deliver_later実行]
    N --> O[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | |
| users | 受信者、作成者、担当者、レビュアー情報取得 | |
| projects | プロジェクト情報取得 | |
| namespaces | 名前空間情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |
| members | プロジェクト/グループメンバーシップ確認 | |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別子 | 引数で指定 |
| iid | プロジェクト内MR番号 | |
| title | タイトル | メール件名に使用 |
| description | 説明文 | メール本文に使用 |
| author_id | 作成者ID | |
| source_branch | ソースブランチ名 | |
| target_branch | ターゲットブランチ名 | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| ユーザー不存在 | メンションされたユーザーが削除済み | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- メンションされたユーザーがMRを閲覧できる権限を持っているかは別途チェックされる
- メール返信機能使用時はreply_keyによる認証が行われる

## 備考

- この通知はスレッド形式のメールとして送信され、件名に"Re: "プレフィックスが付く
- new_merge_request_emailのテンプレートを再利用し、追加でメンション通知文を表示
- 同一MRに対する複数回の更新でも、新規メンションのみが通知対象

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | new_mentions_in_merge_requestメソッド（340-347行目） |

**主要処理フロー**:
1. **340行目**: `def new_mentions_in_merge_request(merge_request, new_mentioned_users, current_user)`
2. **341-346行目**: `new_mentions_in_resource_email`を呼び出し、`:new_mention_in_merge_request_email`を指定

#### Step 2: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | new_mention_in_merge_request_emailメソッド（21-25行目） |

**主要処理フロー**:
- **21行目**: `def new_mention_in_merge_request_email(recipient_id, merge_request_id, updated_by_user_id, reason = nil)`
- **22行目**: `setup_merge_request_mail(merge_request_id, recipient_id, present: true)`
- **24行目**: `mail_answer_thread(@merge_request, merge_request_thread_options(updated_by_user_id, reason))`

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new_mention_in_merge_request_email.html.haml | `app/views/notify/new_mention_in_merge_request_email.html.haml` | メンション通知文 + new_merge_request_emailテンプレート |
| 3-2 | new_mention_in_merge_request_email.text.erb | `app/views/notify/new_mention_in_merge_request_email.text.erb` | テキスト形式 |

**主要処理フロー**:
- **html 2行目**: メンション通知文の表示
- **html 4行目**: `render template: 'notify/new_merge_request_email'`でテンプレート再利用

### プログラム呼び出し階層図

```
MergeRequests::UpdateService#execute
    |
    └── NotificationService#new_mentions_in_merge_request
            |
            └── new_mentions_in_resource_email
                    |
                    ├── can_trigger_notifications? チェック
                    |
                    ├── NotificationRecipients::BuildService.build_recipients
                    |       └── (action: "new")
                    |
                    ├── new_mentioned_usersでフィルタリング
                    |
                    └── Notify.new_mention_in_merge_request_email (for each)
                            |
                            └── mail_answer_thread
                                    └── deliver_later
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成 |
| new_mention_in_merge_request_email.html.haml | `app/views/notify/new_mention_in_merge_request_email.html.haml` | テンプレート | HTML形式 |
| new_mention_in_merge_request_email.text.erb | `app/views/notify/new_mention_in_merge_request_email.text.erb` | テンプレート | テキスト形式 |
| new_merge_request_email.html.haml | `app/views/notify/new_merge_request_email.html.haml` | テンプレート | 再利用されるテンプレート |
