# 通知設計書 16-push_to_merge_request_email

## 概要

本ドキュメントは、GitLabにおいてMerge Requestに新しいコミットがプッシュされた際に送信されるメール通知「push_to_merge_request_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、既存のMerge Request（MR）のソースブランチに新しいコミットがプッシュされた際に、関係者に対してその変更を通知するメールを送信する機能である。

**業務上の目的・背景**：コードレビュー中にMRが更新されることは一般的である。レビュアーや担当者がMRへの新しいコミットを認識することで、追加のレビューが必要かどうかを判断でき、レビュープロセスの効率化が図れる。また、フィードバックに基づく修正が行われた際に、関係者に通知することで、レビューの再開を促すことができる。

**通知の送信タイミング**：MRのソースブランチにコミットがプッシュされた直後に送信される。具体的には、`NotificationService#push_to_merge_request`メソッドが呼び出された時点で、対象となる受信者に対して非同期でメールが配信される。

**通知の受信者**：MRに関連する関係者が受信者となる。具体的には、NotificationRecipients::BuildServiceによってaction: "push_to"に基づき決定され、MRの作成者、担当者、レビュアー、プロジェクトのWatch設定をしているメンバーが含まれる。

**通知内容の概要**：メールには、プッシュしたユーザー、対象MRの情報、新しいコミットのリスト（コミットID、タイトル）、およびターゲットブランチから取り込まれた既存コミット情報が含まれる。

**期待されるアクション**：受信者は通知を確認し、新しいコミットの内容を確認する。レビュアーは必要に応じて追加のレビューを行い、担当者はMRの状態を更新する。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は`NotificationRecipients::BuildService.build_recipients`メソッドにより決定される。action: "push_to"パラメータが渡され、以下の条件に基づいて受信者リストが構築される：

1. MRの作成者（通知設定がDisabled以外の場合）
2. MRの担当者（assignees）
3. MRのレビュアー（reviewers）
4. プロジェクトのWatch設定をしているユーザー
5. カスタム通知レベルで該当アクションを有効にしているユーザー

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{プッシュ実行者の名前} (@{ユーザー名})" |
| 件名 | "Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTMLバージョン**
```html
{updated_by_user_name} pushed new commits to merge request {mr_link}

[既存コミットがある場合]
* {commit_range} - {count} commit(s) from branch `{target_branch}`

[新しいコミットのリスト]
* {commit_id} - {commit_title}
* {commit_id} - {commit_title}
...

[20件を超える場合]
* And {remaining_count} more
```

**テキストバージョン**
```
{updated_by_user_name} pushed new commits to merge request {mr_reference}

Merge request URL: {mr_url}

[既存コミットがある場合]
* {commit_range} - {count} commit(s) from branch `{target_branch}`

[新しいコミットのリスト]
* {commit_id} - {commit_title}
* {commit_id} - {commit_title}
...
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @updated_by_user | プッシュ実行ユーザー | User.find(updated_by_user_id) | Yes |
| @new_commits | 新しいコミット配列 | 引数で渡される（最大20件） | Yes |
| @total_new_commits_count | 新しいコミットの総数 | 引数で渡される | Yes |
| @total_stripped_new_commits_count | 省略されたコミット数 | 計算値 | No |
| @existing_commits | 既存コミット配列 | 引数で渡される | No |
| @total_existing_commits_count | 既存コミットの総数 | 引数で渡される | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Gitプッシュ | MRソースブランチへのプッシュ | MRが存在し、コミットがプッシュされた場合 | git pushにより発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知設定が無効 | ユーザーの通知設定がDisabledの場合は送信されない |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MRソースブランチにプッシュ] --> B[新規/既存コミット抽出]
    B --> C[NotificationService.push_to_merge_request呼び出し]
    C --> D[コミット情報の加工]
    D --> E[新コミットを最大20件に制限]
    E --> F[既存コミットを先頭/末尾のみに制限]
    F --> G[BuildService.build_recipients実行]
    G --> H{受信者あり?}
    H -->|No| I[処理終了]
    H -->|Yes| J[各受信者に対してループ]
    J --> K[Notify.push_to_merge_request_email生成]
    K --> L[deliver_later実行]
    L --> M[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | |
| users | 受信者、プッシュ実行者情報取得 | |
| projects | プロジェクト情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| MRが見つからない | MergeRequest.find失敗 | ActiveRecord::RecordNotFoundが発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- コミットメッセージやコミットIDが含まれるため、プロジェクトへのアクセス権を持つユーザーのみが受信
- メール返信機能使用時はreply_keyによる認証が行われる

## 備考

- NEW_COMMIT_EMAIL_DISPLAY_LIMIT = 20により、表示されるコミット数は最大20件に制限される
- 既存コミット（ターゲットブランチから取り込まれたコミット）は先頭と末尾のみ表示される
- コミット情報は{short_id, title}のハッシュ形式で渡される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | push_to_merge_requestメソッド（287-311行目） |

**主要処理フロー**:
1. **287行目**: メソッド定義、new_commits、existing_commitsをキーワード引数で受け取る
2. **288-291行目**: new_commitsの加工（最大20件、short_id/titleのハッシュに変換）
3. **295-298行目**: existing_commitsの加工（先頭と末尾のみ）
4. **301行目**: BuildService.build_recipients呼び出し
5. **303-309行目**: 各受信者へのメール送信

#### Step 2: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | push_to_merge_request_emailメソッド（28-50行目） |

**主要処理フロー**:
- **28-37行目**: キーワード引数の受け取り
- **40-46行目**: インスタンス変数の設定
- **47行目**: @updated_by_userの取得
- **49行目**: mail_answer_thread呼び出し

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | push_to_merge_request_email.html.haml | `app/views/notify/push_to_merge_request_email.html.haml` | コミットリストの表示ロジック |
| 3-2 | push_to_merge_request_email.text.haml | `app/views/notify/push_to_merge_request_email.text.haml` | テキスト形式 |

**主要処理フロー**:
- **html 1-4行目**: ヘッダーメッセージ
- **html 6-17行目**: 既存コミットの表示（条件付き）
- **html 19-28行目**: 新しいコミットのリスト表示

### プログラム呼び出し階層図

```
Git Push Event
    |
    └── MergeRequests::RefreshService
            |
            └── NotificationService#push_to_merge_request
                    |
                    ├── コミット情報の加工
                    |       ├── 最大20件に制限
                    |       └── 先頭/末尾のみ
                    |
                    ├── BuildService.build_recipients
                    |       └── (action: "push_to")
                    |
                    └── Notify.push_to_merge_request_email (for each)
                            |
                            └── mail_answer_thread
                                    └── deliver_later
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成 |
| push_to_merge_request_email.html.haml | `app/views/notify/push_to_merge_request_email.html.haml` | テンプレート | HTML形式 |
| push_to_merge_request_email.text.haml | `app/views/notify/push_to_merge_request_email.text.haml` | テンプレート | テキスト形式 |
