# 通知設計書 17-change_in_merge_request_draft_status_email

## 概要

本ドキュメントは、GitLabにおいてMerge Requestのドラフト状態が変更された際に送信されるメール通知「change_in_merge_request_draft_status_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、Merge Request（MR）がドラフト状態から通常状態に変更された際、または通常状態からドラフト状態に変更された際に、関係者に対してその変更を通知するメールを送信する機能である。

**業務上の目的・背景**：GitLabではMRに「Draft:」プレフィックスを付けることで、作業中（Work in Progress）であることを明示できる。この機能により、レビュアーは不完全なMRをレビューする必要がなくなる。ドラフト状態の変更は重要なシグナルであり、「draft」から「ready」への変更はレビュー開始を促し、「ready」から「draft」への変更は追加作業が必要であることを示す。この通知により、関係者は状態変更を認識し、適切なアクションを取ることができる。

**通知の送信タイミング**：MRのドラフト状態が変更された直後に送信される。具体的には、`NotificationService#change_in_merge_request_draft_status`メソッドが呼び出された時点で、対象となる受信者に対して非同期でメールが配信される。

**通知の受信者**：MRに関連する関係者が受信者となる。具体的には、NotificationRecipients::BuildServiceによってaction: "draft_status_change"に基づき決定され、MRの作成者、担当者、レビュアー、プロジェクトのWatch設定をしているメンバーが含まれる。

**通知内容の概要**：メールには、状態を変更したユーザー、対象MRの情報、および新しい状態（draft/ready）が含まれる。

**期待されるアクション**：受信者は通知を確認し、MRの状態に応じたアクションを取る。「ready」への変更時はレビューを開始し、「draft」への変更時は追加作業の完了を待つ。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は`NotificationRecipients::BuildService.build_recipients`メソッドにより決定される。action: "draft_status_change"パラメータが渡され、以下の条件に基づいて受信者リストが構築される：

1. MRの作成者（通知設定がDisabled以外の場合）
2. MRの担当者（assignees）
3. MRのレビュアー（reviewers）
4. プロジェクトのWatch設定をしているユーザー
5. カスタム通知レベルで該当アクションを有効にしているユーザー

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{状態変更実行者の名前} (@{ユーザー名})" |
| 件名 | "Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTMLバージョン**

ドラフトに変更された場合：
```html
{username} marked merge request {mr_link} as draft
```

準備完了に変更された場合：
```html
{username} marked merge request {mr_link} as ready
```

**テキストバージョン**

ドラフトに変更された場合：
```
{username} marked merge request {mr_reference} as draft
```

準備完了に変更された場合：
```
{username} marked merge request {mr_reference} as ready
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @updated_by_user | 状態変更実行ユーザー | User.find(updated_by_user_id) | Yes |
| @merge_request.draft? | ドラフト状態フラグ | MRの現在の状態 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | MRドラフト状態変更 | ドラフト状態が変更された場合 | タイトルのDraft:プレフィックスの追加/削除、またはUI操作 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知設定が無効 | ユーザーの通知設定がDisabledの場合は送信されない |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MRドラフト状態変更] --> B[NotificationService.change_in_merge_request_draft_status呼び出し]
    B --> C[BuildService.build_recipients実行]
    C --> D{受信者あり?}
    D -->|No| E[処理終了]
    D -->|Yes| F[各受信者に対してループ]
    F --> G[Notify.change_in_merge_request_draft_status_email生成]
    G --> H[deliver_later実行]
    H --> I[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | draft?メソッドでタイトルをチェック |
| users | 受信者、状態変更実行者情報取得 | |
| projects | プロジェクト情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| MRが見つからない | MergeRequest.find失敗 | ActiveRecord::RecordNotFoundが発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- メール返信機能使用時はreply_keyによる認証が行われる
- MRへのアクセス権を持つユーザーのみが受信対象

## 備考

- @merge_request.draft?の結果によってメッセージが「as draft」または「as ready」に分岐
- この通知は比較的シンプルで、MRの詳細情報は含まれない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | change_in_merge_request_draft_statusメソッド（313-325行目） |

**主要処理フロー**:
1. **313行目**: `def change_in_merge_request_draft_status(merge_request, current_user)`
2. **314行目**: BuildService.build_recipients呼び出し（action: "draft_status_change"）
3. **316-324行目**: 各受信者へのメール送信

#### Step 2: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | change_in_merge_request_draft_status_emailメソッド（52-58行目） |

**主要処理フロー**:
- **52行目**: メソッド定義
- **53行目**: setup_merge_request_mail呼び出し
- **55行目**: @updated_by_userの取得
- **57行目**: mail_answer_thread呼び出し

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | change_in_merge_request_draft_status_email.html.haml | `app/views/notify/change_in_merge_request_draft_status_email.html.haml` | 条件分岐によるメッセージ |
| 3-2 | change_in_merge_request_draft_status_email.text.erb | `app/views/notify/change_in_merge_request_draft_status_email.text.erb` | テキスト形式 |

**主要処理フロー**:
- **html 1-6行目**: @merge_request.draft?による条件分岐
- **text 1-5行目**: 同様の条件分岐

### プログラム呼び出し階層図

```
MergeRequests::UpdateService#execute (draft状態変更)
    |
    └── NotificationService#change_in_merge_request_draft_status
            |
            ├── BuildService.build_recipients
            |       └── (action: "draft_status_change")
            |
            └── Notify.change_in_merge_request_draft_status_email (for each)
                    |
                    └── mail_answer_thread
                            └── deliver_later
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成 |
| change_in_merge_request_draft_status_email.html.haml | `app/views/notify/change_in_merge_request_draft_status_email.html.haml` | テンプレート | HTML形式 |
| change_in_merge_request_draft_status_email.text.erb | `app/views/notify/change_in_merge_request_draft_status_email.text.erb` | テンプレート | テキスト形式 |
