# 通知設計書 18-reassigned_merge_request_email

## 概要

本ドキュメントは、GitLabにおいてMerge Requestの担当者（assignee）が変更された際に送信されるメール通知「reassigned_merge_request_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、Merge Request（MR）に割り当てられた担当者が追加、削除、または変更された際に、関係者に対してその変更を通知するメールを送信する機能である。

**業務上の目的・背景**：MRの担当者は、そのMRの作業を担当する責任者を示す。担当者の変更は、作業の引き継ぎや責任の移譲を意味するため、関係者に通知することが重要である。この通知により、新しい担当者は自分への割り当てを認識し、前の担当者は担当から外れたことを把握できる。

**通知の送信タイミング**：MRの担当者が変更された直後に送信される。具体的には、`NotificationService#reassigned_merge_request`メソッドが呼び出された時点で、対象となる受信者に対して非同期でメールが配信される。

**通知の受信者**：担当者の変更に関わるユーザーが受信者となる。具体的には、新しく追加された担当者、削除された前の担当者、およびMRに関連する他の関係者が含まれる。

**通知内容の概要**：メールには、MRの情報、追加された担当者リスト、削除された担当者リストが含まれる。

**期待されるアクション**：新しい担当者は通知を確認し、MRの作業を引き継ぐ。前の担当者は担当から外れたことを認識し、必要に応じて引き継ぎを行う。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は`NotificationRecipients::BuildService.build_recipients`メソッドにより決定される。action: "reassign"パラメータとprevious_assigneesが渡され、以下の条件に基づいて受信者リストが構築される：

1. 新しく追加された担当者
2. 削除された前の担当者（previous_assignees）
3. MRの作成者（通知設定がDisabled以外の場合）
4. カスタム通知レベルで「reassign merge request」を有効にしているユーザー

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{担当者変更実行者の名前} (@{ユーザー名})" |
| 件名 | "Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTMLバージョン**

担当者が追加された場合：
```html
{added_names} was added as an assignee.
```
または複数追加：
```html
{added_names} were added as assignees.
```

担当者が削除された場合（残りの担当者がいる）：
```html
{removed_names} was removed as an assignee.
```

全ての担当者が削除された場合：
```html
All assignees were removed.
```

**テキストバージョン**
```
Reassigned merge request {iid}

{mr_url}

{added_names} was added as an assignee.
{removed_names} was removed as an assignee.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @added_assignees | 追加された担当者名リスト | 現在の担当者 - 以前の担当者 | Yes |
| @removed_assignees | 削除された担当者名リスト | 以前の担当者 - 現在の担当者 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | MR担当者変更 | 担当者が追加または削除された場合 | MRの編集画面またはAPIでassigneesが変更された際に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知設定が無効 | ユーザーの通知設定がDisabledの場合は送信されない |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MR担当者変更] --> B[以前の担当者リスト保存]
    B --> C[担当者更新実行]
    C --> D[追加/削除された担当者計算]
    D --> E[NotificationService.reassigned_merge_request呼び出し]
    E --> F[BuildService.build_recipients実行]
    F --> G{受信者あり?}
    G -->|No| H[処理終了]
    G -->|Yes| I[各受信者に対してループ]
    I --> J[Notify.reassigned_merge_request_email生成]
    J --> K[deliver_later実行]
    K --> L[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | |
| users | 受信者、担当者情報取得 | |
| merge_request_assignees | MRと担当者の関連 | |
| projects | プロジェクト情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| ユーザー不存在 | 担当者が削除済み | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- メール返信機能使用時はreply_keyによる認証が行われる
- MRへのアクセス権を持つユーザーのみが受信対象

## 備考

- _reassigned_issuable_email.html.hamlパーシャルを使用して、IssueとMRで共通のテンプレートを利用
- to_sentenceを使用して複数の担当者名を自然な文に変換
- 国際化（I18n）対応のため、単数形/複数形の分岐がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | reassigned_merge_requestメソッド（355-374行目） |

**主要処理フロー**:
1. **355行目**: `def reassigned_merge_request(merge_request, current_user, previous_assignees = [])`
2. **356-361行目**: BuildService.build_recipients呼び出し（action: "reassign"）
3. **363行目**: previous_assignee_idsの取得
4. **365-373行目**: 各受信者へのメール送信

#### Step 2: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | reassigned_merge_request_emailメソッド（61-77行目） |

**主要処理フロー**:
- **61-67行目**: メソッド定義、キーワード引数の受け取り
- **68行目**: setup_merge_request_mail呼び出し
- **70-71行目**: previous_assigneesの取得
- **72-73行目**: @added_assignees, @removed_assigneesの計算
- **75行目**: mail_answer_thread呼び出し

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reassigned_merge_request_email.html.haml | `app/views/notify/reassigned_merge_request_email.html.haml` | パーシャル呼び出し |
| 3-2 | _reassigned_issuable_email.html.haml | `app/views/notify/_reassigned_issuable_email.html.haml` | 共通パーシャル |
| 3-3 | reassigned_merge_request_email.text.erb | `app/views/notify/reassigned_merge_request_email.text.erb` | テキスト形式 |

**主要処理フロー**:
- **html 1行目**: パーシャルをrenderして共通テンプレートを使用
- **パーシャル 4-6行目**: 追加担当者の表示（単数形/複数形分岐）
- **パーシャル 7-9行目**: 削除担当者の表示（残りがいる場合）
- **パーシャル 10-12行目**: 全削除の表示

### プログラム呼び出し階層図

```
MergeRequests::UpdateService#execute (担当者変更)
    |
    └── NotificationService#reassigned_merge_request
            |
            ├── BuildService.build_recipients
            |       └── (action: "reassign", previous_assignees)
            |
            └── Notify.reassigned_merge_request_email (for each)
                    |
                    ├── User.where(id: previous_assignee_ids)
                    ├── 追加/削除担当者の計算
                    |
                    └── mail_answer_thread
                            └── deliver_later
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成 |
| reassigned_merge_request_email.html.haml | `app/views/notify/reassigned_merge_request_email.html.haml` | テンプレート | HTML形式 |
| reassigned_merge_request_email.text.erb | `app/views/notify/reassigned_merge_request_email.text.erb` | テンプレート | テキスト形式 |
| _reassigned_issuable_email.html.haml | `app/views/notify/_reassigned_issuable_email.html.haml` | テンプレート | 共通パーシャル |
