# 通知設計書 19-changed_reviewer_of_merge_request_email

## 概要

本ドキュメントは、GitLabにおいてMerge Requestのレビュアーが変更された際に送信されるメール通知「changed_reviewer_of_merge_request_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、Merge Request（MR）に割り当てられたレビュアーが追加、削除、または変更された際に、関係者に対してその変更を通知するメールを送信する機能である。

**業務上の目的・背景**：MRのレビュアーは、コードレビューを担当する責任者を示す。レビュアーの変更は、レビュー担当の引き継ぎや追加のレビュー依頼を意味するため、関係者に通知することが重要である。この通知により、新しいレビュアーは自分へのレビュー依頼を認識し、前のレビュアーは担当から外れたことを把握できる。

**通知の送信タイミング**：MRのレビュアーが変更された直後に送信される。具体的には、`NotificationService#changed_reviewer_of_merge_request`メソッドが呼び出された時点で、対象となる受信者に対して非同期でメールが配信される。

**通知の受信者**：レビュアーの変更に関わるユーザーが受信者となる。具体的には、新しく追加されたレビュアー、削除された前のレビュアー、およびMRに関連する他の関係者が含まれる。

**通知内容の概要**：メールには、MRの情報、レビュアーの変更内容が含まれる。change_reviewer_notification_textヘルパーによりメッセージが生成される。

**期待されるアクション**：新しいレビュアーは通知を確認し、MRのコードレビューを開始する。前のレビュアーは担当から外れたことを認識する。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は`NotificationRecipients::BuildService.build_recipients`メソッドにより決定される。action: "change_reviewer"パラメータとprevious_assignees（実際にはprevious_reviewers）が渡され、以下の条件に基づいて受信者リストが構築される：

1. 新しく追加されたレビュアー
2. 削除された前のレビュアー（previous_reviewers）
3. MRの作成者（通知設定がDisabled以外の場合）
4. カスタム通知レベルで該当アクションを有効にしているユーザー

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{レビュアー変更実行者の名前} (@{ユーザー名})" |
| 件名 | "Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

本文は`change_reviewer_notification_text`ヘルパーメソッドにより動的に生成される。

**HTMLバージョン**
```html
{generated_message_from_helper}
```

**テキストバージョン**
```
{generated_message_from_helper}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @previous_reviewers | 以前のレビュアーリスト | User.where(id: previous_reviewer_ids) | Yes |
| @updated_by_user | レビュアー変更実行ユーザー | User.find(updated_by_user_id) | Yes |
| @merge_request.reviewers | 現在のレビュアーリスト | MRの関連 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | MRレビュアー変更 | レビュアーが追加または削除された場合 | MRの編集画面またはAPIでreviewersが変更された際に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知設定が無効 | ユーザーの通知設定がDisabledの場合は送信されない |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MRレビュアー変更] --> B[以前のレビュアーリスト保存]
    B --> C[レビュアー更新実行]
    C --> D[NotificationService.changed_reviewer_of_merge_request呼び出し]
    D --> E[BuildService.build_recipients実行]
    E --> F{受信者あり?}
    F -->|No| G[処理終了]
    F -->|Yes| H[各受信者に対してループ]
    H --> I[Notify.changed_reviewer_of_merge_request_email生成]
    I --> J[deliver_later実行]
    J --> K[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | |
| users | 受信者、レビュアー情報取得 | |
| merge_request_reviewers | MRとレビュアーの関連 | |
| projects | プロジェクト情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| ユーザー不存在 | レビュアーが削除済み | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- メール返信機能使用時はreply_keyによる認証が行われる
- MRへのアクセス権を持つユーザーのみが受信対象

## 備考

- change_reviewer_notification_textヘルパーにより、現在のレビュアーと以前のレビュアーから適切なメッセージが生成される
- previous_assigneesパラメータ名が使われているが、実際にはprevious_reviewersとして扱われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | changed_reviewer_of_merge_requestメソッド（382-401行目） |

**主要処理フロー**:
1. **382行目**: `def changed_reviewer_of_merge_request(merge_request, current_user, previous_reviewers = [])`
2. **383-388行目**: BuildService.build_recipients呼び出し（action: "change_reviewer"）
3. **390行目**: previous_reviewer_idsの取得
4. **392-400行目**: 各受信者へのメール送信

#### Step 2: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | changed_reviewer_of_merge_request_emailメソッド（80-95行目） |

**主要処理フロー**:
- **80-86行目**: メソッド定義、キーワード引数の受け取り
- **87行目**: setup_merge_request_mail呼び出し
- **89-90行目**: @previous_reviewersの取得
- **91行目**: @updated_by_userの取得
- **93行目**: mail_answer_thread呼び出し

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | changed_reviewer_of_merge_request_email.html.haml | `app/views/notify/changed_reviewer_of_merge_request_email.html.haml` | ヘルパー呼び出し |
| 3-2 | changed_reviewer_of_merge_request_email.text.erb | `app/views/notify/changed_reviewer_of_merge_request_email.text.erb` | テキスト形式 |

**主要処理フロー**:
- **html 2行目**: `change_reviewer_notification_text(@merge_request.reviewers, @previous_reviewers)`

### プログラム呼び出し階層図

```
MergeRequests::UpdateService#execute (レビュアー変更)
    |
    └── NotificationService#changed_reviewer_of_merge_request
            |
            ├── BuildService.build_recipients
            |       └── (action: "change_reviewer", previous_assignees: previous_reviewers)
            |
            └── Notify.changed_reviewer_of_merge_request_email (for each)
                    |
                    ├── User.where(id: previous_reviewer_ids)
                    ├── @updated_by_user取得
                    |
                    └── mail_answer_thread
                            └── deliver_later
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成 |
| changed_reviewer_of_merge_request_email.html.haml | `app/views/notify/changed_reviewer_of_merge_request_email.html.haml` | テンプレート | HTML形式 |
| changed_reviewer_of_merge_request_email.text.erb | `app/views/notify/changed_reviewer_of_merge_request_email.text.erb` | テンプレート | テキスト形式 |
| emails_helper.rb | `app/helpers/emails_helper.rb` | ソース | change_reviewer_notification_textヘルパー |
