# 通知設計書 2-issue_due_email

## 概要

本ドキュメントは、GitLabにおけるIssueの期限通知メール機能（issue_due_email）の設計仕様を定義する。

### 本通知の処理概要

issue_due_emailは、GitLabプロジェクト内のIssueに設定された期限（due_date）が近づいた際に、関連するユーザーに対してメール通知を送信する機能である。

**業務上の目的・背景**：プロジェクト管理において、タスクの期限管理は重要な要素である。期限が近づいていることをチームメンバーに事前に通知することで、タスクの遅延を防ぎ、計画的な作業遂行を支援する。この通知により、担当者や関係者が期限を意識して作業を進められるようになり、プロジェクトの納期遵守率が向上する。

**通知の送信タイミング**：スケジュールされたバックグラウンドジョブにより、期限が近づいているIssueが検出された際に通知が送信される。NotificationService.new.issue_due(issue)が呼び出されることで処理が開始される。具体的には、DueDateWorkerがCronスケジュールで実行され、期限が迫っているIssueを検索して通知を送信する。

**通知の受信者**：Issue作成者、Issue担当者（assignee）、カスタム通知設定で「issue_due」を有効にしているユーザー、Issueの参加者が受信対象となる。skip_current_user: falseが設定されているため、作成者本人にも通知が送信される。

**通知内容の概要**：Issue作成者名、Issueタイトル、Issue番号、担当者情報、期限日、Issue説明文（Markdown形式）が含まれる。

**期待されるアクション**：受信者はIssueの期限を確認し、必要に応じて作業の優先度調整、期限の延長リクエスト、または作業の完了・クローズを行うことが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Sidekiq deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqデフォルト設定（最大25回） |

### 送信先決定ロジック

NotificationRecipients::BuildServiceを使用して受信者を決定する。以下の特徴がある：

1. action: 'due'で受信者を構築
2. custom_action: :issue_dueでカスタム通知設定を参照
3. skip_current_user: falseにより、作成者本人にも通知を送信
4. Issueの参加者（participants）に通知
5. プロジェクトのウォッチャーに通知
6. カスタム通知設定ユーザーに通知
7. 購読者に通知

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `{sender.name} ({sender.to_reference})` <gitlab@{host}> |
| 送信元名称 | 作成者名（@ユーザー名） |
| 件名 | `Re: {project_name} | {issue_title} (#{iid})` |
| 形式 | HTML/テキスト両対応（multipart） |

### 本文テンプレート

```
{作成者名}'s issue {issue_reference_link} is due soon.

Assignee: {assignee_names} （担当者がいる場合）

This issue is due on: {issue_due_date}

{issue_description} （Markdown形式でレンダリング）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @issue | Issueオブジェクト | Issue.find(issue_id) | Yes |
| @project | プロジェクトオブジェクト | @issue.project | Yes |
| @namespace | 名前空間 | @issue.namespace | Yes |
| @target_url | IssueへのURL | Gitlab::UrlBuilder.build(@issue) | Yes |
| @recipient | 受信者ユーザー | User.find(recipient_id) | Yes |
| @sent_notification | 送信通知記録 | SentNotification.record | Yes |
| @issue.due_date | 期限日 | issues.due_date | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | DueDateWorker Cronジョブ | Issueのdue_dateが近づいている | 定期的なバックグラウンドジョブ |
| バッチ | 期限チェックバッチ | due_date条件に合致 | 期限間近のIssue検索・通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| project.emails_disabled? == true | プロジェクトでメール通知が無効化されている場合 |
| 受信者の通知レベルがDisabled | ユーザー設定で通知を無効化している場合 |
| レート制限超過 | プロジェクト/グループ単位の通知レート制限に達した場合 |
| Issueがクローズ済み | 既にクローズされたIssueには通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DueDateWorker実行] --> B[期限間近のIssue検索]
    B --> C[NotificationService.issue_due]
    C --> D[NotificationRecipients::BuildService.build_recipients]
    D --> E[受信者リスト構築]
    E --> F[各受信者に対してループ]
    F --> G[Notify.issue_due_email.deliver_later]
    G --> H[Sidekiqキューに追加]
    H --> I[setup_issue_mail実行]
    I --> J[SentNotification.record]
    J --> K[mail_answer_thread実行]
    K --> L{レート制限チェック}
    L -->|超過| M[送信スキップ]
    L -->|OK| N[メール送信]
    N --> O[終了]
    M --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| issues | Issue情報取得 | メール本文データ、due_date確認 |
| users | ユーザー情報取得 | 作成者・受信者・担当者 |
| projects | プロジェクト情報 | メール件名・ヘッダー |
| namespaces | 名前空間情報 | グループ情報取得 |
| notification_settings | 通知設定 | 受信者フィルタリング |

### テーブル別参照項目詳細

#### issues

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Issue識別 | PRIMARY KEY |
| iid | Issue番号 | メール件名に使用 |
| title | タイトル | メール件名に使用 |
| description | 説明文 | メール本文に使用 |
| author_id | 作成者ID | 作成者情報取得 |
| project_id | プロジェクトID | プロジェクト情報取得 |
| due_date | 期限日 | 期限通知判定・本文表示 |
| confidential | 機密フラグ | ヘッダー設定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| p_sent_notifications | INSERT | 送信通知記録 |

#### 送信ログテーブル（p_sent_notifications）

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | project_id | @issue.project_id | プロジェクトID |
| INSERT | recipient_id | recipient_id | 受信者ID |
| INSERT | reply_key | SecureRandom生成 | 返信キー |
| INSERT | noteable_type | 'Issue' | 通知対象タイプ |
| INSERT | noteable_id | @issue.id | Issue ID |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTP接続エラー | Sidekiqリトライ |
| テンプレートエラー | Hamlレンダリング失敗 | エラーログ出力 |
| 宛先不正 | メールアドレス形式不正 | 送信スキップ |
| Issue削除済み | 送信前にIssueが削除 | RecordNotFound例外 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（最大25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTPConnectionError等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定による |
| 1日あたり上限 | プロジェクト/グループ単位で設定 |

### 配信時間帯

制限なし（24時間送信可能）。ただし、DueDateWorkerのCronスケジュールに依存。

## セキュリティ考慮事項

- 機密Issue（confidential: true）の場合、X-GitLab-ConfidentialIssueヘッダーがtrueに設定される
- 受信者が当該Issueへのアクセス権限を持つかの確認はNotificationRecipientクラスで実施
- メール本文に含まれる個人情報（ユーザー名、メールアドレス）は必要最小限

## 備考

- issue_due_emailはmail_answer_threadを使用するため、既存のメールスレッドへの返信として送信される
- skip_current_user: falseにより、Issue作成者本人にも期限通知が送信される
- 期限日は@issue.due_date.to_fs(:medium)形式で表示される
- DueDateWorkerの実行頻度によって通知のタイミングが決まる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、期限通知に必要なデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.rb | `app/models/issue.rb` | due_dateカラム、DueDateStruct定義（31-39行目） |
| 1-2 | sent_notification.rb | `app/models/sent_notification.rb` | 送信通知の記録方法 |

**読解のコツ**: Issueモデルのdue_date関連の定義（DueDateStruct）を確認することで、期限の種類と判定ロジックが理解できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceのissue_dueメソッドを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | issue_dueメソッド（630-642行目）がエントリーポイント |

**主要処理フロー**:
1. **630行目**: `def issue_due(issue)` - 公開メソッド定義
2. **631-637行目**: BuildService.build_recipientsで受信者構築（action: 'due', custom_action: :issue_due, skip_current_user: false）
3. **639-641行目**: 各受信者にissue_due_emailを送信

#### Step 3: メーラー実装を理解する

実際のメール生成処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | issues.rb | `app/mailers/emails/issues.rb` | issue_due_emailメソッド（18-22行目） |

**主要処理フロー**:
- **18行目**: `def issue_due_email(recipient_id, issue_id, reason = nil)` - メソッド定義
- **19行目**: `setup_issue_mail(issue_id, recipient_id)` - 共通セットアップ
- **21行目**: `mail_answer_thread` - スレッド返信形式でメール送信

#### Step 4: ビューテンプレートを理解する

メール本文のレンダリング処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | issue_due_email.html.haml | `app/views/notify/issue_due_email.html.haml` | HTML形式のメール本文テンプレート（全13行） |

**主要処理フロー**:
- **2行目**: 作成者名、Issueリンク、"is due soon"メッセージ
- **4-6行目**: 担当者表示（存在する場合）
- **7-8行目**: 期限日の表示（@issue.due_date.to_fs(:medium)）
- **10-12行目**: Issue説明文のMarkdownレンダリング

### プログラム呼び出し階層図

```
DueDateWorker#perform
    │
    └─ NotificationService#issue_due (notification_service.rb:630)
           │
           ├─ NotificationRecipients::BuildService.build_recipients
           │      │
           │      └─ Builder::Default#build!
           │             ├─ action: 'due'
           │             ├─ custom_action: :issue_due
           │             └─ skip_current_user: false
           │
           └─ recipients.each { Notify.issue_due_email.deliver_later }
                  │
                  └─ Notify#issue_due_email (emails/issues.rb:18)
                         │
                         ├─ #setup_issue_mail
                         │
                         └─ #mail_answer_thread
                                └─ #mail_thread
```

### データフロー図

```
[入力]                      [処理]                           [出力]

DueDateWorker ─────────────▶ NotificationService ────────────▶ Sidekiqキュー
(Cronジョブ)                  #issue_due                          │
     │                            │                              │
     │                            ▼                              │
     │                     BuildService                          │
     │                     (受信者決定)                          │
     │                            │                              │
     │                            ▼                              │
期限間近Issue ─────────────▶ Emails::Issues ─────────────────────┤
(@issue.due_date)           #issue_due_email                     │
                                │                                │
                                ▼                                ▼
                        SentNotification ──────────▶ p_sent_notifications
                        (記録作成)                    テーブル
                                │
                                ▼
                        ActionMailer ────────────────▶ SMTPサーバー
                        (メール送信)                   └─▶ 受信者メールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | サービス | 通知処理のエントリーポイント（630-642行目） |
| issues.rb | `app/mailers/emails/issues.rb` | メーラー | issue_due_emailメソッド定義（18-22行目） |
| notify.rb | `app/mailers/notify.rb` | メーラー | 共通メール処理・ヘッダー設定 |
| issue_due_email.html.haml | `app/views/notify/issue_due_email.html.haml` | テンプレート | HTML形式メール本文 |
| issue.rb | `app/models/issue.rb` | モデル | Issueデータモデル（due_date定義） |
| sent_notification.rb | `app/models/sent_notification.rb` | モデル | 送信通知記録モデル |
| default.rb | `app/services/notification_recipients/builder/default.rb` | サービス | 受信者構築ロジック |
