# 通知設計書 20-relabeled_merge_request_email

## 概要

本ドキュメントは、GitLabにおいてMerge Requestにラベルが追加された際に送信されるメール通知「relabeled_merge_request_email」の設計仕様を定義するものである。

### 本通知の処理概要

この通知は、Merge Request（MR）に新しいラベルが追加された際に、そのラベルを購読しているユーザーに対して通知を送信する機能である。

**業務上の目的・背景**：ラベルはMRの分類やワークフロー管理に使用される重要な機能である。例えば、特定の技術領域、優先度、レビュー状態などを示すラベルがある。ユーザーは関心のあるラベルを購読することで、そのラベルが付いたMRの動きを追跡できる。この通知により、購読しているラベルがMRに追加されたことを認識し、必要なアクションを取ることができる。

**通知の送信タイミング**：MRにラベルが追加された直後に送信される。具体的には、`NotificationService#relabeled_merge_request`メソッドが呼び出された時点で、追加されたラベルを購読しているユーザーに対して非同期でメールが配信される。

**通知の受信者**：追加されたラベルを購読しているユーザーが受信者となる。ラベルの購読は、ユーザーが明示的に設定する必要がある。

**通知内容の概要**：メールには、追加されたラベル名のリスト、対象MRへのリンクが含まれる。

**期待されるアクション**：受信者は通知を確認し、関心のあるMRの状態を把握する。必要に応じてMRを確認し、レビューや作業を行う。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 低 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

受信者は以下のロジックで決定される：

1. 追加された各ラベルの購読者（subscribers）を取得
2. 購読者リストを重複排除（uniq）
3. notifiable_usersでフィルタリング（:subscription、対象MR、操作ユーザーを考慮）

ラベルの購読はプロジェクト単位で管理され、`project_labels_url`へのリンクがメールに含まれる。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信元アドレス |
| 送信元名称 | "{ラベル追加実行者の名前} (@{ユーザー名})" |
| 件名 | "Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号})" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**HTMLバージョン**

単一ラベル追加の場合：
```html
Label added: {label_name}
```

複数ラベル追加の場合：
```html
Labels added: {label_1}, {label_2}, and {label_3}
```

**テキストバージョン**
```
Label(s) added: {label_names}

{mr_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知には添付ファイルは含まれない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @label_names | 追加されたラベル名の配列 | 引数で渡される | Yes |
| @labels_url | ラベル管理ページURL | project_labels_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作/API | MRラベル追加 | ラベルが追加され、購読者がいる場合 | MRの編集画面またはAPIでlabelsが追加された際に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ラベル購読者なし | 追加されたラベルを購読しているユーザーがいない場合 |
| 通知設定が無効 | ユーザーの通知設定がsubscriptionに対応していない場合 |
| プロジェクトのメール無効設定 | プロジェクトでメール通知が無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MRラベル追加] --> B[追加されたラベル特定]
    B --> C[各ラベルの購読者取得]
    C --> D[購読者リスト重複排除]
    D --> E[notifiable_usersでフィルタリング]
    E --> F{受信者あり?}
    F -->|No| G[処理終了]
    F -->|Yes| H[各受信者に対してループ]
    H --> I[Notify.relabeled_merge_request_email生成]
    I --> J[deliver_later実行]
    J --> K[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | MR情報取得 | |
| users | 受信者情報取得 | |
| labels | ラベル情報取得 | |
| label_links | MRとラベルの関連 | |
| subscriptions | ラベル購読情報 | |
| projects | プロジェクト情報取得 | |
| notification_settings | ユーザーの通知設定確認 | |

### テーブル別参照項目詳細

#### labels

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ラベル識別子 | |
| title | ラベル名 | メール本文に使用 |
| project_id | プロジェクトID | |

#### subscriptions

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| subscribable_type | 購読対象タイプ | 'Label' |
| subscribable_id | ラベルID | |
| user_id | 購読ユーザーID | |
| subscribed | 購読フラグ | true |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続失敗 | Sidekiqによる自動リトライ |
| ラベルが見つからない | ラベルが削除済み | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTP接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiterの:notification_emails設定に従う |
| 1日あたり上限 | 設定による |

### 配信時間帯

特定の時間帯制限なし（即時配信）

## セキュリティ考慮事項

- ラベル購読者のみが受信対象
- メール返信機能使用時はreply_keyによる認証が行われる
- ラベルの購読は@labels_urlから解除可能

## 備考

- _relabeled_issuable_email.html.hamlパーシャルを使用して、IssueとMRで共通のテンプレートを利用
- to_sentenceを使用して複数のラベル名を自然な文に変換
- 国際化（I18n）対応のため、単数形/複数形の分岐がある（n_メソッド使用）
- ラベルが削除された場合は通知されない（追加時のみ）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | relabeled_merge_requestメソッド（419-421行目）、relabeled_resource_emailメソッド（847-860行目） |

**主要処理フロー**:
1. **419行目**: `def relabeled_merge_request(merge_request, added_labels, current_user)`
2. **420行目**: `relabeled_resource_email(merge_request, added_labels, current_user, :relabeled_merge_request_email)`
3. **848行目**: 各ラベルの購読者を取得（`labels.flat_map { |l| l.subscribers(target.project) }.uniq`）
4. **849-853行目**: notifiable_usersでフィルタリング
5. **857-858行目**: 各受信者へのメール送信

#### Step 2: メーラーモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | relabeled_merge_request_emailメソッド（97-103行目） |

**主要処理フロー**:
- **97行目**: メソッド定義
- **98行目**: setup_merge_request_mail呼び出し
- **100行目**: @label_namesの設定
- **101行目**: @labels_urlの設定（project_labels_url）
- **102行目**: mail_answer_thread呼び出し

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | relabeled_merge_request_email.html.haml | `app/views/notify/relabeled_merge_request_email.html.haml` | パーシャル呼び出し |
| 3-2 | _relabeled_issuable_email.html.haml | `app/views/notify/_relabeled_issuable_email.html.haml` | 共通パーシャル |
| 3-3 | relabeled_merge_request_email.text.erb | `app/views/notify/relabeled_merge_request_email.text.erb` | テキスト形式 |
| 3-4 | _relabeled_issuable_email.text.erb | `app/views/notify/_relabeled_issuable_email.text.erb` | 共通テキストパーシャル |

**主要処理フロー**:
- **html 1行目**: `render 'relabeled_issuable_email', issuable: @merge_request`
- **パーシャル 2行目**: n_による単数/複数形分岐、to_sentence使用

### プログラム呼び出し階層図

```
MergeRequests::UpdateService#execute (ラベル追加)
    |
    └── NotificationService#relabeled_merge_request
            |
            └── relabeled_resource_email
                    |
                    ├── labels.flat_map { |l| l.subscribers(project) }.uniq
                    |
                    ├── notifiable_users (subscription filter)
                    |
                    └── Notify.relabeled_merge_request_email (for each)
                            |
                            ├── @label_names設定
                            ├── @labels_url設定
                            |
                            └── mail_answer_thread
                                    └── deliver_later
```

### データフロー図

```
[入力]                      [処理]                              [出力]

MergeRequest      ──┐
                    ├──▶ relabeled_merge_request
added_labels      ──┤           │
                    │           ▼
current_user      ──┤    label.subscribers取得
                    │           │
                    │           ▼
                    │    notifiable_usersフィルタ
                    │           │
                    │           ▼
                    └──▶ Notify.relabeled_merge_request_email
                                │
                                └──▶ deliver_later
                                        │
                                        ▼
                                  SMTPサーバー ──▶ 購読者メールボックス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メール生成 |
| relabeled_merge_request_email.html.haml | `app/views/notify/relabeled_merge_request_email.html.haml` | テンプレート | HTML形式 |
| relabeled_merge_request_email.text.erb | `app/views/notify/relabeled_merge_request_email.text.erb` | テンプレート | テキスト形式 |
| _relabeled_issuable_email.html.haml | `app/views/notify/_relabeled_issuable_email.html.haml` | テンプレート | 共通HTMLパーシャル |
| _relabeled_issuable_email.text.erb | `app/views/notify/_relabeled_issuable_email.text.erb` | テンプレート | 共通テキストパーシャル |
| label.rb | `app/models/label.rb` | ソース | ラベルモデル（subscribersメソッド） |
| subscription.rb | `app/models/subscription.rb` | ソース | 購読モデル |
