# 通知設計書 21-removed_milestone_merge_request_email

## 概要

本ドキュメントは、Merge Requestからマイルストーンが削除された際に、関係者へ通知するメール送信機能の設計を記載する。

### 本通知の処理概要

Merge Requestからマイルストーンが削除されたことを、関係者にメールで通知する機能である。

**業務上の目的・背景**：Merge Requestには進捗管理や期限管理のためにマイルストーンを設定することができる。マイルストーンが削除された場合、関係者が変更を認識しないままスケジュール管理に齟齬が生じる可能性がある。本通知により、Merge Requestの関係者がマイルストーン削除を即座に把握し、必要に応じてスケジュールの再調整や確認を行うことができる。

**通知の送信タイミング**：Merge Requestに設定されていたマイルストーンが削除（設定解除）された時点で送信される。具体的には、NotificationServiceのremoved_milestoneメソッドが呼び出された際にトリガーされる。

**通知の受信者**：Merge Requestの参加者（author、assignees、reviewers）、プロジェクトのWatch設定ユーザー、カスタム通知設定で「removed_milestone」を有効にしているユーザー、Merge Requestを購読しているユーザーが受信対象となる。

**通知内容の概要**：マイルストーンが削除されたことを示すメッセージ、対象Merge RequestのURL、Merge Requestのタイトルと参照番号が含まれる。

**期待されるアクション**：受信者は、マイルストーン削除の理由を確認し、必要に応じて新しいマイルストーンの設定や、関連するスケジュールの見直しを行うことが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqの標準リトライ設定に準拠 |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_recipientsを使用して受信者を決定する。以下の条件に該当するユーザーが対象となる：

1. Merge Requestの参加者（participants）
2. プロジェクトのWatch設定ユーザー
3. カスタム通知レベルで対象イベントを有効にしているユーザー
4. Merge Requestの購読者

current_userは送信対象から除外される（skip_current_user: true）。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabの設定に基づくシステムメールアドレス |
| 送信元名称 | 操作実行者の名前（user_name (user_reference)形式） |
| 件名 | Re: {project_name} \| {merge_request_title} ({merge_request_reference}) |
| 形式 | HTML/テキスト両対応 |

### 本文テンプレート

```
Milestone removed
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | 対象のMerge Request | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @target_url | Merge RequestのURL | project_merge_request_url | Yes |
| @recipient | 受信者 | User.find(recipient_id) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Merge Requestのマイルストーン削除 | マイルストーンが設定されていたMRからマイルストーンが削除された場合 | UIからのマイルストーン削除操作 |
| API | MergeRequest更新API | milestone_idがnullに更新された場合 | REST/GraphQL API経由でのマイルストーン削除 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール通知無効 | project.emails_disabled?がtrueの場合 |
| ユーザーの通知設定 | 受信者の通知レベルがDisabledの場合 |
| 操作実行者への送信抑止 | 自分自身の操作による通知は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[マイルストーン削除イベント] --> B[NotificationService.removed_milestone]
    B --> C[NotificationRecipients::BuildService.build_recipients]
    C --> D{受信者が存在?}
    D -->|Yes| E[各受信者へメール送信]
    D -->|No| F[終了]
    E --> G[Notify.removed_milestone_merge_request_email]
    G --> H[mail_answer_thread]
    H --> I[deliver_later]
    I --> J[Sidekiqキュー登録]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | 対象MR情報取得 | merge_request_id指定 |
| users | 受信者・操作者情報 | recipient_id, updated_by_user_id |
| projects | プロジェクト情報 | merge_request.project |
| notification_settings | 通知設定確認 | 受信者決定時 |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別 | WHERE id = merge_request_id |
| title | メール件名 | - |
| iid | MR参照番号 | to_reference用 |
| project_id | プロジェクト取得 | - |
| author_id | 作成者情報 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | noteable_type | 'MergeRequest' | 対象種別 |
| INSERT | noteable_id | merge_request_id | 対象ID |
| INSERT | recipient_id | recipient_id | 受信者ID |
| INSERT | reply_key | 生成されたキー | 返信用キー |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによる自動リトライ |
| MR未存在 | 削除済みMR | ActiveRecord::RecordNotFoundで処理中断 |
| ユーザー未存在 | 削除済みユーザー | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTPタイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定に準拠 |
| 1日あたり上限 | 設定なし |

### 配信時間帯

制限なし（イベント発生時に即座に配信）

## セキュリティ考慮事項

- 受信者はMerge Requestの閲覧権限を持つユーザーに限定される
- メール本文には機密情報を含まない（タイトル、URLのみ）
- Reply-Toにはpartitioned_reply_keyを使用し、返信の認証に利用

## 備考

- 本通知はIssueのマイルストーン削除通知（removed_milestone_issue_email）と同様のロジックで実装されている
- NotificationService.removed_milestoneメソッドで、対象がMergeRequestかIssueかによってメソッドを切り替えている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知の対象となるMerge Requestとマイルストーンの関係を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | MergeRequestモデルのmilestone関連メソッド |

**読解のコツ**: MergeRequestはIssuableをincludeしており、milestoneとの関連はそこで定義されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | removed_milestoneメソッド（735-752行目） |

**主要処理フロー**:
1. **735行目**: removed_milestoneメソッドの定義開始
2. **736-741行目**: 対象がIssueかMergeRequestかでメール種別を決定
3. **743-747行目**: NotificationRecipients::BuildServiceで受信者を決定
4. **749-751行目**: 各受信者へmailer.sendでメール送信をdeliver_later

#### Step 3: 受信者決定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build_service.rb | `app/services/notification_recipients/build_service.rb` | build_recipientsメソッド |
| 3-2 | default.rb | `app/services/notification_recipients/builder/default.rb` | Defaultビルダーの実装 |
| 3-3 | base.rb | `app/services/notification_recipients/builder/base.rb` | 受信者フィルタリングロジック |

**主要処理フロー**:
- **default.rb 27-58行目**: build!メソッドで参加者、Watcher、カスタム通知、購読者を収集

#### Step 4: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | removed_milestone_merge_request_emailメソッド（105-109行目） |
| 4-2 | notify.rb | `app/mailers/notify.rb` | 基底クラスとメール送信共通処理 |

**主要処理フロー**:
- **105-109行目**: setup_merge_request_mailでMR情報をセットアップし、mail_answer_threadでメール送信

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | removed_milestone_merge_request_email.text.erb | `app/views/notify/removed_milestone_merge_request_email.text.erb` | テキストメール本文 |
| 5-2 | removed_milestone_merge_request_email.html.haml | `app/views/notify/removed_milestone_merge_request_email.html.haml` | HTMLメール本文 |

### プログラム呼び出し階層図

```
NotificationService.removed_milestone(target, current_user)
    │
    ├─ NotificationRecipients::BuildService.build_recipients
    │      ├─ Builder::Default.new(target, current_user, action: 'removed_milestone')
    │      │      ├─ add_participants
    │      │      ├─ add_project_watchers
    │      │      ├─ add_custom_notifications
    │      │      └─ add_subscribed_users
    │      └─ filter! (notifiable?チェック)
    │
    └─ Notify.removed_milestone_merge_request_email
           ├─ setup_merge_request_mail
           │      ├─ MergeRequest.find
           │      ├─ User.find(recipient_id)
           │      └─ SentNotification.record
           └─ mail_answer_thread
                  └─ deliver_later
```

### データフロー図

```
[入力]                    [処理]                           [出力]

MergeRequest ───────────▶ NotificationService
                         .removed_milestone
                              │
current_user ───────────▶     │
                              ▼
                         BuildService.build_recipients ──▶ recipients[]
                              │
                              ▼
                         Notify.removed_milestone_
                         merge_request_email
                              │
                              ▼
                         mail_answer_thread ─────────────▶ Email送信
                              │
                              ▼
                         SentNotification.record ────────▶ sent_notifications
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービスのエントリーポイント |
| build_service.rb | `app/services/notification_recipients/build_service.rb` | ソース | 受信者決定サービス |
| default.rb | `app/services/notification_recipients/builder/default.rb` | ソース | デフォルト受信者ビルダー |
| base.rb | `app/services/notification_recipients/builder/base.rb` | ソース | ビルダー基底クラス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メールメソッド定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| removed_milestone_merge_request_email.text.erb | `app/views/notify/removed_milestone_merge_request_email.text.erb` | テンプレート | テキストメール本文 |
| removed_milestone_merge_request_email.html.haml | `app/views/notify/removed_milestone_merge_request_email.html.haml` | テンプレート | HTMLメール本文 |
