# 通知設計書 26-merge_request_status_email

## 概要

本ドキュメントは、Merge Requestのステータスが変更された際に、関係者へ通知するメール送信機能の設計を記載する。

### 本通知の処理概要

Merge Requestのステータスが変更されたこと（主にreopenされたこと）を、関係者にメールで通知する機能である。

**業務上の目的・背景**：Merge Requestは一度クローズされた後、再度オープンされる（reopen）場合がある。この状態変化は、作業の再開やレビューの再実施が必要であることを意味する。本通知により、関係者はMerge Requestの状態変化を即座に把握し、再度のコードレビューや対応が可能となる。

**通知の送信タイミング**：Merge Requestのステータスが変更された時点で送信される。現在の実装では主にreopen時（reopen_mr）にトリガーされ、ステータスとして'reopened'が渡される。

**通知の受信者**：Merge Requestの参加者（author、assignees、reviewers）、プロジェクトのWatch設定ユーザー、カスタム通知設定で「reopen_merge_request」を有効にしているユーザー、Merge Requestを購読しているユーザーが受信対象となる。

**通知内容の概要**：Merge Requestのステータスが変更されたこと、変更後のステータス（例：reopened）、変更を行った人の名前、対象Merge RequestのURL、Merge Requestのタイトルと参照番号が含まれる。

**期待されるアクション**：受信者は、ステータス変更の理由を確認し、reopenの場合はコードレビューの再開や追加のコミットの確認を行うことが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqの標準リトライ設定に準拠 |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_recipientsを使用して受信者を決定する。action: "reopen"が指定される。以下の条件に該当するユーザーが対象となる：

1. Merge Requestの参加者（participants）
2. プロジェクトのWatch設定ユーザー
3. カスタム通知レベルで対象イベントを有効にしているユーザー
4. Merge Requestの購読者

current_userは送信対象から除外される（skip_current_user: true）。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabの設定に基づくシステムメールアドレス |
| 送信元名称 | 操作実行者の名前（user_name (user_reference)形式） |
| 件名 | Re: {project_name} \| {merge_request_title} ({merge_request_reference}) |
| 形式 | HTML/テキスト両対応 |

### 本文テンプレート

**テキスト形式**:
```
Merge request {merge_request_reference} was {status} by {updated_by_name}

Merge request URL: {merge_request_url}

{source_branch} -> {target_branch}

Author: {author_name}
Assignees: {assignees}
Reviewers: {reviewers}
```

**HTML形式**:
```html
<p>Merge request {merge_request_link} was {status} by {updated_by_name}</p>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | 対象のMerge Request | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @target_url | Merge RequestのURL | project_merge_request_url | Yes |
| @recipient | 受信者 | User.find(recipient_id) | Yes |
| @mr_status | 変更後のステータス | 引数から取得（例：'reopened'） | Yes |
| @updated_by | ステータス変更した人 | User.find(updated_by_user_id) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Merge Requestのreopenボタン押下 | MRがクローズ状態からオープンに変更された場合 | UIからのreopen操作 |
| API | MergeRequest更新API | stateがopenedに更新された場合 | REST/GraphQL API経由でのreopen |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール通知無効 | project.emails_disabled?がtrueの場合 |
| ユーザーの通知設定 | 受信者の通知レベルがDisabledの場合 |
| 操作実行者への送信抑止 | 自分自身の操作による通知は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MRステータス変更イベント] --> B[NotificationService.reopen_mr]
    B --> C[reopen_resource_email]
    C --> D[NotificationRecipients::BuildService.build_recipients]
    D --> E{受信者が存在?}
    E -->|Yes| F[各受信者へメール送信]
    E -->|No| G[終了]
    F --> H[Notify.merge_request_status_email]
    H --> I[setup_merge_request_mail]
    I --> J[@mr_status, @updated_by セット]
    J --> K[mail_answer_thread]
    K --> L[deliver_later]
    L --> M[Sidekiqキュー登録]
    M --> N[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | 対象MR情報取得 | merge_request_id指定 |
| users | 受信者・操作者・作成者情報 | recipient_id, updated_by_user_id, author_id |
| projects | プロジェクト情報 | merge_request.project |
| notification_settings | 通知設定確認 | 受信者決定時 |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別 | WHERE id = merge_request_id |
| title | メール件名 | - |
| iid | MR参照番号 | to_reference用 |
| project_id | プロジェクト取得 | - |
| author_id | 作成者情報 | - |
| source_branch | ソースブランチ | merge_path_description用 |
| target_branch | ターゲットブランチ | merge_path_description用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによる自動リトライ |
| MR未存在 | 削除済みMR | ActiveRecord::RecordNotFoundで処理中断 |
| ユーザー未存在 | 削除済みユーザー | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTPタイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定に準拠 |
| 1日あたり上限 | 設定なし |

### 配信時間帯

制限なし（イベント発生時に即座に配信）

## セキュリティ考慮事項

- 受信者はMerge Requestの閲覧権限を持つユーザーに限定される
- ユーザー名はsanitize_nameでサニタイズされて表示される
- Reply-Toにはpartitioned_reply_keyを使用し、返信の認証に利用

## 備考

- 本通知はreopen_resource_emailを通じて呼び出される汎用的なステータス変更通知
- Issueのreopen通知（issue_status_changed_email）と同様のパターンで実装されている
- ステータス文字列（例：'reopened'）は引数として渡され、テンプレート内で表示される
- 将来的に他のステータス変更にも対応可能な設計となっている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知の対象となるMerge Requestの状態管理を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | MergeRequestモデルのstate管理 |

**読解のコツ**: MergeRequestはstateカラムでオープン/クローズ/マージ状態を管理している。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | reopen_mrメソッド（440-447行目） |

**主要処理フロー**:
1. **440-447行目**: reopen_mrメソッドの定義
2. **441-446行目**: reopen_resource_emailを呼び出し
3. **444行目**: :merge_request_status_emailを指定
4. **445行目**: ステータスとして'reopened'を指定

#### Step 3: 共通処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification_service.rb | `app/services/notification_service.rb` | reopen_resource_emailメソッド（862-868行目） |

**主要処理フロー**:
- **862-868行目**: action: "reopen"で受信者を決定し、各受信者へメール送信
- **866行目**: statusを5番目の引数としてメールメソッドに渡す

#### Step 4: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | merge_request_status_emailメソッド（147-153行目） |
| 4-2 | notify.rb | `app/mailers/notify.rb` | 基底クラスとメール送信共通処理 |

**主要処理フロー**:
- **147-153行目**: setup_merge_request_mailでMR情報をセットアップ
- **150行目**: @mr_statusにステータス文字列をセット
- **151行目**: @updated_byにステータス変更者をセット
- **152行目**: mail_answer_threadでメール送信

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | merge_request_status_email.text.haml | `app/views/notify/merge_request_status_email.text.haml` | テキストメール本文 |
| 5-2 | merge_request_status_email.html.haml | `app/views/notify/merge_request_status_email.html.haml` | HTMLメール本文 |

### プログラム呼び出し階層図

```
NotificationService.reopen_mr(merge_request, current_user)
    │
    └─ reopen_resource_email(merge_request, current_user,
                             :merge_request_status_email, 'reopened')
           │
           ├─ NotificationRecipients::BuildService.build_recipients
           │      ├─ action: "reopen"
           │      ├─ Builder::Default.new(...)
           │      │      ├─ add_participants
           │      │      ├─ add_project_watchers
           │      │      ├─ add_custom_notifications
           │      │      └─ add_subscribed_users
           │      └─ filter! (notifiable?チェック)
           │
           └─ Notify.merge_request_status_email(recipient_id, mr_id, status, ...)
                  ├─ setup_merge_request_mail
                  ├─ @mr_status = status
                  ├─ @updated_by = User.find(updated_by_user_id)
                  └─ mail_answer_thread
                         └─ deliver_later
```

### データフロー図

```
[入力]                    [処理]                           [出力]

MergeRequest ───────────▶ NotificationService.reopen_mr
                              │
current_user ───────────▶     │
                              │
status='reopened' ──────▶     │
                              ▼
                         reopen_resource_email
                              │
                              ▼
                         BuildService.build_recipients ──▶ recipients[]
                              │
                              ▼
                         Notify.merge_request_status_email
                              │
                              ├─ @mr_status, @updated_by
                              ▼
                         mail_answer_thread ─────────────▶ Email送信
                              │
                              ▼
                         SentNotification.record ────────▶ sent_notifications
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービスのエントリーポイント |
| build_service.rb | `app/services/notification_recipients/build_service.rb` | ソース | 受信者決定サービス |
| default.rb | `app/services/notification_recipients/builder/default.rb` | ソース | デフォルト受信者ビルダー |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メールメソッド定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| merge_request_status_email.text.haml | `app/views/notify/merge_request_status_email.text.haml` | テンプレート | テキストメール本文 |
| merge_request_status_email.html.haml | `app/views/notify/merge_request_status_email.html.haml` | テンプレート | HTMLメール本文 |
