# 通知設計書 28-resolved_all_discussions_email

## 概要

本ドキュメントは、Merge Requestの全ディスカッションが解決された際に、関係者へ通知するメール送信機能の設計を記載する。

### 本通知の処理概要

Merge Requestに存在するすべてのディスカッション（コメントスレッド）が解決されたことを、関係者にメールで通知する機能である。

**業務上の目的・背景**：コードレビューでは、レビュアーがコメントやディスカッションを通じてフィードバックを行う。すべてのディスカッションが解決されたことは、レビューの指摘事項がすべて対応されたことを意味し、マージの準備が整ったことを示す重要なマイルストーンである。本通知により、関係者はMerge Requestがマージ可能な状態に近づいたことを即座に把握し、最終確認やマージの実行に進むことができる。

**通知の送信タイミング**：Merge Requestの最後のディスカッションが解決された時点で送信される。具体的には、NotificationServiceのresolve_all_discussionsメソッドが呼び出された際にトリガーされる。

**通知の受信者**：Merge Requestの参加者（author、assignees、reviewers）、プロジェクトのWatch設定ユーザー、カスタム通知設定で「resolve_all_discussions」を有効にしているユーザー、Merge Requestを購読しているユーザーが受信対象となる。

**通知内容の概要**：すべてのディスカッションが解決されたこと、解決した人の名前、対象Merge RequestのURL、Merge Requestのタイトルと参照番号が含まれる。

**期待されるアクション**：受信者は、すべての指摘事項が解決されたことを確認し、追加のレビューが不要であればMerge Requestをマージする、または最終承認を行うことが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqの標準リトライ設定に準拠 |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_recipientsを使用して受信者を決定する。action: "resolve_all_discussions"が指定される。以下の条件に該当するユーザーが対象となる：

1. Merge Requestの参加者（participants）
2. プロジェクトのWatch設定ユーザー
3. カスタム通知レベルで対象イベントを有効にしているユーザー
4. Merge Requestの購読者

current_userは送信対象から除外される（skip_current_user: true）。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabの設定に基づくシステムメールアドレス |
| 送信元名称 | 操作実行者の名前（user_name (user_reference)形式） |
| 件名 | Re: {project_name} \| {merge_request_title} ({merge_request_reference}) |
| 形式 | HTML/テキスト両対応 |

### 本文テンプレート

**テキスト形式**:
```
All discussions on merge request {merge_request_reference} were resolved by {resolved_by_name}

{merge_request_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | 対象のMerge Request | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @target_url | Merge RequestのURL | project_merge_request_url | Yes |
| @recipient | 受信者 | User.find(recipient_id) | Yes |
| @resolved_by | ディスカッションを解決した人 | User.find(resolved_by_user_id) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ディスカッション解決ボタン押下 | 最後の未解決ディスカッションが解決された場合 | UIからのディスカッション解決操作 |
| API | Note解決API | 全ディスカッションが解決状態になった場合 | REST/GraphQL API経由での解決 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール通知無効 | project.emails_disabled?がtrueの場合 |
| ユーザーの通知設定 | 受信者の通知レベルがDisabledの場合 |
| 操作実行者への送信抑止 | 自分自身の操作による通知は送信しない |
| 未解決ディスカッションが残っている | すべてが解決されていない場合は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ディスカッション解決イベント] --> B{全て解決?}
    B -->|No| C[終了]
    B -->|Yes| D[NotificationService.resolve_all_discussions]
    D --> E[NotificationRecipients::BuildService.build_recipients]
    E --> F{受信者が存在?}
    F -->|Yes| G[各受信者へメール送信]
    F -->|No| H[終了]
    G --> I[Notify.resolved_all_discussions_email]
    I --> J[setup_merge_request_mail]
    J --> K[@resolved_by セット]
    K --> L[mail_answer_thread]
    L --> M[deliver_later]
    M --> N[Sidekiqキュー登録]
    N --> O[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | 対象MR情報取得 | merge_request_id指定 |
| users | 受信者・操作者情報 | recipient_id, resolved_by_user_id |
| projects | プロジェクト情報 | merge_request.project |
| notification_settings | 通知設定確認 | 受信者決定時 |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別 | WHERE id = merge_request_id |
| title | メール件名 | - |
| iid | MR参照番号 | to_reference用 |
| project_id | プロジェクト取得 | - |
| target_project_id | ターゲットプロジェクト | URL生成用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによる自動リトライ |
| MR未存在 | 削除済みMR | ActiveRecord::RecordNotFoundで処理中断 |
| ユーザー未存在 | 削除済みユーザー | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTPタイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定に準拠 |
| 1日あたり上限 | 設定なし |

### 配信時間帯

制限なし（イベント発生時に即座に配信）

## セキュリティ考慮事項

- 受信者はMerge Requestの閲覧権限を持つユーザーに限定される
- ユーザー名はsanitize_nameでサニタイズされて表示される
- Reply-Toにはpartitioned_reply_keyを使用し、返信の認証に利用

## 備考

- 本通知はすべてのディスカッションが解決された場合にのみ送信される
- 個別のディスカッション解決時には送信されない
- 「ディスカッション」はresolvableなコメントスレッドを指す
- マージ要件として「すべてのディスカッションの解決」が設定されている場合、この通知はマージ可能になったことを示唆する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知の対象となるMerge Requestとディスカッションの関係を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | MergeRequestモデルのdiscussions関連 |
| 1-2 | discussion.rb | `app/models/discussion.rb` | Discussionモデルの構造 |

**読解のコツ**: MergeRequestにはdiscussionsがあり、各discussionにはresolved状態がある。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | resolve_all_discussionsメソッド（449-458行目） |

**主要処理フロー**:
1. **449-458行目**: resolve_all_discussionsメソッドの定義
2. **450-453行目**: action: "resolve_all_discussions"で受信者を決定
3. **455-457行目**: 各受信者へresolved_all_discussions_emailを送信

#### Step 3: 受信者決定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build_service.rb | `app/services/notification_recipients/build_service.rb` | build_recipientsメソッド |
| 3-2 | default.rb | `app/services/notification_recipients/builder/default.rb` | Defaultビルダーの実装 |
| 3-3 | base.rb | `app/services/notification_recipients/builder/base.rb` | 受信者フィルタリングロジック |

**主要処理フロー**:
- **default.rb 27-58行目**: build!メソッドで参加者、Watcher、カスタム通知、購読者を収集

#### Step 4: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | resolved_all_discussions_emailメソッド（161-166行目） |
| 4-2 | notify.rb | `app/mailers/notify.rb` | 基底クラスとメール送信共通処理 |

**主要処理フロー**:
- **161-166行目**: setup_merge_request_mailでMR情報をセットアップ
- **164行目**: @resolved_byに解決した人をセット
- **165行目**: mail_answer_threadでメール送信

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | resolved_all_discussions_email.text.erb | `app/views/notify/resolved_all_discussions_email.text.erb` | テキストメール本文 |

### プログラム呼び出し階層図

```
NotificationService.resolve_all_discussions(merge_request, current_user)
    │
    ├─ NotificationRecipients::BuildService.build_recipients
    │      ├─ action: "resolve_all_discussions"
    │      ├─ Builder::Default.new(...)
    │      │      ├─ add_participants
    │      │      ├─ add_project_watchers
    │      │      ├─ add_custom_notifications
    │      │      └─ add_subscribed_users
    │      └─ filter! (notifiable?チェック)
    │
    └─ Notify.resolved_all_discussions_email(recipient_id, mr_id, resolved_by_id, reason)
           ├─ setup_merge_request_mail
           │      ├─ MergeRequest.find
           │      ├─ User.find(recipient_id)
           │      └─ SentNotification.record
           ├─ @resolved_by = User.find(resolved_by_user_id)
           └─ mail_answer_thread(resolved_by_user_id)
                  └─ deliver_later
```

### データフロー図

```
[入力]                    [処理]                           [出力]

MergeRequest ───────────▶ NotificationService
                         .resolve_all_discussions
current_user ───────────▶     │
                              ▼
                         BuildService.build_recipients ──▶ recipients[]
                              │
                              ▼
                         Notify.resolved_all_discussions_email
                              │
                              ├─ @resolved_by
                              ▼
                         mail_answer_thread ─────────────▶ Email送信
                              │
                              ▼
                         SentNotification.record ────────▶ sent_notifications
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービスのエントリーポイント |
| build_service.rb | `app/services/notification_recipients/build_service.rb` | ソース | 受信者決定サービス |
| default.rb | `app/services/notification_recipients/builder/default.rb` | ソース | デフォルト受信者ビルダー |
| base.rb | `app/services/notification_recipients/builder/base.rb` | ソース | ビルダー基底クラス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メールメソッド定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| resolved_all_discussions_email.text.erb | `app/views/notify/resolved_all_discussions_email.text.erb` | テンプレート | テキストメール本文 |
