# 通知設計書 29-merge_when_pipeline_succeeds_email

## 概要

本ドキュメントは、Merge Requestにパイプライン成功時の自動マージ（Merge When Pipeline Succeeds / MWPS）が設定された際に、関係者へ通知するメール送信機能の設計を記載する。

### 本通知の処理概要

Merge Requestにパイプライン成功時の自動マージ（MWPS）が設定されたことを、関係者にメールで通知する機能である。

**業務上の目的・背景**：GitLabでは、CIパイプラインが成功した後に自動的にマージを行う「Merge When Pipeline Succeeds」機能がある。この機能が設定されると、パイプライン成功後にMerge Requestが自動的にマージされる。本通知により、関係者はMerge Requestが自動マージの待機状態に入ったことを把握し、マージ前に追加の確認が必要な場合は対応できる。

**通知の送信タイミング**：Merge Requestに自動マージ（MWPS）が設定された時点で送信される。具体的には、NotificationServiceのmerge_when_pipeline_succeedsメソッドが呼び出された際にトリガーされる。

**通知の受信者**：Merge Requestの参加者（author、assignees、reviewers）、プロジェクトのWatch設定ユーザー、カスタム通知設定で「merge_when_pipeline_succeeds」を有効にしているユーザー、Merge Requestを購読しているユーザーが受信対象となる。

**通知内容の概要**：Merge Requestが自動マージに設定されたこと、設定した人の名前、対象Merge RequestのURL、プロジェクト情報、ブランチ情報、作成者、アサイン先、レビュアーが含まれる。

**期待されるアクション**：受信者は、自動マージが設定されたことを確認し、パイプライン実行状況を監視する、または自動マージをキャンセルする必要がある場合は対応することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqの標準リトライ設定に準拠 |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_recipientsを使用して受信者を決定する。action: "merge_when_pipeline_succeeds"、custom_action: :merge_when_pipeline_succeedsが指定される。以下の条件に該当するユーザーが対象となる：

1. Merge Requestの参加者（participants）
2. プロジェクトのWatch設定ユーザー
3. カスタム通知レベルで対象イベントを有効にしているユーザー
4. Merge Requestの購読者

current_userは送信対象から除外される（skip_current_user: true）。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabの設定に基づくシステムメールアドレス |
| 送信元名称 | 操作実行者の名前（user_name (user_reference)形式） |
| 件名 | Re: {project_name} \| {merge_request_title} ({merge_request_reference}) |
| 形式 | HTML/テキスト両対応 |
| レイアウト | mailer（特別なレイアウト使用） |

### 本文テンプレート

**テキスト形式**:
```
Merge request {merge_request_reference} was set to auto-merge by {mwps_set_by_name}

Merge request url: {merge_request_url}

{source_branch} -> {target_branch}

Author: {author_name}
Assignees: {assignees}
Reviewers: {reviewers}
```

**HTML形式**:
成功を示す緑色のバナー、マージリクエスト情報、プロジェクト情報、ブランチ情報、作成者、アサイン先、レビュアーを含むリッチなHTML形式。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 本通知に添付ファイルはない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | 対象のMerge Request | MergeRequest.find(merge_request_id) | Yes |
| @project | 対象プロジェクト | @merge_request.project | Yes |
| @target_url | Merge RequestのURL | project_merge_request_url | Yes |
| @recipient | 受信者 | User.find(recipient_id) | Yes |
| @mwps_set_by | 自動マージを設定した人 | User.find(mwps_set_by_user_id) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 「Merge when pipeline succeeds」ボタン押下 | MWPSが設定された場合 | UIからのMWPS設定 |
| API | Auto-merge設定API | auto_merge_enabledがtrueになった場合 | REST/GraphQL API経由での設定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール通知無効 | project.emails_disabled?がtrueの場合 |
| ユーザーの通知設定 | 受信者の通知レベルがDisabledの場合 |
| 操作実行者への送信抑止 | 自分自身の操作による通知は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MWPS設定イベント] --> B[NotificationService.merge_when_pipeline_succeeds]
    B --> C[NotificationRecipients::BuildService.build_recipients]
    C --> D{受信者が存在?}
    D -->|Yes| E[各受信者へメール送信]
    D -->|No| F[終了]
    E --> G[Notify.merge_when_pipeline_succeeds_email]
    G --> H[setup_merge_request_mail]
    H --> I[@mwps_set_by セット]
    I --> J[mail_answer_thread]
    J --> K[deliver_later]
    K --> L[Sidekiqキュー登録]
    L --> M[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | 対象MR情報取得 | merge_request_id指定 |
| users | 受信者・操作者情報 | recipient_id, mwps_set_by_user_id |
| projects | プロジェクト情報 | merge_request.project |
| notification_settings | 通知設定確認 | 受信者決定時 |
| groups | グループ情報 | namespace情報取得 |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別 | WHERE id = merge_request_id |
| title | メール件名 | - |
| iid | MR参照番号 | to_reference用 |
| project_id | プロジェクト取得 | - |
| author_id | 作成者情報 | - |
| source_branch | ソースブランチ | テンプレート表示用 |
| target_branch | ターゲットブランチ | テンプレート表示用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信通知の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによる自動リトライ |
| MR未存在 | 削除済みMR | ActiveRecord::RecordNotFoundで処理中断 |
| ユーザー未存在 | 削除済みユーザー | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー、SMTPタイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定に準拠 |
| 1日あたり上限 | 設定なし |

### 配信時間帯

制限なし（イベント発生時に即座に配信）

## セキュリティ考慮事項

- 受信者はMerge Requestの閲覧権限を持つユーザーに限定される
- ユーザー名はsanitize_nameでサニタイズされて表示される
- Reply-Toにはpartitioned_reply_keyを使用し、返信の認証に利用

## 備考

- 本通知は特別なレイアウト（'mailer'）を使用する（override_layout_lookup_tableで定義）
- HTML版は視覚的にリッチなデザインで、成功を示す緑色のバナーを含む
- MWPSが設定されたMRは、パイプライン成功後に自動的にmerged_merge_request_emailが送信される
- MWPSのキャンセル時には別の通知は送信されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知の対象となるMerge Requestの自動マージ設定を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge_request.rb | `app/models/merge_request.rb` | auto_merge_enabled関連フラグ |

**読解のコツ**: auto_merge_enabledフラグとmerge_userの関係を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | merge_when_pipeline_succeedsメソッド（708-719行目） |

**主要処理フロー**:
1. **708-719行目**: merge_when_pipeline_succeedsメソッドの定義
2. **709-714行目**: action: "merge_when_pipeline_succeeds", custom_action: :merge_when_pipeline_succeedsで受信者を決定
3. **716-718行目**: 各受信者へmerge_when_pipeline_succeeds_emailを送信

#### Step 3: レイアウト設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | override_layout_lookup_table（7-13行目） |

**主要処理フロー**:
- **7-13行目**: merge_when_pipeline_succeeds_emailに'mailer'レイアウトを指定

#### Step 4: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | merge_when_pipeline_succeeds_emailメソッド（168-173行目） |
| 4-2 | notify.rb | `app/mailers/notify.rb` | 基底クラスとメール送信共通処理 |

**主要処理フロー**:
- **168-173行目**: setup_merge_request_mailでMR情報をセットアップ
- **171行目**: @mwps_set_byにMWPS設定者をセット
- **172行目**: mail_answer_threadでメール送信

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | merge_when_pipeline_succeeds_email.text.haml | `app/views/notify/merge_when_pipeline_succeeds_email.text.haml` | テキストメール本文 |
| 5-2 | merge_when_pipeline_succeeds_email.html.haml | `app/views/notify/merge_when_pipeline_succeeds_email.html.haml` | HTMLメール本文（リッチデザイン） |

**読解のコツ**: HTML版は緑色のバナーやアバター画像を含むリッチなデザイン。assignees_label、reviewers_labelヘルパーを使用。

### プログラム呼び出し階層図

```
NotificationService.merge_when_pipeline_succeeds(merge_request, current_user)
    │
    ├─ NotificationRecipients::BuildService.build_recipients
    │      ├─ action: "merge_when_pipeline_succeeds"
    │      ├─ custom_action: :merge_when_pipeline_succeeds
    │      ├─ Builder::Default.new(...)
    │      │      ├─ add_participants
    │      │      ├─ add_project_watchers
    │      │      ├─ add_custom_notifications
    │      │      └─ add_subscribed_users
    │      └─ filter! (notifiable?チェック)
    │
    └─ Notify.merge_when_pipeline_succeeds_email(recipient_id, mr_id, mwps_set_by_id)
           ├─ setup_merge_request_mail
           │      ├─ MergeRequest.find
           │      ├─ User.find(recipient_id)
           │      └─ SentNotification.record
           ├─ @mwps_set_by = User.find(mwps_set_by_user_id)
           └─ mail_answer_thread(mwps_set_by_user_id)
                  └─ deliver_later
```

### データフロー図

```
[入力]                    [処理]                           [出力]

MergeRequest ───────────▶ NotificationService
                         .merge_when_pipeline_succeeds
current_user ───────────▶     │
                              ▼
                         BuildService.build_recipients ──▶ recipients[]
                              │
                              ▼
                         Notify.merge_when_pipeline_succeeds_email
                              │
                              ├─ @mwps_set_by
                              ├─ layout: 'mailer'
                              ▼
                         mail_answer_thread ─────────────▶ Email送信
                              │
                              ▼
                         SentNotification.record ────────▶ sent_notifications
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービスのエントリーポイント |
| build_service.rb | `app/services/notification_recipients/build_service.rb` | ソース | 受信者決定サービス |
| default.rb | `app/services/notification_recipients/builder/default.rb` | ソース | デフォルト受信者ビルダー |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メールメソッド定義、レイアウト設定 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| merge_when_pipeline_succeeds_email.text.haml | `app/views/notify/merge_when_pipeline_succeeds_email.text.haml` | テンプレート | テキストメール本文 |
| merge_when_pipeline_succeeds_email.html.haml | `app/views/notify/merge_when_pipeline_succeeds_email.html.haml` | テンプレート | HTMLメール本文（リッチデザイン） |
| _mailer.html.haml | `app/views/layouts/_mailer.html.haml` | レイアウト | メールレイアウト |
