# 通知設計書 31-approved_merge_request_email

## 概要

本ドキュメントは、GitLabにおけるMerge Request承認通知（approved_merge_request_email）の設計を記述したものである。

### 本通知の処理概要

**業務上の目的・背景**：コードレビュープロセスにおいて、Merge Requestの承認は重要なマイルストーンである。承認者がMerge Requestを承認した際に、関係者に通知することで、マージ準備が整ったことを迅速に把握でき、開発サイクルの効率化に寄与する。特にEE版では承認ルール（required approvals）が設定されている場合、現在の承認状況を把握することが業務上不可欠である。

**通知の送信タイミング**：ユーザーがMerge Requestを承認（Approve）した時点で送信される。具体的には、MergeRequests::ApprovalServiceのexecuteメソッドが成功した後、NotificationService#approve_mrを経由してメールが送信される。

**通知の受信者**：Merge Requestに関連する以下のユーザーが受信者となる。作成者（Author）、アサイン先（Assignees）、レビュアー（Reviewers）、およびカスタム通知設定で「approve」アクションを有効にしているプロジェクトメンバー。受信者はNotificationRecipients::BuildServiceによって決定される。

**通知内容の概要**：承認されたMerge Requestの情報（タイトル、参照番号、プロジェクト、ブランチ、作成者）、承認者の情報、および現在の承認状況（EE版では承認数/必要承認数）が含まれる。

**期待されるアクション**：受信者はMerge Requestの承認状況を確認し、必要な承認数が満たされている場合はマージを実行する。追加のレビューが必要な場合は、他のレビュアーに確認を依頼する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_recipientsを使用し、action: 'approve'として受信者を決定する。具体的には以下の条件でフィルタリングされる：

1. Merge Requestの作成者、アサイン先、レビュアー
2. プロジェクトのwatch設定を持つユーザー
3. カスタム通知設定で承認通知を有効にしているユーザー
4. 通知が無効化されていないユーザー（Disabled以外）

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定のデフォルト送信元 |
| 送信元名称 | {承認者名} (@{承認者ユーザー名}) |
| 件名 | Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号}) |
| 形式 | HTML/テキスト（両形式） |

### 本文テンプレート

**HTML版：**
```
Merge request was approved (x/y) ※EE版のみ承認数表示

Merge request {MR参照番号} was approved by {承認者アバター} {承認者名}

Project: {ネームスペース}/{プロジェクト名}
Branch: {ソースブランチ}
Author: {作成者アバター} {作成者名}
Assignees: {アサイン先一覧}
Reviewers: {レビュアー一覧}

[View merge request] ボタン
```

**テキスト版：**
```
Merge request {MR参照番号} was approved by {承認者名}

Merge request URL: {MR URL}

{ソースブランチ} -> {ターゲットブランチ}

Author: {作成者名}
Assignees: {アサイン先一覧}
Reviewers: {レビュアー一覧}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @merge_request | Merge Requestオブジェクト | MergeRequest.find(merge_request_id) | Yes |
| @approved_by | 承認者ユーザー | User.find(approved_by_user_id) | Yes |
| @project | プロジェクト | @merge_request.project | Yes |
| @target_url | MRのURL | project_merge_request_url | Yes |
| @recipient | 受信者ユーザー | User.find(recipient_id) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Merge Request承認ボタンクリック | 承認が正常に記録された場合 | WebUI経由での承認 |
| API | Merge Request Approve API呼び出し | 承認が正常に記録された場合 | API経由での承認 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトでメール無効 | project.emails_disabled?がtrueの場合 |
| 受信者の通知設定がDisabled | ユーザーが通知を無効化している場合 |
| 既にマージ済み | merge_request.merged?がtrueの場合（ApprovalServiceで制御） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Merge Request承認] --> B[MergeRequests::ApprovalService#execute]
    B --> C{承認可能か?}
    C -->|No| D[処理終了]
    C -->|Yes| E[Approval.create]
    E --> F[EventStore: ApprovedEvent発行]
    F --> G[NotificationService#approve_mr]
    G --> H[NotificationRecipients::BuildService]
    H --> I[受信者リスト生成]
    I --> J[各受信者にメール送信]
    J --> K[Notify.approved_merge_request_email.deliver_later]
    K --> L[Sidekiqでメール送信実行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| merge_requests | Merge Request情報取得 | 承認対象のMR |
| users | ユーザー情報取得 | 承認者、受信者、作成者 |
| projects | プロジェクト情報取得 | 通知設定の確認 |
| approvals | 承認情報取得 | 承認数の確認（EE） |
| notification_settings | 通知設定取得 | 受信者決定 |
| members | メンバー情報取得 | 受信者決定 |

### テーブル別参照項目詳細

#### merge_requests

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | MR識別 | merge_request_id |
| title | メール件名・本文 | - |
| iid | 参照番号 | - |
| author_id | 作成者取得 | - |
| source_branch | ブランチ情報 | - |
| target_project_id | プロジェクト取得 | - |

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | approved_by_user_id, recipient_id |
| name | 表示名 | - |
| email | 送信先メールアドレス | notification_email_for使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信記録の保存 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | noteable_type | 'MergeRequest' | - |
| INSERT | noteable_id | merge_request_id | - |
| INSERT | recipient_id | 受信者ID | - |
| INSERT | reply_key | 生成されたキー | メール返信用 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqリトライ |
| テンプレートエラー | 変数が見つからない | 例外ログ記録 |
| 宛先不正 | メールアドレス形式エラー | スキップして次の受信者へ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なSMTPエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | ApplicationRateLimiter :notification_emails 設定に従う |
| 1日あたり上限 | 設定なし |

### 配信時間帯

制限なし（即座に送信）

## セキュリティ考慮事項

- 受信者は通知設定に基づいてフィルタリングされ、権限のないユーザーには送信されない
- メール本文にはMerge Requestの内容が含まれるため、機密情報を含む場合は注意が必要
- Reply-Toヘッダーには暗号化されたキーが含まれ、メール返信によるコメント追加が可能

## 備考

- EE版では承認数/必要承認数が表示される（approvals_required）
- mailerレイアウトは'mailer'が使用される（override_layout_lookup_tableで設定）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、承認に関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | approval.rb | `app/models/approval.rb` | Approvalモデルの構造（user_id, merge_request_id, patch_id_sha） |
| 1-2 | merge_request.rb | `app/models/merge_request.rb` | MergeRequestモデルとapprovalsの関連 |

**読解のコツ**: Railsのアソシエーション（has_many :approvals）に注目する。

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | approval_service.rb | `app/services/merge_requests/approval_service.rb` | 承認処理の起点、EventStore発行 |

**主要処理フロー**:
1. **5行目**: `execute(merge_request)` - メイン処理開始
2. **6-7行目**: eligible_for_approval?とmerged?チェック
3. **9-12行目**: Approval.new と save_approval
4. **30-35行目**: EventStore.publish(ApprovedEvent)

#### Step 3: 通知サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification_service.rb | `app/services/notification_service.rb` | approve_mr, approve_mr_emailメソッド |

**主要処理フロー**:
- **721-723行目**: `approve_mr` - NotificationServiceのエントリーポイント
- **934-939行目**: `approve_mr_email` - 実際のメール送信処理

#### Step 4: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | merge_requests.rb | `app/mailers/emails/merge_requests.rb` | approved_merge_request_emailメソッドの実装 |
| 4-2 | notify.rb | `app/mailers/notify.rb` | Notifyクラスの構造、mail_answer_thread |

**主要処理フロー**:
- **190-195行目**: `approved_merge_request_email` - メール生成
- **191行目**: `setup_merge_request_mail` - 共通セットアップ
- **193行目**: `@approved_by = User.find(approved_by_user_id)` - 承認者取得
- **194行目**: `mail_answer_thread` - スレッド形式でメール送信

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | approved_merge_request_email.html.haml | `app/views/notify/approved_merge_request_email.html.haml` | HTML版テンプレート構造 |
| 5-2 | approved_merge_request_email.text.haml | `app/views/notify/approved_merge_request_email.text.haml` | テキスト版テンプレート |

**読解のコツ**: HAMLテンプレートの`@merge_request`、`@approved_by`変数の使用箇所に注目

### プログラム呼び出し階層図

```
MergeRequests::ApprovalService#execute
    │
    ├─ Approval#save
    │
    ├─ Gitlab::EventStore.publish(ApprovedEvent)
    │      └─ (イベント購読者による非同期処理)
    │
    └─ NotificationService#approve_mr (別経路からも呼び出し可能)
           │
           └─ approve_mr_email
                  │
                  ├─ NotificationRecipients::BuildService.build_recipients
                  │
                  └─ Notify#approved_merge_request_email
                         │
                         ├─ setup_merge_request_mail
                         │      └─ SentNotification.record
                         │
                         └─ mail_answer_thread
                                └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

merge_request_id ───┬──▶ MergeRequests::ApprovalService ───▶ Approval (DB)
                    │            │
current_user ───────┤            ▼
                    │    NotificationService
                    │            │
                    │            ▼
                    │    NotificationRecipients::BuildService
                    │            │
                    │            ▼
                    └──▶ Notify#approved_merge_request_email ───▶ Email (SMTP)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| approval_service.rb | `app/services/merge_requests/approval_service.rb` | ソース | 承認処理サービス |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理サービス |
| merge_requests.rb | `app/mailers/emails/merge_requests.rb` | ソース | MR関連メーラー |
| notify.rb | `app/mailers/notify.rb` | ソース | メインメーラークラス |
| approved_merge_request_email.html.haml | `app/views/notify/approved_merge_request_email.html.haml` | テンプレート | HTML版メールテンプレート |
| approved_merge_request_email.text.haml | `app/views/notify/approved_merge_request_email.text.haml` | テンプレート | テキスト版メールテンプレート |
| build_service.rb | `app/services/notification_recipients/build_service.rb` | ソース | 受信者決定サービス |
