# 通知設計書 35-note_merge_request_email

## 概要

本ドキュメントは、GitLabにおけるMerge Requestへのコメント通知（note_merge_request_email）の設計を記述したものである。

### 本通知の処理概要

**業務上の目的・背景**：Merge Requestはコードレビューの中心的な機能であり、MR上でのコメントによる議論はコード品質向上に不可欠である。Merge Requestにコメントが追加された際に関係者に通知することで、レビューフィードバックへの迅速な対応が可能になる。

**通知の送信タイミング**：ユーザーがMerge Requestにコメント（Note）を追加した時点で送信される。これにはMR全体へのコメントと、特定のコード行へのコメント（diff note）の両方が含まれる。

**通知の受信者**：コメントが追加されたMerge Requestに関連する以下のユーザーが受信者となる。MR作成者、アサイン先、レビュアー、既存のディスカッション参加者、メンションされたユーザー、MRにサブスクライブしているユーザー、プロジェクトのwatch設定を持つユーザー。

**通知内容の概要**：コメントが追加されたMerge Requestの情報（タイトル、参照番号）、コメントの内容、コメント投稿者の情報が含まれる。diff discussionの場合は対象ファイルとコード差分プレビューが含まれる。

**期待されるアクション**：受信者はコメント内容を確認し、レビューフィードバックに対応する。コード修正、追加説明、ディスカッションへの返信などのアクションを実行する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_new_note_recipientsを使用して受信者を決定する。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定のデフォルト送信元 |
| 送信元名称 | {コメント投稿者名} (@{コメント投稿者ユーザー名}) |
| 件名 | Re: {プロジェクト名} \| {MRタイトル} ({MR参照番号}) |
| 形式 | HTML/テキスト（両形式） |

### 本文テンプレート

**HTML版：**
```
{コメント投稿者名} commented:（または started a new discussion on {ファイルパス}）

{コード差分プレビュー（diff discussionの場合）}

{コメント本文（Markdown形式）}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @note | Noteオブジェクト | Note.find(note_id) | Yes |
| @merge_request | Merge Requestオブジェクト | @note.noteable | Yes |
| @project | プロジェクト | @note.project | Yes |
| @target_url | コメントへのURL | project_merge_request_url + anchor | Yes |
| discussion | ディスカッションオブジェクト | @note.discussion | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | MR詳細画面でコメント投稿 | コメントが正常に保存された場合 | WebUI経由 |
| 画面操作 | diffビューでの行コメント | コメントが正常に保存された場合 | コード行へのコメント |
| API | Notes API呼び出し | コメントが正常に保存された場合 | API経由 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| システムノート | system_note_with_references?がtrueの場合 |
| 受信者の通知設定がDisabled | ユーザーが通知を無効化している場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[MRにコメント追加] --> B[Note.create]
    B --> C[NotificationService#new_note]
    C --> D{noteable_type確認}
    D -->|MergeRequest| E[note_merge_request_email選択]
    E --> F[send_new_note_notifications]
    F --> G[NotificationRecipients::BuildService]
    G --> H[各受信者にメール送信]
    H --> I[Notify.note_merge_request_email.deliver_later]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| notes | コメント情報取得 | - |
| merge_requests | MR情報取得 | - |
| users | ユーザー情報取得 | - |
| projects | プロジェクト情報取得 | diff表示設定含む |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信記録の保存 |

## エラー処理

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |

## セキュリティ考慮事項

- 受信者は通知設定とMRへのアクセス権限に基づいてフィルタリングされる
- diff表示はプロジェクト設定に従う

## 備考

- diff discussionの場合、X-GitLab-Discussion-IDヘッダーが設定される
- コード差分プレビューは`show_diff_preview_in_email?`設定に従う

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notes.rb | `app/mailers/emails/notes.rb` | note_merge_request_emailメソッド（28-34行目） |

**主要処理フロー**:
- **28-34行目**: `note_merge_request_email` - メール生成
- **31行目**: `@merge_request = @note.noteable` - MR取得
- **32行目**: `project_merge_request_url` - URL生成
- **33行目**: `mail_answer_note_thread` - スレッド形式送信

### プログラム呼び出し階層図

```
Note.create (MRへのコメント)
    │
    └─ NotificationService#new_note
           │
           └─ send_new_note_notifications
                  │
                  ├─ notify_method = :note_merge_request_email
                  │
                  └─ Notify.note_merge_request_email
                         │
                         ├─ setup_note_mail
                         │
                         └─ mail_answer_note_thread
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notes.rb | `app/mailers/emails/notes.rb` | ソース | Note関連メーラー |
| note_merge_request_email.html.haml | `app/views/notify/note_merge_request_email.html.haml` | テンプレート | HTML版 |
| _note_email.html.haml | `app/views/notify/_note_email.html.haml` | テンプレート | 共通パーシャル |
