# 通知設計書 36-note_snippet_email

## 概要

本ドキュメントは、GitLabにおけるスニペットへのコメント通知（note_snippet_email）の設計を記述したものである。

### 本通知の処理概要

**業務上の目的・背景**：スニペットはコードの断片やテキストを共有するための機能であり、プロジェクトスニペットと個人スニペットがある。スニペットにコメントが追加された際に関係者に通知することで、共有コードに関するフィードバックや質問への迅速な対応が可能になる。

**通知の送信タイミング**：ユーザーがスニペット（ProjectSnippetまたはSnippet）にコメント（Note）を追加した時点で送信される。

**通知の受信者**：コメントが追加されたスニペットに関連する以下のユーザーが受信者となる。スニペット作成者、既存のディスカッション参加者、メンションされたユーザー。

**通知内容の概要**：コメントが追加されたスニペットの情報（タイトル）、コメントの内容、コメント投稿者の情報が含まれる。

**期待されるアクション**：受信者はコメント内容を確認し、必要に応じて返信を行う。質問への回答やコードの改善提案への対応を行う。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_new_note_recipientsを使用して受信者を決定する。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定のデフォルト送信元 |
| 送信元名称 | {コメント投稿者名} (@{コメント投稿者ユーザー名}) |
| 件名 | Re: {プロジェクト名} \| {スニペットタイトル} ({スニペット参照}) |
| 形式 | HTML/テキスト（両形式） |

### 本文テンプレート

```
{コメント投稿者名} commented:

{コメント本文（Markdown形式）}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @note | Noteオブジェクト | Note.find(note_id) | Yes |
| @snippet | スニペットオブジェクト | @note.noteable | Yes |
| @project | プロジェクト（ProjectSnippetの場合） | @note.project | No |
| @target_url | コメントへのURL | project_snippet_url or gitlab_snippet_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | スニペット画面でコメント投稿 | コメントが正常に保存された場合 | WebUI経由 |
| API | Notes API呼び出し | コメントが正常に保存された場合 | API経由 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| システムノート | system_note_with_references?がtrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[スニペットにコメント追加] --> B[Note.create]
    B --> C[NotificationService#new_note]
    C --> D{noteable_type確認}
    D -->|Snippet| E[note_snippet_email選択]
    E --> F[send_new_note_notifications]
    F --> G[受信者決定]
    G --> H[Notify.note_snippet_email.deliver_later]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| notes | コメント情報取得 | - |
| snippets | スニペット情報取得 | ProjectSnippetまたはSnippet |
| users | ユーザー情報取得 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信記録の保存 |

## 備考

- ProjectSnippetの場合は`project_snippet_url`、個人Snippetの場合は`gitlab_snippet_url`が使用される
- スニペットの種類（ProjectSnippet/Snippet）によってURLの生成ロジックが異なる

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notes.rb | `app/mailers/emails/notes.rb` | note_snippet_emailメソッド（36-48行目） |

**主要処理フロー**:
- **36-48行目**: `note_snippet_email` - メール生成
- **38行目**: `@snippet = @note.noteable` - スニペット取得
- **40-45行目**: スニペット種類によるURL分岐（ProjectSnippet vs Snippet）
- **47行目**: `mail_answer_note_thread` - スレッド形式送信

### プログラム呼び出し階層図

```
Note.create (スニペットへのコメント)
    │
    └─ NotificationService#new_note
           │
           └─ send_new_note_notifications
                  │
                  ├─ notify_method = :note_snippet_email
                  │
                  └─ Notify.note_snippet_email
                         │
                         ├─ setup_note_mail
                         │
                         ├─ URL生成（種類による分岐）
                         │    ├─ ProjectSnippet → project_snippet_url
                         │    └─ Snippet → gitlab_snippet_url
                         │
                         └─ mail_answer_note_thread
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notes.rb | `app/mailers/emails/notes.rb` | ソース | Note関連メーラー |
| note_snippet_email.html.haml | `app/views/notify/note_snippet_email.html.haml` | テンプレート | HTML版 |
| _note_email.html.haml | `app/views/notify/_note_email.html.haml` | テンプレート | 共通パーシャル |
