# 通知設計書 37-note_design_email

## 概要

本ドキュメントは、GitLabにおけるデザイン（Design）へのコメント通知（note_design_email）の設計を記述したものである。

### 本通知の処理概要

**業務上の目的・背景**：GitLabのDesign Management機能では、Issueに画像やデザインファイルを添付し、それに対してコメントを付けることができる。デザインにコメントが追加された際に関係者に通知することで、デザインレビューのフィードバックへの迅速な対応が可能になる。

**通知の送信タイミング**：ユーザーがデザイン（DesignManagement::Design）にコメント（Note）を追加した時点で送信される。デザイン上の特定の位置（座標）へのコメントも含まれる。

**通知の受信者**：コメントが追加されたデザインに関連する以下のユーザーが受信者となる。デザインが属するIssueの作成者、アサイン先、既存のディスカッション参加者、メンションされたユーザー、プロジェクトのwatch設定を持つユーザー。

**通知内容の概要**：コメントが追加されたデザインの情報（ファイル名、関連Issue）、コメントの内容、コメント投稿者の情報が含まれる。

**期待されるアクション**：受信者はデザインへのフィードバックを確認し、必要に応じてデザインの修正や返信を行う。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_new_note_recipientsを使用して受信者を決定する。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定のデフォルト送信元 |
| 送信元名称 | {コメント投稿者名} (@{コメント投稿者ユーザー名}) |
| 件名 | Re: {プロジェクト名} \| {デザインタイトル} ({デザイン参照}) |
| 形式 | HTML/テキスト（両形式） |

### 本文テンプレート

```
{コメント投稿者名} commented:

{コメント本文（Markdown形式）}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @note | Noteオブジェクト | Note.find(note_id) | Yes |
| design | デザインオブジェクト | @note.noteable | Yes |
| @project | プロジェクト | @note.resource_parent | Yes |
| @target_url | コメントへのURL | designs_project_issue_url + vueroute | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | デザイン画面でコメント投稿 | コメントが正常に保存された場合 | WebUI経由 |
| API | Notes API呼び出し | コメントが正常に保存された場合 | API経由 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| システムノート | system_note_with_references?がtrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デザインにコメント追加] --> B[Note.create]
    B --> C[NotificationService#new_note]
    C --> D{noteable_type確認}
    D -->|Design| E[note_design_email選択]
    E --> F[send_new_note_notifications]
    F --> G[受信者決定]
    G --> H[Notify.note_design_email.deliver_later]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| notes | コメント情報取得 | - |
| design_management_designs | デザイン情報取得 | - |
| issues | 関連Issue情報取得 | - |
| users | ユーザー情報取得 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信記録の保存 |

## 備考

- URLにはvuerouteパラメータが含まれ、デザインファイル名が指定される
- デザインはIssueに紐づくため、resource_parentを通じてプロジェクトを取得

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notes.rb | `app/mailers/emails/notes.rb` | note_design_emailメソッド（50-60行目） |

**主要処理フロー**:
- **50-60行目**: `note_design_email` - メール生成
- **53行目**: `design = @note.noteable` - デザイン取得
- **54-58行目**: `designs_project_issue_url` - 特殊なURL生成（vueroute含む）
- **59行目**: `mail_answer_note_thread` - スレッド形式送信

### プログラム呼び出し階層図

```
Note.create (デザインへのコメント)
    │
    └─ NotificationService#new_note
           │
           └─ send_new_note_notifications
                  │
                  ├─ notify_method = :note_design_email
                  │
                  └─ Notify.note_design_email
                         │
                         ├─ setup_note_mail
                         │
                         ├─ URL生成
                         │    └─ designs_project_issue_url
                         │         └─ vueroute: design.filename
                         │
                         └─ mail_answer_note_thread
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notes.rb | `app/mailers/emails/notes.rb` | ソース | Note関連メーラー |
| note_design_email.html.haml | `app/views/notify/note_design_email.html.haml` | テンプレート | HTML版 |
| _note_email.html.haml | `app/views/notify/_note_email.html.haml` | テンプレート | 共通パーシャル |
