# 通知設計書 38-note_wiki_page_email

## 概要

本ドキュメントは、GitLabにおけるWikiページへのコメント通知（note_wiki_page_email）の設計を記述したものである。

### 本通知の処理概要

**業務上の目的・背景**：GitLabのWiki機能では、プロジェクトやグループのドキュメントを管理できる。Wikiページにコメントが追加された際に関係者に通知することで、ドキュメントに関するフィードバックや質問への迅速な対応が可能になる。

**通知の送信タイミング**：ユーザーがWikiページ（WikiPage）にコメント（Note）を追加した時点で送信される。

**通知の受信者**：コメントが追加されたWikiページに関連する以下のユーザーが受信者となる。既存のディスカッション参加者、メンションされたユーザー、プロジェクト/グループのwatch設定を持つユーザー。

**通知内容の概要**：コメントが追加されたWikiページの情報（タイトル）、コメントの内容、コメント投稿者の情報が含まれる。

**期待されるアクション**：受信者はWikiページへのフィードバックを確認し、必要に応じてドキュメントの更新や返信を行う。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

NotificationRecipients::BuildService.build_new_note_recipientsを使用して受信者を決定する。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定のデフォルト送信元 |
| 送信元名称 | {コメント投稿者名} (@{コメント投稿者ユーザー名}) |
| 件名 | Re: {プロジェクト/グループ名} \| {Wikiページタイトル} ({Wiki参照}) |
| 形式 | HTML/テキスト（両形式） |

### 本文テンプレート

```
{コメント投稿者名} commented:

{コメント本文（Markdown形式）}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @note | Noteオブジェクト | Note.find(note_id) | Yes |
| @wiki_page | WikiPageオブジェクト | @note.noteable | Yes |
| @project | プロジェクト（プロジェクトWikiの場合） | @note.project | No |
| @group | グループ（グループWikiの場合） | @note.noteable.resource_parent | No |
| @target_url | コメントへのURL | Gitlab::UrlBuilder.build | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Wikiページ画面でコメント投稿 | コメントが正常に保存された場合 | WebUI経由 |
| API | Notes API呼び出し | コメントが正常に保存された場合 | API経由 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| システムノート | system_note_with_references?がtrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[WikiページにComment追加] --> B[Note.create]
    B --> C[NotificationService#new_note]
    C --> D{noteable_type確認}
    D -->|WikiPage| E[note_wiki_page_email選択]
    E --> F[send_new_note_notifications]
    F --> G[受信者決定]
    G --> H[Notify.note_wiki_page_email.deliver_later]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| notes | コメント情報取得 | - |
| wiki_pages | WikiページMeta情報 | - |
| users | ユーザー情報取得 | - |
| projects | プロジェクト情報（プロジェクトWikiの場合） | - |
| namespaces | グループ情報（グループWikiの場合） | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sent_notifications | INSERT | 送信記録の保存 |

## 備考

- Gitlab::UrlBuilder.buildを使用してURLを生成
- プロジェクトWikiとグループWikiの両方に対応
- @groupはsetup_note_mail内でresource_parentから取得可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notes.rb | `app/mailers/emails/notes.rb` | note_wiki_page_emailメソッド（62-69行目） |

**主要処理フロー**:
- **62-69行目**: `note_wiki_page_email` - メール生成
- **65行目**: `@wiki_page = @note.noteable` - WikiPage取得
- **66行目**: `Gitlab::UrlBuilder.build` - URL生成
- **68行目**: `mail_answer_note_thread` - スレッド形式送信

### プログラム呼び出し階層図

```
Note.create (WikiページへのComment)
    │
    └─ NotificationService#new_note
           │
           └─ send_new_note_notifications
                  │
                  ├─ notify_method = :note_wiki_page_email
                  │
                  └─ Notify.note_wiki_page_email
                         │
                         ├─ setup_note_mail
                         │    └─ @group取得（GroupWikiの場合）
                         │
                         ├─ Gitlab::UrlBuilder.build
                         │
                         └─ mail_answer_note_thread
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notes.rb | `app/mailers/emails/notes.rb` | ソース | Note関連メーラー |
| note_wiki_page_email.html.haml | `app/views/notify/note_wiki_page_email.html.haml` | テンプレート | HTML版 |
| _note_email.html.haml | `app/views/notify/_note_email.html.haml` | テンプレート | 共通パーシャル |
