# 通知設計書 39-pipeline_success_email

## 概要

本ドキュメントは、GitLabにおけるパイプライン成功通知（pipeline_success_email）の設計を記述したものである。

### 本通知の処理概要

**業務上の目的・背景**：CI/CDパイプラインは、コードの品質を保証するための重要なプロセスである。パイプラインが成功した際に関係者に通知することで、コードがビルド・テストを通過したことを迅速に把握でき、次のステップ（デプロイ、マージなど）への移行を判断できる。

**通知の送信タイミング**：パイプラインが成功ステータス（success）で完了した時点で送信される。NotificationService#pipeline_finishedを経由し、ステータスに応じてpipeline_success_emailが選択される。

**通知の受信者**：パイプラインに関連する以下のユーザーが受信者となる。パイプラインをトリガーしたユーザー、カスタム通知設定で「成功パイプライン」を有効にしているユーザー。ユーザーの通知設定（watch/custom）に基づいてフィルタリングされる。

**通知内容の概要**：成功したパイプラインの情報（パイプラインID/名前、プロジェクト、ブランチ、コミット情報、コミット作成者、トリガーユーザー）、実行されたジョブ数とステージ数が含まれる。

**期待されるアクション**：受信者はパイプラインの成功を確認し、デプロイの実行、Merge Requestのマージ、次のタスクへの移行などを検討する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

NotificationService内でnotifiable_usersを使用して受信者を決定する。custom_action: :success_pipelineとしてフィルタリングされる。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定のデフォルト送信元 |
| 送信元名称 | GitLab |
| 件名 | {プロジェクト名} \| Successful pipeline for {ブランチ名} \| {短縮SHA} |
| 形式 | HTML/テキスト（両形式） |

### 本文テンプレート

**HTML版：**
```
[緑色バナー] Pipeline {パイプライン名 or #ID} has passed!

Project: {ネームスペース}/{プロジェクト名}
Branch: {ブランチ名}
Commit: {短縮SHA} in {MR参照番号（あれば）}
        {コミットメッセージ（50文字まで）}
Commit Author: {コミット作成者アバター} {コミット作成者名}
Committed by: {コミッター名（異なる場合）}

Pipeline {パイプラインリンク} triggered by {トリガーユーザーアバター} {トリガーユーザー名}
successfully completed {ジョブ数} jobs in {ステージ数} stages.
```

**テキスト版：**
```
Pipeline {パイプライン名 or #ID} has passed!

Project: {プロジェクト名} ( {プロジェクトURL} )
Branch: {ブランチ名} ( {ブランチURL} )
Merge request: {MR参照番号} ( {MR URL} ) ※あれば

Commit: {短縮SHA} ( {コミットURL} )
Commit Message: {コミットメッセージ（50文字まで）}
Commit Author: {コミット作成者名} ( {ユーザーURL} )
Committed by: {コミッター名} ( {ユーザーURL} ) ※異なる場合

Pipeline {パイプライン名 or #ID} ( {パイプラインURL} ) triggered by {トリガーユーザー名} ( {ユーザーURL} )
successfully completed {ジョブ数} jobs in {ステージ数} stages.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @pipeline | パイプラインオブジェクト | 引数から | Yes |
| @project | プロジェクト | @pipeline.project | Yes |
| @merge_request | 関連MR | @pipeline.merge_request or merge_requests_as_head_pipeline.first | No |
| recipient | 受信者メールアドレス | 引数から | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | パイプライン成功完了 | 通知設定で有効化されている場合 | パイプライン成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトでメール無効 | project.emails_disabled?がtrueの場合 |
| ユーザー通知設定 | success_pipeline通知が無効の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[パイプライン完了] --> B{ステータス確認}
    B -->|success| C[NotificationService#pipeline_finished]
    B -->|failed| D[pipeline_failed_email]
    B -->|fixed| E[pipeline_fixed_email]
    C --> F[email_template_name = pipeline_success_email]
    F --> G[notifiable_users取得]
    G --> H{custom_action: success_pipeline}
    H --> I[各受信者にメール送信]
    I --> J[Notify.pipeline_success_email.deliver_later]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| ci_pipelines | パイプライン情報取得 | - |
| projects | プロジェクト情報取得 | - |
| merge_requests | 関連MR取得 | - |
| users | ユーザー情報取得 | トリガーユーザー、コミット作成者 |
| notification_settings | 通知設定取得 | - |
| ci_stages | ステージ数取得 | - |

### テーブル別参照項目詳細

#### ci_pipelines

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | パイプライン識別 | - |
| name | パイプライン名 | - |
| status | ステータス | 'success' |
| ref | ブランチ/タグ名 | - |
| sha | コミットSHA | - |
| user_id | トリガーユーザー | - |

### 更新テーブル一覧

更新なし（読み取りのみ）

## エラー処理

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | ApplicationRateLimiter設定に従う |
| 1日あたり上限 | 設定なし |

## セキュリティ考慮事項

- メールにはパイプライン情報が含まれる
- 受信者は通知設定に基づいてフィルタリングされる

## 備考

- パイプライン名が設定されていない場合は#IDが表示される
- merge_request?の場合は@pipeline.merge_requestから、そうでない場合はmerge_requests_as_head_pipeline.firstからMRを取得
- X-GitLab-Pipeline-Id, X-GitLab-Pipeline-Ref, X-GitLab-Pipeline-Statusヘッダーが設定される

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | pipeline_finishedメソッド（562-584行目） |

**主要処理フロー**:
- **562-584行目**: `pipeline_finished` - エントリーポイント
- **565行目**: プロジェクトのメール無効チェック
- **568行目**: `pipeline_notification_status` - ステータス決定
- **569行目**: `email_template_name` - メールテンプレート名生成
- **573-579行目**: `notifiable_users` - 受信者取得
- **581-583行目**: メール送信ループ

#### Step 2: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pipelines.rb | `app/mailers/emails/pipelines.rb` | pipeline_success_emailメソッド（5-7行目） |

**主要処理フロー**:
- **5-7行目**: `pipeline_success_email` - pipeline_mailへの委譲
- **19-36行目**: `pipeline_mail` - 共通メール生成処理
- **38-47行目**: `add_headers`, `add_pipeline_headers` - ヘッダー設定

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pipeline_success_email.html.haml | `app/views/notify/pipeline_success_email.html.haml` | パーシャル呼び出し |
| 3-2 | _successful_pipeline.html.haml | `app/views/notify/_successful_pipeline.html.haml` | 成功パイプライン共通テンプレート |

### プログラム呼び出し階層図

```
Pipeline完了イベント
    │
    └─ NotificationService#pipeline_finished
           │
           ├─ emails_disabled? チェック
           │
           ├─ pipeline_notification_status
           │      └─ 'success' / 'failed' / 'fixed' 判定
           │
           ├─ email_template_name
           │      └─ "pipeline_success_email"
           │
           ├─ notifiable_users
           │      └─ custom_action: :success_pipeline
           │
           └─ Notify.pipeline_success_email
                  │
                  └─ pipeline_mail
                         │
                         ├─ @project = pipeline.project
                         │
                         ├─ @merge_request取得
                         │
                         ├─ add_headers
                         │      └─ add_pipeline_headers
                         │
                         └─ email_with_layout
                                └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

pipeline ─────────────▶ NotificationService#pipeline_finished
                              │
                              ├─ status = 'success'
                              │
                              ├─ email_template = 'pipeline_success_email'
                              │
                              ▼
                       notifiable_users
                              │
                              ├─ custom_action: :success_pipeline
                              │
                              ▼
recipient_emails ────▶ Notify.pipeline_success_email ───▶ Email (SMTP)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理サービス |
| pipelines.rb | `app/mailers/emails/pipelines.rb` | ソース | Pipeline関連メーラー |
| pipeline_success_email.html.haml | `app/views/notify/pipeline_success_email.html.haml` | テンプレート | HTML版 |
| pipeline_success_email.text.erb | `app/views/notify/pipeline_success_email.text.erb` | テンプレート | テキスト版 |
| _successful_pipeline.html.haml | `app/views/notify/_successful_pipeline.html.haml` | テンプレート | 成功パイプライン共通パーシャル |
| _successful_pipeline.text.erb | `app/views/notify/_successful_pipeline.text.erb` | テンプレート | テキスト版共通パーシャル |
