# 通知設計書 43-new_user_email

## 概要

本ドキュメントは、GitLabにおける新規ユーザーアカウント作成通知（new_user_email）の設計仕様を定義するものである。

### 本通知の処理概要

新しいユーザーアカウントが作成された際に、作成されたユーザーに対してアカウント情報とパスワード設定手順を通知する機能である。

**業務上の目的・背景**：GitLabインスタンスに新しいユーザーが追加された際、そのユーザーがアカウントにアクセスできるようにするための初期設定情報を提供する必要がある。セルフサインアップの場合と管理者による作成の場合で異なるメッセージを表示し、適切なオンボーディングを支援する。

**通知の送信タイミング**：ユーザーアカウントが作成された直後に送信される。セルフサインアップの場合はユーザー自身の登録完了時、管理者による作成の場合は管理者がユーザーを作成した時点でトリガーされる。

**通知の受信者**：新しく作成されたユーザー本人。

**通知内容の概要**：ユーザー名（メールアドレス）、パスワード設定リンク（管理者作成の場合）、パスワードリセットリンクの有効期限情報が含まれる。

**期待されるアクション**：受信者はパスワードを設定し（管理者作成の場合）、GitLabインスタンスにログインしてサービスの利用を開始する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（アカウントアクセスに必須） |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. 新規作成されたユーザーを取得
2. ユーザーがOmniAuth（外部認証）経由で作成されていないことを確認
3. ユーザーの通知メールアドレス（notification_email_or_default）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `Account was created for you` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

**セルフサインアップの場合：**
```
Hi {ユーザー名}!

Your account has been created successfully.

login...... {メールアドレス}
```

**管理者による作成の場合：**
```
Hi {ユーザー名}!

The Administrator created an account for you. Now you are a member of the company GitLab application.

login...... {メールアドレス}

Click here to set your password:
{パスワード設定URL}

This link is valid for {有効期間}. After it expires, you can request a new one here:
{パスワードリセットURL}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | ユーザー情報 | User.find(user_id) | Yes |
| @current_user | 現在のユーザー（@userと同じ） | @user | Yes |
| @target_url | ユーザープロフィールURL | user_url(@user) | Yes |
| @token | パスワードリセットトークン | 引数token | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー作成 | Users::CreateService完了 | OmniAuth経由でない、通知可能なユーザー | 新規ユーザー作成時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| OmniAuth作成 | user.identities.any?がtrueの場合は送信しない |
| 通知不可ユーザー | notifiable?がfalseの場合は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー作成完了] --> B[new_user呼び出し]
    B --> C{notifiable?}
    C -->|No| D[送信スキップ]
    C -->|Yes| E{OmniAuth作成?}
    E -->|Yes| D
    E -->|No| F[new_user_email呼び出し]
    F --> G[User.find実行]
    G --> H{管理者作成?}
    H -->|Yes| I[パスワードリセットリンク含む]
    H -->|No| J[シンプルメッセージ]
    I --> K[email_with_layout実行]
    J --> K
    K --> L[deliver_later]
    L --> M[終了]
    D --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | |
| identities | OmniAuth判定 | |
| application_settings | サインアップ許可設定確認 | |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | 引数から取得 |
| name | ユーザー名 | |
| email | メールアドレス | |
| notification_email | 通知用メールアドレス | |
| created_by_id | 作成者ID | 管理者作成判定 |

#### identities

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| user_id | ユーザーID | users.id = identities.user_id |
| provider | 認証プロバイダー | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ActiveRecord::RecordNotFound | user_idに対応するユーザーが存在しない | 例外発生、ログ記録 |
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- パスワードリセットトークンは一時的な有効期限付きで発行
- トークンは推測困難なランダム文字列を使用
- メール本文にパスワード自体は含まれない
- HTTPSリンクを使用

## 備考

- パスワードリセットトークンの有効期限はpassword_reset_token_valid_timeヘルパーで取得
- セルフサインアップの許可設定はGitlab::CurrentSettings.allow_signup?で判定

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザーモデルの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | ユーザーの基本属性、identities関連、notification_email_or_defaultを確認 |

**読解のコツ**: `has_many :identities`の関連に注目し、OmniAuth判定の仕組みを理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | new_userメソッド（461-466行目）がエントリーポイント |

**主要処理フロー**:
1. **461行目**: メソッド定義、userとtoken（オプション）を引数として受け取る
2. **462行目**: `notifiable?(user, :mention)`で通知可能か確認
3. **465行目**: `user.identities.any?`でOmniAuth判定
4. **465行目**: new_user_email呼び出し

#### Step 3: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profile.rb | `app/mailers/emails/profile.rb` | new_user_emailメソッド（7-12行目）の実装 |

**主要処理フロー**:
- **7行目**: メソッド定義、user_idとtokenを引数として受け取る
- **8行目**: @current_userと@userにUser.find結果を設定
- **9行目**: @target_urlにユーザーURL設定
- **10行目**: @tokenにパスワードリセットトークン設定
- **11行目**: email_with_layoutでメール生成

#### Step 4: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new_user_email.html.haml | `app/views/notify/new_user_email.html.haml` | HTML版テンプレート、条件分岐を確認 |
| 4-2 | new_user_email.text.erb | `app/views/notify/new_user_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
NotificationService#new_user (461-466行目)
    │
    ├─ notifiable?(user, :mention) (462行目)
    │      └─ NotificationRecipients::BuildService.notifiable?
    │
    ├─ user.identities.any? (465行目)
    │      └─ OmniAuth判定
    │
    └─ Notify#new_user_email
           └─ Emails::Profile#new_user_email (7-12行目)
                  ├─ User.find(user_id) (8行目)
                  └─ email_with_layout (11行目)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザー作成イベント ───▶ NotificationService            ───▶ メール送信キュー
(user, token)             │                                    (Sidekiq)
                          ├─ 通知可能判定
                          │   └─ notifiable?
                          │
                          ├─ OmniAuth判定
                          │   └─ identities.any?
                          │
                          └─ new_user_email
                               │
                               ├─ @user (ユーザー情報)
                               ├─ @token (リセットトークン)
                               └─ @target_url (プロフィールURL)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| user.rb | `app/models/user.rb` | ソース | ユーザーモデル |
| new_user_email.html.haml | `app/views/notify/new_user_email.html.haml` | テンプレート | HTML版メールテンプレート |
| new_user_email.text.erb | `app/views/notify/new_user_email.text.erb` | テンプレート | テキスト版メールテンプレート |
