# 通知設計書 44-instance_access_request_email

## 概要

本ドキュメントは、GitLabにおけるインスタンスアクセスリクエスト通知（instance_access_request_email）の設計仕様を定義するものである。

### 本通知の処理概要

ユーザーがGitLabインスタンスへのアクセスをリクエストした際に、承認権限を持つ管理者に通知を送信する機能である。

**業務上の目的・背景**：GitLabインスタンスへのアクセスが制限されている環境（セルフサインアップが無効、または承認が必要な設定）において、新規ユーザーがアクセスをリクエストした場合、適切な管理者に迅速に通知する必要がある。これにより、管理者はリクエストを審査し、承認または拒否の判断を行うことができる。

**通知の送信タイミング**：ユーザーがインスタンスへのアクセスリクエストを送信した時点で即座にトリガーされる。

**通知の受信者**：インスタンスアクセスリクエストの承認権限を持つ管理者。User.instance_access_request_approvers_to_be_notifiedメソッドで決定される（最大10人）。

**通知内容の概要**：リクエストしたユーザーのユーザー名、メールアドレス、管理画面へのリンクが含まれる。

**期待されるアクション**：管理者はリクエストを審査し、ユーザーを承認または拒否する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（ユーザーアクセスに影響） |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. `User.instance_access_request_approvers_to_be_notified`メソッドで承認者リストを取得
2. 最大10人の承認者に通知（INSTANCE_ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMIT）
3. 承認者が存在しない場合は通知をスキップ

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `GitLab Account Request` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hello {受信者名},

{リクエストユーザー名} has requested access to your GitLab instance.

Username: {ユーザー名}
Email: {メールアドレス}

{管理画面リンク}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | リクエストユーザー情報 | 引数user | Yes |
| @recipient | 受信者（管理者）情報 | 引数recipient | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| アクセスリクエスト | ユーザーがインスタンスアクセスをリクエスト | 承認者が存在する場合 | 新規ユーザーのアクセスリクエスト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 承認者なし | instance_access_request_approvers_to_be_notifiedが空の場合は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アクセスリクエスト受付] --> B[new_instance_access_request呼び出し]
    B --> C[承認者リスト取得]
    C --> D{承認者が存在?}
    D -->|No| E[処理終了]
    D -->|Yes| F[各承認者にメール送信]
    F --> G[instance_access_request_email呼び出し]
    G --> H[email_with_layout実行]
    H --> I[deliver_later]
    I --> J[終了]
    E --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | リクエストユーザー情報、承認者情報取得 | |
| user_details | ユーザー詳細情報 | |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | |
| username | ユーザー名 | |
| email | メールアドレス | |
| admin | 管理者フラグ | 承認者判定 |
| notification_email | 通知用メールアドレス | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | 承認者のメールアドレスが無効 | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- リクエストユーザーの情報は管理者のみに送信
- 管理画面リンクは認証後のみアクセス可能
- 承認者の上限（10人）を設けて通知スパムを防止

## 備考

- 承認者の選定ロジックはUser.instance_access_request_approvers_to_be_notifiedで定義
- 関連Issue: https://gitlab.com/gitlab-org/gitlab/-/issues/277016

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザーモデルと承認者取得ロジックを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | INSTANCE_ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMIT定数、instance_access_request_approvers_to_be_notifiedメソッド |

**読解のコツ**: 承認者の選定ロジックを理解し、どのユーザーが通知を受け取るかを把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | new_instance_access_requestメソッド（495-503行目）がエントリーポイント |

**主要処理フロー**:
1. **495行目**: メソッド定義、userを引数として受け取る
2. **496行目**: instance_access_request_approvers_to_be_notifiedで承認者取得
3. **498行目**: 承認者が空の場合は早期リターン
4. **500-502行目**: 各承認者に対してメール送信をループ

#### Step 3: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profile.rb | `app/mailers/emails/profile.rb` | instance_access_request_emailメソッド（14-21行目）の実装 |

**主要処理フロー**:
- **14行目**: メソッド定義、userとrecipientを引数として受け取る
- **15-16行目**: @userと@recipientの設定
- **18-20行目**: email_with_layoutでメール生成

#### Step 4: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | instance_access_request_email.html.haml | `app/views/notify/instance_access_request_email.html.haml` | HTML版テンプレート |
| 4-2 | instance_access_request_email.text.erb | `app/views/notify/instance_access_request_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
NotificationService#new_instance_access_request (495-503行目)
    │
    ├─ User.instance_access_request_approvers_to_be_notified (496行目)
    │      └─ 最大10人の承認者を取得
    │
    └─ Notify#instance_access_request_email (501行目)
           └─ Emails::Profile#instance_access_request_email (14-21行目)
                  └─ email_with_layout
```

### データフロー図

```
[入力]                         [処理]                           [出力]

アクセスリクエストイベント ───▶ NotificationService            ───▶ メール送信キュー
(user)                         │                                    (Sidekiq)
                               ├─ 承認者リスト取得
                               │   └─ instance_access_request_approvers_to_be_notified
                               │
                               └─ instance_access_request_email
                                    │
                                    ├─ @user (リクエストユーザー)
                                    └─ @recipient (承認者)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| user.rb | `app/models/user.rb` | ソース | ユーザーモデル、承認者取得ロジック |
| instance_access_request_email.html.haml | `app/views/notify/instance_access_request_email.html.haml` | テンプレート | HTML版メールテンプレート |
| instance_access_request_email.text.erb | `app/views/notify/instance_access_request_email.text.erb` | テンプレート | テキスト版メールテンプレート |
