# 通知設計書 45-user_admin_rejection_email

## 概要

本ドキュメントは、GitLabにおけるユーザー管理者却下通知（user_admin_rejection_email）の設計仕様を定義するものである。

### 本通知の処理概要

ユーザーのインスタンスアクセスリクエストが管理者により却下された際に、リクエストしたユーザーに通知を送信する機能である。

**業務上の目的・背景**：GitLabインスタンスへのアクセスが制限されている環境において、ユーザーがアクセスリクエストを送信した後、管理者がそのリクエストを却下した場合、ユーザーに結果を通知する必要がある。これにより、ユーザーは自身のリクエストの状態を把握し、必要に応じて別の手段でアクセスを求めることができる。

**通知の送信タイミング**：管理者がユーザーのアクセスリクエストを却下した時点で即座にトリガーされる。

**通知の受信者**：アクセスリクエストを却下されたユーザー本人。

**通知内容の概要**：リクエストが却下された旨のメッセージと、管理者への連絡を促す案内が含まれる。

**期待されるアクション**：ユーザーは却下理由について管理者に確認するか、別の方法でアクセス権限を取得する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. 却下されたユーザーのメールアドレスに直接送信
2. 引数として渡されたメールアドレスを使用（usersテーブルの情報ではなく直接指定）

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `GitLab account request rejected` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hello {ユーザー名},

Your request to join {GitLab URL} has been rejected.

Please contact your GitLab administrator if you think this is an error.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @name | ユーザー名 | 引数name | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| リクエスト却下 | 管理者がアクセスリクエストを却下 | なし | ユーザーリクエストの却下時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 特別な抑止条件はなし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者がリクエスト却下] --> B[user_admin_rejection呼び出し]
    B --> C[user_admin_rejection_email呼び出し]
    C --> D[email_with_layout実行]
    D --> E[deliver_later]
    E --> F[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ユーザー名とメールは引数で渡される |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレスが無効 | ログ記録、ジョブ失敗 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- 却下理由は含まれない（管理者の判断を公開しない）
- 管理者への連絡方法は一般的な案内のみ

## 備考

- ユーザー情報はDBから取得せず、引数として直接渡される設計
- これは却下時点でユーザーレコードが既に削除されている可能性があるため

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | user_admin_rejectionメソッド（505-507行目）がエントリーポイント |

**主要処理フロー**:
1. **505行目**: メソッド定義、nameとemailを引数として受け取る
2. **506行目**: user_admin_rejection_email呼び出し

#### Step 2: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | profile.rb | `app/mailers/emails/profile.rb` | user_admin_rejection_emailメソッド（23-28行目）の実装 |

**主要処理フロー**:
- **23行目**: メソッド定義、nameとemailを引数として受け取る
- **24行目**: @name変数の設定
- **26-28行目**: email_with_layoutでメール生成

#### Step 3: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | user_admin_rejection_email.html.haml | `app/views/notify/user_admin_rejection_email.html.haml` | HTML版テンプレート |
| 3-2 | user_admin_rejection_email.text.erb | `app/views/notify/user_admin_rejection_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
NotificationService#user_admin_rejection (505-507行目)
    │
    └─ Notify#user_admin_rejection_email (506行目)
           └─ Emails::Profile#user_admin_rejection_email (23-28行目)
                  └─ email_with_layout
```

### データフロー図

```
[入力]                    [処理]                           [出力]

却下イベント        ───▶ NotificationService            ───▶ メール送信キュー
(name, email)            │                                    (Sidekiq)
                         └─ user_admin_rejection_email
                              │
                              └─ @name (ユーザー名)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| user_admin_rejection_email.html.haml | `app/views/notify/user_admin_rejection_email.html.haml` | テンプレート | HTML版メールテンプレート |
| user_admin_rejection_email.text.erb | `app/views/notify/user_admin_rejection_email.text.erb` | テンプレート | テキスト版メールテンプレート |
