# 通知設計書 46-user_deactivated_email

## 概要

本ドキュメントは、GitLabにおけるユーザーアカウント非アクティブ化通知（user_deactivated_email）の設計仕様を定義するものである。

### 本通知の処理概要

ユーザーアカウントが非アクティブ化された際に、該当ユーザーに対してアカウントの状態と再アクティブ化方法を通知する機能である。

**業務上の目的・背景**：GitLabでは、長期間ログインしていないユーザーや管理者により手動で非アクティブ化されたユーザーのアカウントを非アクティブ状態に変更することがある。この状態変更をユーザーに通知し、アカウントの制限事項と再アクティブ化方法を伝えることで、ユーザーが適切な対応を取れるようにする。

**通知の送信タイミング**：ユーザーアカウントが非アクティブ化された時点で即座にトリガーされる。

**通知の受信者**：非アクティブ化されたユーザー本人。

**通知内容の概要**：アカウントが非アクティブ化された旨、制限事項（Git/APIアクセス不可、通知停止、スラッシュコマンド使用不可）、再アクティブ化方法（ログイン）が含まれる。

**期待されるアクション**：ユーザーはGitLabにログインしてアカウントを再アクティブ化するか、管理者に連絡する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（アカウント状態変更の重要通知） |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. 非アクティブ化されたユーザーのメールアドレスに直接送信
2. 引数として渡されたメールアドレスを使用

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `Your account has been deactivated` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hello {ユーザー名},

Your account has been deactivated for {GitLabホスト}. You will not be able to:

- Access Git repositories or the API.
- Receive any notifications from GitLab.
- Use slash commands.

To reactivate your account, sign in to GitLab at {GitLab URL}.

Please contact your GitLab administrator if you think this is an error.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @name | ユーザー名 | 引数name | Yes |
| @host | GitLabホスト名 | Gitlab.config.gitlab.host | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| アカウント非アクティブ化 | ユーザーが非アクティブ化された | なし | 管理者操作または自動非アクティブ化 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 特別な抑止条件はなし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[アカウント非アクティブ化] --> B[user_deactivated呼び出し]
    B --> C[user_deactivated_email呼び出し]
    C --> D[@name, @host設定]
    D --> E[email_with_layout実行]
    E --> F[deliver_later]
    F --> G[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ユーザー名とメールは引数で渡される |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレスが無効 | ログ記録、ジョブ失敗 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- 非アクティブ化の理由は含まれない
- ログインリンクは一般的なroot_urlを使用（パスワードリセットトークンなし）
- 管理者への連絡方法は一般的な案内のみ

## 備考

- ユーザー情報はDBから取得せず、引数として直接渡される設計
- `_layouts/mailer/user_deactivated_additional_text`パーシャルでカスタムテキストを追加可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | user_deactivatedメソッド（509-511行目）がエントリーポイント |

**主要処理フロー**:
1. **509行目**: メソッド定義、nameとemailを引数として受け取る
2. **510行目**: user_deactivated_email呼び出し

#### Step 2: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | profile.rb | `app/mailers/emails/profile.rb` | user_deactivated_emailメソッド（31-37行目）の実装 |

**主要処理フロー**:
- **31行目**: メソッド定義、nameとemailを引数として受け取る
- **32-33行目**: @nameと@host変数の設定
- **35-37行目**: email_with_layoutでメール生成

#### Step 3: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | user_deactivated_email.html.haml | `app/views/notify/user_deactivated_email.html.haml` | HTML版テンプレート、制限事項リスト |
| 3-2 | user_deactivated_email.text.erb | `app/views/notify/user_deactivated_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
NotificationService#user_deactivated (509-511行目)
    │
    └─ Notify#user_deactivated_email (510行目)
           └─ Emails::Profile#user_deactivated_email (31-37行目)
                  ├─ @name設定 (32行目)
                  ├─ @host設定 (33行目)
                  └─ email_with_layout (35-37行目)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

非アクティブ化イベント ───▶ NotificationService            ───▶ メール送信キュー
(name, email)              │                                    (Sidekiq)
                           └─ user_deactivated_email
                                │
                                ├─ @name (ユーザー名)
                                └─ @host (GitLabホスト)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| user_deactivated_email.html.haml | `app/views/notify/user_deactivated_email.html.haml` | テンプレート | HTML版メールテンプレート |
| user_deactivated_email.text.erb | `app/views/notify/user_deactivated_email.text.erb` | テンプレート | テキスト版メールテンプレート |
| _user_deactivated_additional_text.html.haml | `app/views/layouts/mailer/_user_deactivated_additional_text.html.haml` | テンプレート | カスタムテキストパーシャル |
