# 通知設計書 47-new_ssh_key_email

## 概要

本ドキュメントは、GitLabにおけるSSHキー追加通知（new_ssh_key_email）の設計仕様を定義するものである。

### 本通知の処理概要

ユーザーのアカウントに新しいSSHキーが追加された際に、該当ユーザーにセキュリティ通知を送信する機能である。

**業務上の目的・背景**：SSHキーはGitLabリポジトリへのアクセスに使用される重要な認証情報である。新しいSSHキーの追加はセキュリティに影響を与える操作であるため、アカウント所有者に通知することで、不正なキー追加を早期に検知できるようにする。これはセキュリティメールであり、ユーザーの通知設定に関係なく送信される。

**通知の送信タイミング**：SSHキーがユーザーアカウントに追加された直後にトリガーされる。ただし、デプロイキーの追加時は通知されない。

**通知の受信者**：SSHキーが追加されたユーザー本人（通知を受け取る権限がある場合）。

**通知内容の概要**：追加されたSSHキーのタイトル、削除用リンクが含まれる。

**期待されるアクション**：ユーザーは追加されたキーが自身によるものか確認し、不正な場合は即座に削除する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. 追加されたSSHキーからユーザーを取得
2. `user.can?(:receive_notifications)`で通知受信権限を確認
3. ユーザーの通知メールアドレス（notification_email_or_default）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `SSH key was added to your account` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hi {ユーザー名}!

A new public key was added to your account:

Title: {キータイトル}

If this key was added in error, you can remove it under SSH Keys:
{SSHキー設定URL}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @key | SSHキー情報 | Key.find_by(id: key_id) | Yes |
| @user | ユーザー情報 | @key.user | Yes |
| @current_user | 現在のユーザー（@userと同じ） | @user | Yes |
| @target_url | ユーザープロフィールURL | user_url(@user) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| SSHキー追加 | Key#post_create_hook | ユーザーが通知受信可能、デプロイキーでない | 新規SSHキー作成時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知受信不可 | user.can?(:receive_notifications)がfalseの場合は送信しない |
| キー未検出 | Key.find_by(id: key_id)がnilの場合は送信しない |
| 内部ユーザー | ゴーストユーザーやサポートボットなどの内部ユーザーには送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SSHキー作成] --> B[new_key呼び出し]
    B --> C{デプロイキー?}
    C -->|Yes| D[送信スキップ]
    C -->|No| E{user.can?:receive_notifications}
    E -->|No| D
    E -->|Yes| F[new_ssh_key_email呼び出し]
    F --> G[Key.find_by実行]
    G --> H{キー存在?}
    H -->|No| D
    H -->|Yes| I[@key, @user設定]
    I --> J[email_with_layout実行]
    J --> K[deliver_later]
    K --> L[終了]
    D --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| keys | SSHキー情報取得 | |
| users | ユーザー情報取得 | |

### テーブル別参照項目詳細

#### keys

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | キーID | 引数から取得 |
| title | キータイトル | |
| user_id | ユーザー参照 | |
| type | キータイプ | デプロイキー判定 |

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | keys.user_id |
| name | ユーザー名 | |
| notification_email | 通知用メールアドレス | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キー未検出 | key_idに対応するキーが存在しない | 早期リターン（nilを返す） |
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- セキュリティ通知のため、ユーザーの通知設定に関係なく送信（can?(:receive_notifications)は内部ユーザー判定のみ）
- SSHキーの公開鍵内容自体はメールに含まれない
- 削除用リンクは認証後のみアクセス可能

## 備考

- Key.find_byを使用することで、キーが削除済みの場合は通知をスキップ
- デプロイキーの追加時は別の通知ロジックが使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SSHキーモデルの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | key.rb | `app/models/key.rb` | Keyモデルの基本属性、belongs_to :user、post_create_hookを確認 |

**読解のコツ**: `after_create :post_create_hook`のコールバックに注目し、キー作成時の処理フローを理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | new_keyメソッド（84-88行目）がエントリーポイント |

**主要処理フロー**:
1. **84行目**: メソッド定義、keyを引数として受け取る
2. **85行目**: `key.user&.can?(:receive_notifications)`で通知可能か確認
3. **86行目**: new_ssh_key_email呼び出し

#### Step 3: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profile.rb | `app/mailers/emails/profile.rb` | new_ssh_key_emailメソッド（41-50行目）の実装 |

**主要処理フロー**:
- **41行目**: メソッド定義、key_idを引数として受け取る
- **42行目**: Key.find_byでキー情報取得
- **44行目**: キーが存在しない場合は早期リターン
- **46-49行目**: 変数設定とemail_with_layout呼び出し

#### Step 4: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new_ssh_key_email.html.haml | `app/views/notify/new_ssh_key_email.html.haml` | HTML版テンプレート |
| 4-2 | new_ssh_key_email.text.erb | `app/views/notify/new_ssh_key_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
Key#post_create_hook
    │
    └─ NotificationService#new_key (84-88行目)
           │
           ├─ key.user&.can?(:receive_notifications) (85行目)
           │
           └─ Notify#new_ssh_key_email (86行目)
                  └─ Emails::Profile#new_ssh_key_email (41-50行目)
                         ├─ Key.find_by(id: key_id) (42行目)
                         └─ email_with_layout (48-49行目)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

SSHキー作成イベント ───▶ NotificationService            ───▶ メール送信キュー
(key)                    │                                    (Sidekiq)
                         ├─ 通知可能判定
                         │   └─ can?(:receive_notifications)
                         │
                         └─ new_ssh_key_email
                              │
                              ├─ @key (SSHキー情報)
                              │    └─ title
                              └─ @user (ユーザー情報)
                                   └─ name
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| key.rb | `app/models/key.rb` | ソース | SSHキーモデル |
| new_ssh_key_email.html.haml | `app/views/notify/new_ssh_key_email.html.haml` | テンプレート | HTML版メールテンプレート |
| new_ssh_key_email.text.erb | `app/views/notify/new_ssh_key_email.text.erb` | テンプレート | テキスト版メールテンプレート |
