# 通知設計書 48-new_gpg_key_email

## 概要

本ドキュメントは、GitLabにおけるGPGキー追加通知（new_gpg_key_email）の設計仕様を定義するものである。

### 本通知の処理概要

ユーザーのアカウントに新しいGPGキーが追加された際に、該当ユーザーにセキュリティ通知を送信する機能である。

**業務上の目的・背景**：GPGキーはGitコミットの署名検証に使用される重要な認証情報である。新しいGPGキーの追加はセキュリティに影響を与える操作であるため、アカウント所有者に通知することで、不正なキー追加を早期に検知できるようにする。これはセキュリティメールであり、ユーザーの通知設定に関係なく送信される。

**通知の送信タイミング**：GPGキーがユーザーアカウントに追加された直後にトリガーされる。

**通知の受信者**：GPGキーが追加されたユーザー本人（通知を受け取る権限がある場合）。

**通知内容の概要**：追加されたGPGキーのフィンガープリント、削除用リンクが含まれる。

**期待されるアクション**：ユーザーは追加されたキーが自身によるものか確認し、不正な場合は即座に削除する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. 追加されたGPGキーからユーザーを取得
2. `user.can?(:receive_notifications)`で通知受信権限を確認
3. ユーザーの通知メールアドレス（notification_email_or_default）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `GPG key was added to your account` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hi {ユーザー名}!

A new GPG key was added to your account:

Fingerprint: {フィンガープリント}

If this key was added in error, you can remove it under GPG keys:
{GPGキー設定URL}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @gpg_key | GPGキー情報 | GpgKey.find_by(id: gpg_key_id) | Yes |
| @user | ユーザー情報 | @gpg_key.user | Yes |
| @current_user | 現在のユーザー（@userと同じ） | @user | Yes |
| @target_url | ユーザープロフィールURL | user_url(@user) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GPGキー追加 | GpgKey作成 | ユーザーが通知受信可能 | 新規GPGキー作成時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知受信不可 | user.can?(:receive_notifications)がfalseの場合は送信しない |
| キー未検出 | GpgKey.find_by(id: gpg_key_id)がnilの場合は送信しない |
| 内部ユーザー | ゴーストユーザーやサポートボットなどの内部ユーザーには送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GPGキー作成] --> B[new_gpg_key呼び出し]
    B --> C{user.can?:receive_notifications}
    C -->|No| D[送信スキップ]
    C -->|Yes| E[new_gpg_key_email呼び出し]
    E --> F[GpgKey.find_by実行]
    F --> G{キー存在?}
    G -->|No| D
    G -->|Yes| H[@gpg_key, @user設定]
    H --> I[email_with_layout実行]
    I --> J[deliver_later]
    J --> K[終了]
    D --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| gpg_keys | GPGキー情報取得 | |
| users | ユーザー情報取得 | |

### テーブル別参照項目詳細

#### gpg_keys

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | キーID | 引数から取得 |
| fingerprint | フィンガープリント | |
| user_id | ユーザー参照 | |

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | gpg_keys.user_id |
| name | ユーザー名 | |
| notification_email | 通知用メールアドレス | |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キー未検出 | gpg_key_idに対応するキーが存在しない | 早期リターン（nilを返す） |
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- セキュリティ通知のため、ユーザーの通知設定に関係なく送信
- GPGキーの公開鍵内容自体はメールに含まれない（フィンガープリントのみ）
- 削除用リンクは認証後のみアクセス可能

## 備考

- GpgKey.find_byを使用することで、キーが削除済みの場合は通知をスキップ
- フィンガープリントは大文字で表示される（upcase処理）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、GPGキーモデルの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gpg_key.rb | `app/models/gpg_key.rb` | GpgKeyモデルの基本属性、belongs_to :user、fingerprintの処理を確認 |

**読解のコツ**: `fingerprint`メソッドの`upcase`処理に注目し、表示形式を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | new_gpg_keyメソッド（94-98行目）がエントリーポイント |

**主要処理フロー**:
1. **94行目**: メソッド定義、gpg_keyを引数として受け取る
2. **95行目**: `gpg_key.user&.can?(:receive_notifications)`で通知可能か確認
3. **96行目**: new_gpg_key_email呼び出し

#### Step 3: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profile.rb | `app/mailers/emails/profile.rb` | new_gpg_key_emailメソッド（54-64行目）の実装 |

**主要処理フロー**:
- **54行目**: メソッド定義、gpg_key_idを引数として受け取る
- **55行目**: GpgKey.find_byでキー情報取得
- **57行目**: キーが存在しない場合は早期リターン
- **59-63行目**: 変数設定とemail_with_layout呼び出し

#### Step 4: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new_gpg_key_email.html.haml | `app/views/notify/new_gpg_key_email.html.haml` | HTML版テンプレート |
| 4-2 | new_gpg_key_email.text.erb | `app/views/notify/new_gpg_key_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
NotificationService#new_gpg_key (94-98行目)
    │
    ├─ gpg_key.user&.can?(:receive_notifications) (95行目)
    │
    └─ Notify#new_gpg_key_email (96行目)
           └─ Emails::Profile#new_gpg_key_email (54-64行目)
                  ├─ GpgKey.find_by(id: gpg_key_id) (55行目)
                  └─ email_with_layout (61-63行目)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

GPGキー作成イベント ───▶ NotificationService            ───▶ メール送信キュー
(gpg_key)                │                                    (Sidekiq)
                         ├─ 通知可能判定
                         │   └─ can?(:receive_notifications)
                         │
                         └─ new_gpg_key_email
                              │
                              ├─ @gpg_key (GPGキー情報)
                              │    └─ fingerprint
                              └─ @user (ユーザー情報)
                                   └─ name
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| gpg_key.rb | `app/models/gpg_key.rb` | ソース | GPGキーモデル |
| new_gpg_key_email.html.haml | `app/views/notify/new_gpg_key_email.html.haml` | テンプレート | HTML版メールテンプレート |
| new_gpg_key_email.text.erb | `app/views/notify/new_gpg_key_email.text.erb` | テンプレート | テキスト版メールテンプレート |
