# 通知設計書 50-access_token_created_email

## 概要

本ドキュメントは、GitLabにおける個人アクセストークン作成通知（access_token_created_email）の設計仕様を定義するものである。

### 本通知の処理概要

ユーザーの個人アクセストークンが新しく作成された際に、アカウント所有者にセキュリティ通知を送信する機能である。

**業務上の目的・背景**：個人アクセストークン（PAT）はGitLab APIへのアクセスに使用される重要な認証情報である。新しいトークンの作成はセキュリティに影響を与える操作であるため、アカウント所有者に通知することで、不正なトークン作成を早期に検知できるようにする。これはセキュリティメールであり、ユーザーが自身のアカウントで行われた操作を把握するために重要である。

**通知の送信タイミング**：個人アクセストークンがユーザーアカウントに作成された直後にトリガーされる。

**通知の受信者**：トークンが作成されたユーザー本人（アクティブなユーザーで通知を受け取る権限がある場合）。

**通知内容の概要**：作成されたトークンの名前、トークン管理画面へのリンクが含まれる。

**期待されるアクション**：ユーザーは作成されたトークンが自身によるものか確認し、不正な場合は即座にトークンを取り消す。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ機能に依存 |

### 送信先決定ロジック

1. トークンが作成されたユーザーを取得
2. `user.can?(:receive_notifications)`で通知受信権限を確認
3. ユーザーがアクティブであることを確認（user.active?）
4. ユーザーの通知メールアドレス（notification_email_or_default）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabインスタンスのデフォルト送信アドレス |
| 送信元名称 | GitLab |
| 件名 | `A new personal access token has been created` |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hi {ユーザー名}!

A new personal access token, named {トークン名}, has been created.

You can check it in your personal access tokens settings:
{個人アクセストークン設定URL}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | ユーザー情報 | 引数user | Yes |
| @token_name | トークン名 | 引数token_name | Yes |
| @target_url | 個人アクセストークン設定URL | user_settings_personal_access_tokens_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| トークン作成 | PersonalAccessToken作成 | ユーザーがアクティブで通知受信可能 | 新規PAT作成時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 通知受信不可 | user.can?(:receive_notifications)がfalseの場合は送信しない |
| 非アクティブユーザー | user.active?がfalseの場合は送信しない |
| ユーザーがnil | userがnilの場合は送信しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[トークン作成] --> B[access_token_created呼び出し]
    B --> C{user.can?:receive_notifications}
    C -->|No| D[送信スキップ]
    C -->|Yes| E[access_token_created_email呼び出し]
    E --> F{user&.active?}
    F -->|No| D
    F -->|Yes| G[@user, @token_name設定]
    G --> H[email_with_layout実行]
    H --> I[deliver_later]
    I --> J[終了]
    D --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | |
| personal_access_tokens | トークン情報参照 | トークン名は引数で渡される |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザーID | 引数から取得 |
| name | ユーザー名 | |
| notification_email | 通知用メールアドレス | |
| state | ユーザー状態 | active判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知処理ではDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザー非アクティブ | user.active?がfalse | 早期リターン |
| 送信失敗 | メールサーバー接続エラー | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | ネットワークエラー、一時的なサーバーエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabインスタンス設定による |
| 1日あたり上限 | GitLabインスタンス設定による |

### 配信時間帯

特に制限なし

## セキュリティ考慮事項

- トークン値自体はメールに含まれない（トークン名のみ）
- セキュリティ通知のため重要度が高い
- 個人アクセストークン設定リンクは認証後のみアクセス可能

## 備考

- user&.active?の二重チェックにより、非アクティブユーザーへの通知を確実に防止
- NotificationServiceとメーラーの両方でアクティブチェックを実施

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、PersonalAccessTokenモデルの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | personal_access_token.rb | `app/models/personal_access_token.rb` | トークンの基本属性、nameカラム、belongs_to :userを確認 |

**読解のコツ**: `belongs_to :user`の関連に注目し、トークンとユーザーの関係を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるNotificationServiceを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | access_token_createdメソッド（118-122行目）がエントリーポイント |

**主要処理フロー**:
1. **118行目**: メソッド定義、userとtoken_nameを引数として受け取る
2. **119行目**: `user.can?(:receive_notifications)`で通知可能か確認
3. **121行目**: access_token_created_email呼び出し

#### Step 3: メーラー層を理解する

メール生成処理の詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profile.rb | `app/mailers/emails/profile.rb` | access_token_created_emailメソッド（92-103行目）の実装 |

**主要処理フロー**:
- **92行目**: メソッド定義、userとtoken_nameを引数として受け取る
- **93行目**: `user&.active?`でアクティブチェック
- **95-97行目**: @user、@target_url、@token_name変数設定
- **99-102行目**: email_with_layoutでメール生成

#### Step 4: ビューテンプレートを理解する

メール本文の生成を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | access_token_created_email.html.haml | `app/views/notify/access_token_created_email.html.haml` | HTML版テンプレート |
| 4-2 | access_token_created_email.text.erb | `app/views/notify/access_token_created_email.text.erb` | テキスト版テンプレート |

### プログラム呼び出し階層図

```
NotificationService#access_token_created (118-122行目)
    │
    ├─ user.can?(:receive_notifications) (119行目)
    │
    └─ Notify#access_token_created_email (121行目)
           └─ Emails::Profile#access_token_created_email (92-103行目)
                  ├─ user&.active? チェック (93行目)
                  └─ email_with_layout (99-102行目)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

トークン作成イベント ───▶ NotificationService            ───▶ メール送信キュー
(user, token_name)       │                                    (Sidekiq)
                         ├─ 通知可能判定
                         │   └─ can?(:receive_notifications)
                         │
                         └─ access_token_created_email
                              │
                              ├─ アクティブ判定
                              │   └─ user&.active?
                              │
                              ├─ @user (ユーザー情報)
                              ├─ @token_name (トークン名)
                              └─ @target_url (設定URL)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知処理のオーケストレーション |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | プロファイル関連メール定義 |
| notify.rb | `app/mailers/notify.rb` | ソース | メーラー基底クラス |
| personal_access_token.rb | `app/models/personal_access_token.rb` | ソース | トークンモデル |
| access_token_created_email.html.haml | `app/views/notify/access_token_created_email.html.haml` | テンプレート | HTML版メールテンプレート |
| access_token_created_email.text.erb | `app/views/notify/access_token_created_email.text.erb` | テンプレート | テキスト版メールテンプレート |
