# 通知設計書 52-access_token_expired_email

## 概要

本ドキュメントは、GitLabにおける個人アクセストークン期限切れ通知（access_token_expired_email）の設計内容を記載する。

### 本通知の処理概要

**業務上の目的・背景**：個人アクセストークン（PAT）が期限切れになると、APIアクセスやGit操作の認証が失敗し、CI/CDパイプラインや自動化スクリプトが動作を停止する。本通知は、トークンが当日に期限切れとなったことをユーザーに通知し、迅速な対応を促すことで、業務影響を最小限に抑えることを目的とする。

**通知の送信タイミング**：定期的なcronジョブ（PersonalAccessTokens::ExpiredNotificationWorker）により、当日期限切れとなったトークンを検出し、通知を送信する。

**通知の受信者**：期限切れトークンを所有するアクティブなユーザー本人。ユーザーが通知を受信できる権限（receive_notifications）を持っている必要がある。

**通知内容の概要**：期限切れとなったトークンの名前一覧（存在する場合）と、個人アクセストークン設定画面へのリンクが含まれる。

**期待されるアクション**：受信者は通知を受け取った後、個人アクセストークン設定画面にアクセスし、新しいトークンを作成して期限切れトークンを置き換えることが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高 |
| リトライ | Sidekiq標準リトライ機構に依存 |

### 送信先決定ロジック

トークンを所有するユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信される。ユーザーが`can?(:receive_notifications)`を満たし、かつ`active?`である場合のみ送信が実行される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定に基づく |
| 送信元名称 | GitLab |
| 件名 | "Your personal access tokens have expired" |
| 形式 | テキスト |

### 本文テンプレート

```
Hi {username}!

The following personal access tokens have expired:

  - {token_name_1}
  - {token_name_2}
  ...

（トークン名がない場合）
One or more of your personal access tokens have expired.

You can create a new one or check them in your personal access tokens settings {pat_link}.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @token_names | 期限切れトークン名の配列 | PersonalAccessToken.name | No |
| @target_url | 個人アクセストークン設定URL | user_settings_personal_access_tokens_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール（Cron） | PersonalAccessTokens::ExpiredNotificationWorker | トークンが当日期限切れ | 毎日実行されるワーカーで当日期限切れトークンを検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが通知不可 | user.can?(:receive_notifications)がfalseの場合 |
| ユーザーが非アクティブ | user.active?がfalseの場合 |
| 既に通知済み | after_expiry_notification_deliveredがtrueの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Cronジョブ実行] --> B[ExpiredNotificationWorker.perform]
    B --> C[当日期限切れユーザー取得]
    C --> D{ユーザー存在?}
    D -->|No| E[終了]
    D -->|Yes| F[期限切れトークン取得]
    F --> G[トークン名取得（最大100件）]
    G --> H[notification_service.access_token_expired]
    H --> I[Emails::Profile.access_token_expired_email]
    I --> J[deliver_later]
    J --> K[通知済みフラグ更新]
    K --> L[次のユーザーへ]
    L --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | with_personal_access_tokens_expired_todayスコープ |
| personal_access_tokens | トークン情報取得 | expired_today_and_not_notifiedスコープ |

### テーブル別参照項目詳細

#### personal_access_tokens

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | トークン名 | 通知メール本文に記載 |
| expires_at | 有効期限 | 当日期限切れ判定 |
| user_id | 所有者ID | ユーザー特定 |
| after_expiry_notification_delivered | 通知済みフラグ | 送信済み判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| personal_access_tokens | UPDATE | 通知送信済みフラグを更新 |

#### personal_access_tokens更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | after_expiry_notification_delivered | true | 各バッチごとに更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メール送信エラー | Sidekiqリトライ |
| ユーザー非アクティブ | ユーザーが削除・無効化済み | 処理スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab設定に依存 |
| 1日あたり上限 | 特になし |

### 配信時間帯

Cronジョブの実行スケジュールに依存。通常は毎日実行。

## セキュリティ考慮事項

- トークン名のみを通知に含め、トークン値自体は含まれない
- 通知はトークン所有者本人にのみ送信される
- ユーザーがアクティブでない場合は送信をスキップ

## 備考

- 最大100件のトークン名がメールに含まれる（MAX_TOKENS = 100）
- トークン名がない場合は汎用メッセージが表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | personal_access_token.rb | `app/models/personal_access_token.rb` | expired_today_and_not_notifiedスコープを確認 |
| 1-2 | user.rb | `app/models/user.rb` | with_personal_access_tokens_expired_todayスコープを確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | expired_notification_worker.rb | `app/workers/personal_access_tokens/expired_notification_worker.rb` | performメソッドの処理フロー |

**主要処理フロー**:
1. **18行目**: User.with_personal_access_tokens_expired_todayでユーザー取得
2. **20行目**: expired_today_and_not_notifiedでトークン取得
3. **25行目**: token_namesを最大100件まで取得
4. **28行目**: notification_service.access_token_expired呼び出し
5. **32-33行目**: 通知済みフラグを更新

#### Step 3: NotificationServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification_service.rb | `app/services/notification_service.rb` | access_token_expiredメソッド（135-139行目） |

#### Step 4: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | profile.rb | `app/mailers/emails/profile.rb` | access_token_expired_emailメソッド（125-136行目） |

**主要処理フロー**:
- **126行目**: ユーザー存在・アクティブチェック
- **129行目**: @token_namesにトークン名を設定
- **134行目**: 件名「Your personal access tokens have expired」

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | access_token_expired_email.text.erb | `app/views/notify/access_token_expired_email.text.erb` | 条件分岐（トークン名の有無） |

### プログラム呼び出し階層図

```
PersonalAccessTokens::ExpiredNotificationWorker#perform
    │
    ├─ User.with_personal_access_tokens_expired_today
    │      └─ find_each (バッチ処理)
    │
    └─ with_context(user:)
           ├─ user.personal_access_tokens.expired_today_and_not_notified
           ├─ token_names取得（最大100件）
           ├─ NotificationService#access_token_expired
           │      └─ Notify#access_token_expired_email
           │             └─ email_with_layout
           └─ update_all(after_expiry_notification_delivered: true)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

users                   ──▶ ExpiredNotificationWorker ──▶ メール送信
  (expired_today)           ├─ 期限切れ当日判定             │
                            ├─ トークン名取得               ▼
personal_access_tokens  ──▶ └─ NotificationService    ──▶ Sidekiq Job
  (after_expiry_              └─ Emails::Profile          (deliver_later)
   notification_delivered)        └─ テンプレート展開
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| expired_notification_worker.rb | `app/workers/personal_access_tokens/expired_notification_worker.rb` | ソース | Cronワーカー |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | メーラー |
| access_token_expired_email.text.erb | `app/views/notify/access_token_expired_email.text.erb` | テンプレート | メール本文 |
| personal_access_token.rb | `app/models/personal_access_token.rb` | ソース | トークンモデル |
