# 通知設計書 54-access_token_rotated_email

## 概要

本ドキュメントは、GitLabにおける個人アクセストークンローテーション通知（access_token_rotated_email）の設計内容を記載する。

### 本通知の処理概要

**業務上の目的・背景**：個人アクセストークン（PAT）のローテーションは、セキュリティベストプラクティスとして定期的なトークン更新を促進する機能である。トークンがローテーション（自動更新）された際にユーザーに通知することで、意図しないトークン変更の検知や、新しいトークン情報の確認を促す。

**通知の送信タイミング**：トークンのローテーション処理が完了した時点で即座に通知が送信される。

**通知の受信者**：ローテーションされたトークンを所有するアクティブなユーザー本人。

**通知内容の概要**：ローテーションされたトークンの名前と、個人アクセストークン設定画面へのリンクが含まれる。

**期待されるアクション**：受信者は通知を受け取った後、個人アクセストークン設定画面にアクセスし、新しいトークン値を確認して、使用中のシステムやスクリプトの認証情報を更新する。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiq標準リトライ機構に依存 |

### 送信先決定ロジック

トークンを所有するユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信される。ユーザーが`can?(:receive_notifications)`を満たし、かつ`active?`である場合のみ送信が実行される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定に基づく |
| 送信元名称 | GitLab |
| 件名 | "Your personal access token has been rotated" |
| 形式 | テキスト |

### 本文テンプレート

```
Hi {username}!

Your personal access token, named {token_name}, has been rotated.

You can view it in your personal access tokens settings {pat_link}.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @token_name | ローテーションされたトークン名 | PersonalAccessToken.name | Yes |
| @target_url | 個人アクセストークン設定URL | user_settings_personal_access_tokens_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API | トークンローテーション | トークン所有者がアクティブ | APIによるトークンローテーション実行時 |
| 自動処理 | 自動ローテーション | トークン所有者がアクティブ | スケジュールされた自動ローテーション実行時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが通知不可 | user.can?(:receive_notifications)がfalseの場合 |
| ユーザーが非アクティブ | user.active?がfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[トークンローテーション要求] --> B[ローテーション処理実行]
    B --> C[NotificationService.access_token_rotated]
    C --> D{通知可能?}
    D -->|No| E[送信スキップ]
    D -->|Yes| F[Emails::Profile.access_token_rotated_email]
    F --> G{ユーザーアクティブ?}
    G -->|No| E
    G -->|Yes| H[email_with_layout]
    H --> I[deliver_later]
    I --> J[終了]
    E --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | |
| personal_access_tokens | トークン情報取得 | ローテーション後の新トークン |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | ユーザー名 | メール本文の挨拶 |
| notification_email | 通知先メールアドレス | |

### 更新テーブル一覧

本通知処理では更新は行わない（トークンローテーション処理は別処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メール送信エラー | Sidekiqリトライ |
| ユーザー非アクティブ | ユーザーが削除・無効化済み | 処理スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab設定に依存 |
| 1日あたり上限 | 特になし |

### 配信時間帯

制限なし（イベント発生時に即座に送信）

## セキュリティ考慮事項

- トークン名のみを通知に含め、新しいトークン値自体は含まれない
- ユーザーは設定画面で新しいトークン値を確認する必要がある
- 通知はトークン所有者本人にのみ送信される

## 備考

- トークンローテーションは自動または手動（API経由）で実行される
- 新しいトークン値はメールには含まれないため、ユーザーは設定画面で確認する必要がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | personal_access_token.rb | `app/models/personal_access_token.rb` | トークンのローテーション関連メソッド |

#### Step 2: NotificationServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | access_token_rotatedメソッド（149-153行目） |

**主要処理フロー**:
- **149行目**: user.can?(:receive_notifications)チェック
- **152行目**: mailer.access_token_rotated_email呼び出し

#### Step 3: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profile.rb | `app/mailers/emails/profile.rb` | access_token_rotated_emailメソッド（152-163行目） |

**主要処理フロー**:
- **153行目**: user.active?チェック
- **157行目**: @target_urlに設定画面URLを設定
- **161行目**: 件名「Your personal access token has been rotated」

#### Step 4: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | access_token_rotated_email.text.erb | `app/views/notify/access_token_rotated_email.text.erb` | メール本文 |

### プログラム呼び出し階層図

```
トークンローテーション処理
    │
    └─ NotificationService#access_token_rotated(user, token_name)
           │
           ├─ user.can?(:receive_notifications) チェック
           │
           └─ Notify#access_token_rotated_email(user, token_name)
                  │
                  ├─ user.active? チェック
                  │
                  └─ email_with_layout
                         └─ access_token_rotated_email.text.erb
```

### データフロー図

```
[入力]                    [処理]                         [出力]

トークンローテーション ──▶ RotateService              ──▶ 新トークン生成
  要求                     ├─ 旧トークン無効化             │
  (user, token_name)       ├─ 新トークン生成               ▼
                           └─ NotificationService      ──▶ メール送信
                               └─ Emails::Profile          (deliver_later)
                                   └─ テンプレート展開
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | メーラー |
| access_token_rotated_email.text.erb | `app/views/notify/access_token_rotated_email.text.erb` | テンプレート | メール本文 |
