# 通知設計書 55-deploy_token_about_to_expire_email

## 概要

本ドキュメントは、GitLabにおけるデプロイトークン期限切れ事前通知（deploy_token_about_to_expire_email）の設計内容を記載する。

### 本通知の処理概要

**業務上の目的・背景**：デプロイトークンは、CI/CDパイプラインやコンテナレジストリへのアクセスに使用される認証情報である。トークンが予期せず期限切れになると、デプロイメントプロセスが中断し、本番環境への影響が発生する可能性がある。本通知は、デプロイトークンの期限切れ前にプロジェクトのOwnerとMaintainerに警告を発し、事前に更新作業を行う機会を提供する。

**通知の送信タイミング**：定期的なcronジョブ（DeployTokens::ExpiringWorker）により、有効期限が近づいているデプロイトークンを検出し、通知を送信する。通知間隔は7日、30日などが設定可能。

**通知の受信者**：デプロイトークンが設定されているプロジェクトのOwnerおよびMaintainer。ユーザーが通知を受信できる権限（receive_notifications）を持っている必要がある。

**通知内容の概要**：期限切れが近いデプロイトークンの名前、プロジェクトパス、残り日数、デプロイトークン設定画面へのリンクが含まれる。

**期待されるアクション**：受信者は通知を受け取った後、プロジェクトのデプロイトークン設定画面にアクセスし、新しいデプロイトークンを作成して既存のトークンを置き換えることが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiq標準リトライ機構に依存 |

### 送信先決定ロジック

プロジェクトのOwnerおよびMaintainerの`notification_email_or_default`メソッドで取得されるメールアドレスに送信される。ユーザーが`can?(:receive_notifications)`を満たし、かつプロジェクトのOwnerまたはMaintainerである場合のみ送信が実行される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定に基づく |
| 送信元名称 | GitLab |
| 件名 | "Your deploy token will expire in {days_to_expire} days or less" |
| 形式 | テキスト |

### 本文テンプレート

```
Hi {username}!

Your project deploy token {token_name} for {project_path} will expire in {days_to_expire} day(s) or less.

You can create a new one or check them in your deploy tokens settings: {target_url}

You are receiving this email because you are {role} of the project.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @token_name | デプロイトークン名 | DeployToken.name | Yes |
| @project | プロジェクト | Project | Yes |
| @days_to_expire | 期限切れまでの日数 | パラメータ（デフォルト7日） | Yes |
| @target_url | デプロイトークン設定URL | project_settings_repository_url | Yes |
| @user_role | ユーザーの役割 | Owner/Maintainer | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール（Cron） | DeployTokens::ExpiringWorker | トークンの有効期限が設定日数以内 | 毎日実行されるワーカーで期限切れが近いトークンを検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが通知不可 | user.can?(:receive_notifications)がfalseの場合 |
| ユーザーがOwner/Maintainerでない | プロジェクトのOwnerまたはMaintainerでない場合 |
| 既に通知済み | 該当interval_notification_sent_atが設定済みの場合 |
| フィーチャーフラグ無効 | project_deploy_token_expiring_notificationsが無効の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Cronジョブ実行] --> B[DeployTokens::ExpiringWorker.perform]
    B --> C[通知間隔ループ]
    C --> D[期限切れ近いトークン取得]
    D --> E{トークン存在?}
    E -->|No| F[次の間隔へ]
    E -->|Yes| G[プロジェクト取得]
    G --> H{フィーチャーフラグ有効?}
    H -->|No| F
    H -->|Yes| I[Owner/Maintainer取得]
    I --> J{ユーザー存在?}
    J -->|No| F
    J -->|Yes| K[notification_service.deploy_token_about_to_expire]
    K --> L[Emails::Profile.deploy_token_about_to_expire_email]
    L --> M[deliver_later]
    M --> N[通知済みフラグ更新]
    N --> F
    F --> O{全間隔完了?}
    O -->|No| C
    O -->|Yes| P[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| deploy_tokens | デプロイトークン情報取得 | scope_for_notification_interval |
| projects | プロジェクト情報取得 | |
| members | メンバー情報取得 | Owner/Maintainer判定 |
| users | ユーザー情報取得 | |

### テーブル別参照項目詳細

#### deploy_tokens

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | トークン名 | 通知メール本文に記載 |
| expires_at | 有効期限 | 期限切れ判定に使用 |
| seven_days_notification_sent_at | 7日前通知送信日時 | 送信済み判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| deploy_tokens | UPDATE | 通知送信済みフラグを更新 |

#### deploy_tokens更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | seven_days_notification_sent_at | Time.current | 7日前通知の場合 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メール送信エラー | Sidekiqリトライ |
| プロジェクト不存在 | トークンに紐づくプロジェクトが削除済み | 処理スキップ |
| リソース不足 | ワーカータイムアウト | 2分後に再キュー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab設定に依存 |
| 1日あたり上限 | 特になし |

### 配信時間帯

Cronジョブの実行スケジュールに依存。

## セキュリティ考慮事項

- トークン名のみを通知に含め、トークン値自体は含まれない
- 通知はプロジェクトのOwnerおよびMaintainerにのみ送信される
- ユーザーの役割（Owner/Maintainer）を明示

## 備考

- BATCH_SIZE = 100でバッチ処理
- MAX_RUNTIME = 3分、REQUEUE_DELAY = 2分
- Feature.enabled?(:project_deploy_token_expiring_notifications)で制御可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deploy_token.rb | `app/models/deploy_token.rb` | NOTIFICATION_INTERVALS、scope_for_notification_interval |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | expiring_worker.rb | `app/workers/deploy_tokens/expiring_worker.rb` | performメソッドの処理フロー |

**主要処理フロー**:
1. **20-28行目**: notification_intervalsでループ
2. **41-74行目**: process_deploy_tokensでトークン処理
3. **77-112行目**: notify_users_of_deploy_tokenで各ユーザーに通知

#### Step 3: NotificationServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification_service.rb | `app/services/notification_service.rb` | deploy_token_about_to_expireメソッド（156-163行目） |

#### Step 4: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | profile.rb | `app/mailers/emails/profile.rb` | deploy_token_about_to_expire_emailメソッド（165-183行目） |

**主要処理フロー**:
- **173行目**: @user_roleにOwner/Maintainerを設定
- **177-180行目**: 件名に残り日数を含める

#### Step 5: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | deploy_token_about_to_expire_email.text.erb | `app/views/notify/deploy_token_about_to_expire_email.text.erb` | メール本文 |

### プログラム呼び出し階層図

```
DeployTokens::ExpiringWorker#perform
    │
    ├─ notification_intervals (7日、30日など)
    │      └─ process_deploy_tokens(interval)
    │             ├─ DeployToken.scope_for_notification_interval
    │             ├─ Feature.enabled?チェック
    │             └─ notify_users_of_deploy_token
    │                    └─ NotificationService#deploy_token_about_to_expire
    │                           └─ Notify#deploy_token_about_to_expire_email
    │                                  └─ email_with_layout
    │
    └─ DeployToken.update_notification_timestamps
```

### データフロー図

```
[入力]                    [処理]                         [出力]

deploy_tokens           ──▶ ExpiringWorker            ──▶ メール送信
  (expires_at,              ├─ 期限チェック                 │
   notification_sent_at)    ├─ プロジェクト取得              ▼
                            ├─ Owner/Maintainer取得    ──▶ Sidekiq Job
projects                ──▶ └─ NotificationService        (deliver_later)
  (id)                          └─ Emails::Profile
                                     └─ テンプレート展開
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| expiring_worker.rb | `app/workers/deploy_tokens/expiring_worker.rb` | ソース | Cronワーカー |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | メーラー |
| deploy_token_about_to_expire_email.text.erb | `app/views/notify/deploy_token_about_to_expire_email.text.erb` | テンプレート | メール本文 |
| deploy_token.rb | `app/models/deploy_token.rb` | ソース | トークンモデル |
| notify_preview.rb | `app/mailers/previews/notify_preview.rb` | ソース | メールプレビュー |
